--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET lock_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;


--
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language';


SET search_path = public, pg_catalog;

--
-- Name: update_search_index_tsvector(); Type: FUNCTION; Schema: public; Owner: wc-sample.pos
--

CREATE FUNCTION update_search_index_tsvector() RETURNS trigger
    LANGUAGE plpgsql
    AS $$BEGIN

  NEW.data_tsv = setweight( coalesce( to_tsvector('main_ru', NEW.title),''),'A') 

      || setweight( coalesce( to_tsvector('main_ru', NEW.description),''),'B') 

      || setweight( coalesce( to_tsvector('main_ru', NEW.text),''),'C');

  RETURN NEW;

END;$$;


ALTER FUNCTION public.update_search_index_tsvector() OWNER TO "wc-sample.pos";

--
-- Name: ru_ispell; Type: TEXT SEARCH DICTIONARY; Schema: public; Owner: wc-sample.pos
--

CREATE TEXT SEARCH DICTIONARY ru_ispell (
    TEMPLATE = pg_catalog.ispell,
    dictfile = 'russian', afffile = 'russian', stopwords = 'russian' );


ALTER TEXT SEARCH DICTIONARY public.ru_ispell OWNER TO "wc-sample.pos";

--
-- Name: ru_simple; Type: TEXT SEARCH DICTIONARY; Schema: public; Owner: wc-sample.pos
--

CREATE TEXT SEARCH DICTIONARY ru_simple (
    TEMPLATE = pg_catalog.simple,
    stopwords = 'russian', accept = 'false' );


ALTER TEXT SEARCH DICTIONARY public.ru_simple OWNER TO "wc-sample.pos";

--
-- Name: ru_synonym; Type: TEXT SEARCH DICTIONARY; Schema: public; Owner: wc-sample.pos
--

CREATE TEXT SEARCH DICTIONARY ru_synonym (
    TEMPLATE = pg_catalog.synonym,
    synonyms = 'russian_synonym' );


ALTER TEXT SEARCH DICTIONARY public.ru_synonym OWNER TO "wc-sample.pos";

--
-- Name: main_ru; Type: TEXT SEARCH CONFIGURATION; Schema: public; Owner: wc-sample.pos
--

CREATE TEXT SEARCH CONFIGURATION main_ru (
    PARSER = pg_catalog."default" );

ALTER TEXT SEARCH CONFIGURATION main_ru
    ADD MAPPING FOR asciiword WITH ru_synonym, ru_ispell, russian_stem;

ALTER TEXT SEARCH CONFIGURATION main_ru
    ADD MAPPING FOR word WITH ru_synonym, ru_ispell, russian_stem;

ALTER TEXT SEARCH CONFIGURATION main_ru
    ADD MAPPING FOR numword WITH ru_simple;

ALTER TEXT SEARCH CONFIGURATION main_ru
    ADD MAPPING FOR email WITH ru_simple;

ALTER TEXT SEARCH CONFIGURATION main_ru
    ADD MAPPING FOR url WITH ru_simple;

ALTER TEXT SEARCH CONFIGURATION main_ru
    ADD MAPPING FOR sfloat WITH ru_simple;

ALTER TEXT SEARCH CONFIGURATION main_ru
    ADD MAPPING FOR hword_numpart WITH ru_simple;

ALTER TEXT SEARCH CONFIGURATION main_ru
    ADD MAPPING FOR hword_part WITH ru_synonym, ru_ispell, russian_stem;

ALTER TEXT SEARCH CONFIGURATION main_ru
    ADD MAPPING FOR hword_asciipart WITH ru_synonym, ru_ispell, russian_stem;

ALTER TEXT SEARCH CONFIGURATION main_ru
    ADD MAPPING FOR numhword WITH ru_simple;

ALTER TEXT SEARCH CONFIGURATION main_ru
    ADD MAPPING FOR asciihword WITH ru_synonym, ru_ispell, russian_stem;

ALTER TEXT SEARCH CONFIGURATION main_ru
    ADD MAPPING FOR hword WITH ru_synonym, ru_ispell, russian_stem;

ALTER TEXT SEARCH CONFIGURATION main_ru
    ADD MAPPING FOR "float" WITH ru_simple;

ALTER TEXT SEARCH CONFIGURATION main_ru
    ADD MAPPING FOR "int" WITH ru_simple;

ALTER TEXT SEARCH CONFIGURATION main_ru
    ADD MAPPING FOR uint WITH ru_simple;


ALTER TEXT SEARCH CONFIGURATION public.main_ru OWNER TO "wc-sample.pos";

--
-- Name: russian; Type: TEXT SEARCH CONFIGURATION; Schema: public; Owner: wc-sample.pos
--

CREATE TEXT SEARCH CONFIGURATION russian (
    PARSER = pg_catalog."default" );


ALTER TEXT SEARCH CONFIGURATION public.russian OWNER TO "wc-sample.pos";

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: changelog; Type: TABLE; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE TABLE changelog (
    id bigint NOT NULL,
    datetime timestamp without time zone,
    class character varying,
    class_id bigint,
    factory_key character varying,
    site_id bigint,
    user_id bigint,
    username character varying,
    action character varying,
    details text,
    CONSTRAINT changelog_class_id_check CHECK ((class_id >= 0)),
    CONSTRAINT changelog_site_id_check CHECK ((site_id >= 0)),
    CONSTRAINT changelog_user_id_check CHECK ((user_id >= 0))
);


ALTER TABLE public.changelog OWNER TO "wc-sample.pos";

--
-- Name: changelog_id_seq; Type: SEQUENCE; Schema: public; Owner: wc-sample.pos
--

CREATE SEQUENCE changelog_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.changelog_id_seq OWNER TO "wc-sample.pos";

--
-- Name: changelog_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: wc-sample.pos
--

ALTER SEQUENCE changelog_id_seq OWNED BY changelog.id;


--
-- Name: crosssite_channels_outbox; Type: TABLE; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE TABLE crosssite_channels_outbox (
    id bigint NOT NULL,
    parent_id bigint,
    dataset_name character varying,
    remotes text,
    enabled smallint,
    site_id bigint,
    CONSTRAINT crosssite_channels_outbox_parent_id_check CHECK ((parent_id >= 0)),
    CONSTRAINT crosssite_channels_outbox_site_id_check CHECK ((site_id >= 0))
);


ALTER TABLE public.crosssite_channels_outbox OWNER TO "wc-sample.pos";

--
-- Name: crosssite_channels_outbox_id_seq; Type: SEQUENCE; Schema: public; Owner: wc-sample.pos
--

CREATE SEQUENCE crosssite_channels_outbox_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.crosssite_channels_outbox_id_seq OWNER TO "wc-sample.pos";

--
-- Name: crosssite_channels_outbox_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: wc-sample.pos
--

ALTER SEQUENCE crosssite_channels_outbox_id_seq OWNED BY crosssite_channels_outbox.id;


--
-- Name: crosssite_inbox; Type: TABLE; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE TABLE crosssite_inbox (
    id bigint NOT NULL,
    datetime timestamp without time zone,
    site_id bigint,
    crosssite_id character varying,
    factory_key character varying
);


ALTER TABLE public.crosssite_inbox OWNER TO "wc-sample.pos";

--
-- Name: crosssite_inbox_id_seq; Type: SEQUENCE; Schema: public; Owner: wc-sample.pos
--

CREATE SEQUENCE crosssite_inbox_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.crosssite_inbox_id_seq OWNER TO "wc-sample.pos";

--
-- Name: crosssite_inbox_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: wc-sample.pos
--

ALTER SEQUENCE crosssite_inbox_id_seq OWNED BY crosssite_inbox.id;


--
-- Name: crosssite_outbox; Type: TABLE; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE TABLE crosssite_outbox (
    id bigint NOT NULL,
    datetime timestamp without time zone,
    crosssite_id character varying,
    factory_key character varying,
    site_id bigint,
    crosssite_channel_id bigint,
    remote_id bigint,
    remote_parent_id bigint,
    remote_site_id bigint,
    remote_site character varying
);


ALTER TABLE public.crosssite_outbox OWNER TO "wc-sample.pos";

--
-- Name: crosssite_outbox_id_seq; Type: SEQUENCE; Schema: public; Owner: wc-sample.pos
--

CREATE SEQUENCE crosssite_outbox_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.crosssite_outbox_id_seq OWNER TO "wc-sample.pos";

--
-- Name: crosssite_outbox_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: wc-sample.pos
--

ALTER SEQUENCE crosssite_outbox_id_seq OWNED BY crosssite_outbox.id;


--
-- Name: crosssite_sites; Type: TABLE; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE TABLE crosssite_sites (
    id bigint NOT NULL,
    host character varying,
    token character varying,
    enabled smallint,
    index bigint,
    site_id bigint,
    CONSTRAINT crosssite_sites_index_check CHECK ((index >= 0))
);


ALTER TABLE public.crosssite_sites OWNER TO "wc-sample.pos";

--
-- Name: crosssite_sites_id_seq; Type: SEQUENCE; Schema: public; Owner: wc-sample.pos
--

CREATE SEQUENCE crosssite_sites_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.crosssite_sites_id_seq OWNER TO "wc-sample.pos";

--
-- Name: crosssite_sites_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: wc-sample.pos
--

ALTER SEQUENCE crosssite_sites_id_seq OWNED BY crosssite_sites.id;


--
-- Name: dataset_fields; Type: TABLE; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE TABLE dataset_fields (
    id bigint NOT NULL,
    key character varying DEFAULT NULL::character varying,
    label character varying DEFAULT NULL::character varying,
    index bigint,
    dataset_name character varying,
    type character varying,
    settings text,
    enabled smallint DEFAULT 1::smallint
);


ALTER TABLE public.dataset_fields OWNER TO "wc-sample.pos";

--
-- Name: dataset_fields_id_seq; Type: SEQUENCE; Schema: public; Owner: wc-sample.pos
--

CREATE SEQUENCE dataset_fields_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.dataset_fields_id_seq OWNER TO "wc-sample.pos";

--
-- Name: dataset_fields_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: wc-sample.pos
--

ALTER SEQUENCE dataset_fields_id_seq OWNED BY dataset_fields.id;


--
-- Name: dataset_sync; Type: TABLE; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE TABLE dataset_sync (
    id bigint NOT NULL,
    host character varying,
    token character varying,
    enabled smallint,
    index bigint,
    site_id bigint,
    CONSTRAINT dataset_sync_index_check CHECK ((index >= 0))
);


ALTER TABLE public.dataset_sync OWNER TO "wc-sample.pos";

--
-- Name: dataset_sync_id_seq; Type: SEQUENCE; Schema: public; Owner: wc-sample.pos
--

CREATE SEQUENCE dataset_sync_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.dataset_sync_id_seq OWNER TO "wc-sample.pos";

--
-- Name: dataset_sync_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: wc-sample.pos
--

ALTER SEQUENCE dataset_sync_id_seq OWNED BY dataset_sync.id;


--
-- Name: datasets; Type: TABLE; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE TABLE datasets (
    name character varying DEFAULT ''::character varying NOT NULL,
    type character varying DEFAULT 'document'::character varying,
    title character varying DEFAULT NULL::character varying,
    contain_documents character varying DEFAULT 'all'::character varying,
    contain_folders character varying DEFAULT 'all'::character varying,
    child_datasets text,
    enabled smallint DEFAULT 1::smallint,
    CONSTRAINT datasets_contain_documents_check CHECK (((contain_documents)::text = ANY ((ARRAY['all'::character varying, 'none'::character varying, 'custom'::character varying])::text[]))),
    CONSTRAINT datasets_contain_folders_check CHECK (((contain_folders)::text = ANY ((ARRAY['all'::character varying, 'none'::character varying, 'custom'::character varying])::text[]))),
    CONSTRAINT datasets_type_check CHECK (((type)::text = ANY ((ARRAY['document'::character varying, 'folder'::character varying])::text[])))
);


ALTER TABLE public.datasets OWNER TO "wc-sample.pos";

--
-- Name: TABLE datasets; Type: COMMENT; Schema: public; Owner: wc-sample.pos
--

COMMENT ON TABLE datasets IS 'Datasets (objetcs) declaration';


--
-- Name: document_audio; Type: TABLE; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE TABLE document_audio (
    id bigint NOT NULL,
    file bigint,
    description text,
    datetime timestamp without time zone,
    _links_name character varying(255) DEFAULT NULL::character varying,
    _links_parent_id bigint,
    _links_index bigint,
    _links_site_id smallint,
    _links_enabled smallint
);


ALTER TABLE public.document_audio OWNER TO "wc-sample.pos";

--
-- Name: document_audio_id_seq; Type: SEQUENCE; Schema: public; Owner: wc-sample.pos
--

CREATE SEQUENCE document_audio_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.document_audio_id_seq OWNER TO "wc-sample.pos";

--
-- Name: document_audio_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: wc-sample.pos
--

ALTER SEQUENCE document_audio_id_seq OWNED BY document_audio.id;


--
-- Name: document_file; Type: TABLE; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE TABLE document_file (
    id bigint NOT NULL,
    file bigint,
    datetime timestamp without time zone,
    text text,
    description text,
    _links_name character varying(255) DEFAULT NULL::character varying,
    _links_parent_id bigint,
    _links_index bigint,
    _links_site_id smallint,
    _links_enabled smallint,
    CONSTRAINT document_file_file_check CHECK ((file >= 0))
);


ALTER TABLE public.document_file OWNER TO "wc-sample.pos";

--
-- Name: document_file_id_seq; Type: SEQUENCE; Schema: public; Owner: wc-sample.pos
--

CREATE SEQUENCE document_file_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.document_file_id_seq OWNER TO "wc-sample.pos";

--
-- Name: document_file_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: wc-sample.pos
--

ALTER SEQUENCE document_file_id_seq OWNED BY document_file.id;


--
-- Name: document_image; Type: TABLE; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE TABLE document_image (
    id bigint NOT NULL,
    file bigint,
    datetime timestamp without time zone,
    _links_name character varying(255) DEFAULT NULL::character varying,
    _links_parent_id bigint,
    _links_index bigint,
    _links_site_id smallint,
    _links_enabled smallint,
    CONSTRAINT document_image_file_check CHECK ((file >= 0))
);


ALTER TABLE public.document_image OWNER TO "wc-sample.pos";

--
-- Name: document_image_id_seq; Type: SEQUENCE; Schema: public; Owner: wc-sample.pos
--

CREATE SEQUENCE document_image_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.document_image_id_seq OWNER TO "wc-sample.pos";

--
-- Name: document_image_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: wc-sample.pos
--

ALTER SEQUENCE document_image_id_seq OWNED BY document_image.id;


--
-- Name: document_news; Type: TABLE; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE TABLE document_news (
    id bigint NOT NULL,
    datetime timestamp without time zone,
    description text,
    text text,
    image bigint,
    is_main smallint,
    _links_name character varying(255) DEFAULT NULL::character varying,
    _links_parent_id bigint,
    _links_index bigint,
    _links_site_id smallint,
    _links_enabled smallint,
    CONSTRAINT document_news_image_check CHECK ((image >= 0))
);


ALTER TABLE public.document_news OWNER TO "wc-sample.pos";

--
-- Name: document_news_id_seq; Type: SEQUENCE; Schema: public; Owner: wc-sample.pos
--

CREATE SEQUENCE document_news_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.document_news_id_seq OWNER TO "wc-sample.pos";

--
-- Name: document_news_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: wc-sample.pos
--

ALTER SEQUENCE document_news_id_seq OWNED BY document_news.id;


--
-- Name: document_text; Type: TABLE; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE TABLE document_text (
    id bigint NOT NULL,
    text text,
    datetime timestamp without time zone DEFAULT now(),
    image bigint DEFAULT 0,
    description text,
    _links_name character varying(255) DEFAULT NULL::character varying,
    _links_parent_id bigint,
    _links_index bigint,
    _links_site_id smallint,
    _links_enabled smallint,
    CONSTRAINT document_text_image_check CHECK ((image >= 0))
);


ALTER TABLE public.document_text OWNER TO "wc-sample.pos";

--
-- Name: document_text_id_seq; Type: SEQUENCE; Schema: public; Owner: wc-sample.pos
--

CREATE SEQUENCE document_text_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.document_text_id_seq OWNER TO "wc-sample.pos";

--
-- Name: document_text_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: wc-sample.pos
--

ALTER SEQUENCE document_text_id_seq OWNED BY document_text.id;


--
-- Name: document_video; Type: TABLE; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE TABLE document_video (
    id bigint NOT NULL,
    file bigint,
    image bigint,
    description text,
    datetime timestamp without time zone,
    _links_name character varying(255) DEFAULT NULL::character varying,
    _links_parent_id bigint,
    _links_index bigint,
    _links_site_id smallint,
    _links_enabled smallint,
    CONSTRAINT document_video_file_check CHECK ((file >= 0)),
    CONSTRAINT document_video_image_check CHECK ((image >= 0))
);


ALTER TABLE public.document_video OWNER TO "wc-sample.pos";

--
-- Name: document_video_id_seq; Type: SEQUENCE; Schema: public; Owner: wc-sample.pos
--

CREATE SEQUENCE document_video_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.document_video_id_seq OWNER TO "wc-sample.pos";

--
-- Name: document_video_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: wc-sample.pos
--

ALTER SEQUENCE document_video_id_seq OWNED BY document_video.id;


--
-- Name: feedbacks; Type: TABLE; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE TABLE feedbacks (
    id integer NOT NULL,
    datetime timestamp without time zone,
    status smallint,
    region integer,
    name character varying,
    phone character varying,
    email character varying,
    org character varying,
    text text,
    ip character varying,
    suspicious smallint,
    comments text
);


ALTER TABLE public.feedbacks OWNER TO "wc-sample.pos";

--
-- Name: feedbacks_id_seq; Type: SEQUENCE; Schema: public; Owner: wc-sample.pos
--

CREATE SEQUENCE feedbacks_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.feedbacks_id_seq OWNER TO "wc-sample.pos";

--
-- Name: feedbacks_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: wc-sample.pos
--

ALTER SEQUENCE feedbacks_id_seq OWNED BY feedbacks.id;


--
-- Name: files; Type: TABLE; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE TABLE files (
    id bigint NOT NULL,
    parent_id bigint,
    key character varying,
    path text,
    ext character varying DEFAULT NULL::character varying,
    size bigint,
    mime character varying,
    width bigint,
    height bigint,
    settings text,
    site_id bigint,
    _created timestamp without time zone,
    _updated timestamp without time zone
);


ALTER TABLE public.files OWNER TO "wc-sample.pos";

--
-- Name: files_id_seq; Type: SEQUENCE; Schema: public; Owner: wc-sample.pos
--

CREATE SEQUENCE files_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.files_id_seq OWNER TO "wc-sample.pos";

--
-- Name: files_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: wc-sample.pos
--

ALTER SEQUENCE files_id_seq OWNED BY files.id;


--
-- Name: folder_album; Type: TABLE; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE TABLE folder_album (
    id bigint NOT NULL,
    datetime timestamp without time zone,
    description text,
    image bigint,
    _links_name character varying(255) DEFAULT NULL::character varying,
    _links_parent_id bigint,
    _links_index bigint,
    _links_site_id smallint,
    _links_enabled smallint
);


ALTER TABLE public.folder_album OWNER TO "wc-sample.pos";

--
-- Name: folder_album_id_seq; Type: SEQUENCE; Schema: public; Owner: wc-sample.pos
--

CREATE SEQUENCE folder_album_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.folder_album_id_seq OWNER TO "wc-sample.pos";

--
-- Name: folder_album_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: wc-sample.pos
--

ALTER SEQUENCE folder_album_id_seq OWNED BY folder_album.id;


--
-- Name: folder_gallery; Type: TABLE; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE TABLE folder_gallery (
    id bigint NOT NULL,
    description text,
    _links_name character varying(255) DEFAULT NULL::character varying,
    _links_parent_id bigint,
    _links_index bigint,
    _links_site_id smallint,
    _links_enabled smallint
);


ALTER TABLE public.folder_gallery OWNER TO "wc-sample.pos";

--
-- Name: folder_gallery_id_seq; Type: SEQUENCE; Schema: public; Owner: wc-sample.pos
--

CREATE SEQUENCE folder_gallery_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.folder_gallery_id_seq OWNER TO "wc-sample.pos";

--
-- Name: folder_gallery_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: wc-sample.pos
--

ALTER SEQUENCE folder_gallery_id_seq OWNED BY folder_gallery.id;


--
-- Name: folder_homepage; Type: TABLE; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE TABLE folder_homepage (
    id bigint NOT NULL
);


ALTER TABLE public.folder_homepage OWNER TO "wc-sample.pos";

--
-- Name: folder_homepage_id_seq; Type: SEQUENCE; Schema: public; Owner: wc-sample.pos
--

CREATE SEQUENCE folder_homepage_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.folder_homepage_id_seq OWNER TO "wc-sample.pos";

--
-- Name: folder_homepage_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: wc-sample.pos
--

ALTER SEQUENCE folder_homepage_id_seq OWNED BY folder_homepage.id;


--
-- Name: folder_link; Type: TABLE; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE TABLE folder_link (
    id bigint NOT NULL,
    url text,
    _links_name character varying(255) DEFAULT NULL::character varying,
    _links_parent_id bigint,
    _links_index bigint,
    _links_site_id smallint,
    _links_enabled smallint
);


ALTER TABLE public.folder_link OWNER TO "wc-sample.pos";

--
-- Name: folder_link_id_seq; Type: SEQUENCE; Schema: public; Owner: wc-sample.pos
--

CREATE SEQUENCE folder_link_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.folder_link_id_seq OWNER TO "wc-sample.pos";

--
-- Name: folder_link_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: wc-sample.pos
--

ALTER SEQUENCE folder_link_id_seq OWNED BY folder_link.id;


--
-- Name: folder_news; Type: TABLE; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE TABLE folder_news (
    id bigint NOT NULL,
    _links_name character varying(255) DEFAULT NULL::character varying,
    _links_parent_id bigint,
    _links_index bigint,
    _links_site_id smallint,
    _links_enabled smallint
);


ALTER TABLE public.folder_news OWNER TO "wc-sample.pos";

--
-- Name: folder_news_id_seq; Type: SEQUENCE; Schema: public; Owner: wc-sample.pos
--

CREATE SEQUENCE folder_news_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.folder_news_id_seq OWNER TO "wc-sample.pos";

--
-- Name: folder_news_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: wc-sample.pos
--

ALTER SEQUENCE folder_news_id_seq OWNED BY folder_news.id;


--
-- Name: folder_page; Type: TABLE; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE TABLE folder_page (
    id bigint NOT NULL,
    text text
);


ALTER TABLE public.folder_page OWNER TO "wc-sample.pos";

--
-- Name: folder_page_id_seq; Type: SEQUENCE; Schema: public; Owner: wc-sample.pos
--

CREATE SEQUENCE folder_page_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.folder_page_id_seq OWNER TO "wc-sample.pos";

--
-- Name: folder_page_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: wc-sample.pos
--

ALTER SEQUENCE folder_page_id_seq OWNED BY folder_page.id;


--
-- Name: links; Type: TABLE; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE TABLE links (
    item_id bigint NOT NULL,
    dataset_name character varying,
    name character varying,
    parent_id bigint,
    index bigint,
    alias character varying,
    settings text,
    site_id smallint DEFAULT 0::smallint,
    enabled smallint DEFAULT 1::smallint,
    dev smallint,
    CONSTRAINT links_parent_id_check CHECK ((parent_id >= 0)),
    CONSTRAINT links_site_id_check CHECK ((site_id >= 0))
);


ALTER TABLE public.links OWNER TO "wc-sample.pos";

--
-- Name: TABLE links; Type: COMMENT; Schema: public; Owner: wc-sample.pos
--

COMMENT ON TABLE links IS 'Main data structure';


--
-- Name: links_item_id_seq; Type: SEQUENCE; Schema: public; Owner: wc-sample.pos
--

CREATE SEQUENCE links_item_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.links_item_id_seq OWNER TO "wc-sample.pos";

--
-- Name: links_item_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: wc-sample.pos
--

ALTER SEQUENCE links_item_id_seq OWNED BY links.item_id;


--
-- Name: metas; Type: TABLE; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE TABLE metas (
    item_id bigint NOT NULL,
    site_id bigint,
    title text,
    description text,
    keywords text
);


ALTER TABLE public.metas OWNER TO "wc-sample.pos";

--
-- Name: roles; Type: TABLE; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE TABLE roles (
    id bigint NOT NULL,
    name character varying,
    description character varying
);


ALTER TABLE public.roles OWNER TO "wc-sample.pos";

--
-- Name: roles_id_seq; Type: SEQUENCE; Schema: public; Owner: wc-sample.pos
--

CREATE SEQUENCE roles_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.roles_id_seq OWNER TO "wc-sample.pos";

--
-- Name: roles_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: wc-sample.pos
--

ALTER SEQUENCE roles_id_seq OWNED BY roles.id;


--
-- Name: roles_users; Type: TABLE; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE TABLE roles_users (
    user_id integer NOT NULL,
    role_id integer NOT NULL,
    CONSTRAINT roles_users_role_id_check CHECK ((role_id >= 0)),
    CONSTRAINT roles_users_user_id_check CHECK ((user_id >= 0))
);


ALTER TABLE public.roles_users OWNER TO "wc-sample.pos";

--
-- Name: search_index; Type: TABLE; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE TABLE search_index (
    id bigint NOT NULL,
    class character varying,
    class_id bigint,
    class_parent_id bigint,
    factory_key character varying,
    "group" smallint,
    datetime timestamp without time zone,
    image bigint,
    title text,
    description text,
    text text,
    url text,
    site_id bigint,
    _created timestamp without time zone,
    _updated timestamp without time zone,
    _proccess_id bigint,
    title_tsv tsvector,
    description_tsv tsvector,
    text_tsv tsvector,
    data_tsv tsvector,
    enabled smallint,
    CONSTRAINT search_index__proccess_id_check CHECK ((_proccess_id >= 0)),
    CONSTRAINT search_index_image_check CHECK ((image >= 0))
);


ALTER TABLE public.search_index OWNER TO "wc-sample.pos";

--
-- Name: search_index_id_seq; Type: SEQUENCE; Schema: public; Owner: wc-sample.pos
--

CREATE SEQUENCE search_index_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.search_index_id_seq OWNER TO "wc-sample.pos";

--
-- Name: search_index_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: wc-sample.pos
--

ALTER SEQUENCE search_index_id_seq OWNED BY search_index.id;


--
-- Name: setting_categories; Type: TABLE; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE TABLE setting_categories (
    id bigint NOT NULL,
    name character varying,
    _created timestamp without time zone,
    _updated timestamp without time zone
);


ALTER TABLE public.setting_categories OWNER TO "wc-sample.pos";

--
-- Name: setting_categories_id_seq; Type: SEQUENCE; Schema: public; Owner: wc-sample.pos
--

CREATE SEQUENCE setting_categories_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.setting_categories_id_seq OWNER TO "wc-sample.pos";

--
-- Name: setting_categories_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: wc-sample.pos
--

ALTER SEQUENCE setting_categories_id_seq OWNED BY setting_categories.id;


--
-- Name: setting_values; Type: TABLE; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE TABLE setting_values (
    id bigint NOT NULL,
    name character varying,
    data text,
    site_id bigint,
    _created timestamp without time zone,
    _updated timestamp without time zone
);


ALTER TABLE public.setting_values OWNER TO "wc-sample.pos";

--
-- Name: setting_values_id_seq; Type: SEQUENCE; Schema: public; Owner: wc-sample.pos
--

CREATE SEQUENCE setting_values_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.setting_values_id_seq OWNER TO "wc-sample.pos";

--
-- Name: setting_values_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: wc-sample.pos
--

ALTER SEQUENCE setting_values_id_seq OWNED BY setting_values.id;


--
-- Name: settings; Type: TABLE; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE TABLE settings (
    id bigint NOT NULL,
    name character varying,
    title character varying,
    type character varying,
    site_id bigint,
    _created timestamp without time zone,
    _updated timestamp without time zone
);


ALTER TABLE public.settings OWNER TO "wc-sample.pos";

--
-- Name: settings_categories; Type: TABLE; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE TABLE settings_categories (
    setting_id integer,
    category_id integer
);


ALTER TABLE public.settings_categories OWNER TO "wc-sample.pos";

--
-- Name: settings_id_seq; Type: SEQUENCE; Schema: public; Owner: wc-sample.pos
--

CREATE SEQUENCE settings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.settings_id_seq OWNER TO "wc-sample.pos";

--
-- Name: settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: wc-sample.pos
--

ALTER SEQUENCE settings_id_seq OWNED BY settings.id;


--
-- Name: site_hosts; Type: TABLE; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE TABLE site_hosts (
    id bigint NOT NULL,
    host character varying,
    index bigint,
    main smallint,
    site_id bigint
);


ALTER TABLE public.site_hosts OWNER TO "wc-sample.pos";

--
-- Name: site_hosts_id_seq; Type: SEQUENCE; Schema: public; Owner: wc-sample.pos
--

CREATE SEQUENCE site_hosts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.site_hosts_id_seq OWNER TO "wc-sample.pos";

--
-- Name: site_hosts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: wc-sample.pos
--

ALTER SEQUENCE site_hosts_id_seq OWNED BY site_hosts.id;


--
-- Name: sites; Type: TABLE; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE TABLE sites (
    id bigint NOT NULL,
    title character varying,
    index integer,
    main smallint,
    _created timestamp without time zone,
    _updated timestamp without time zone
);


ALTER TABLE public.sites OWNER TO "wc-sample.pos";

--
-- Name: sites_id_seq; Type: SEQUENCE; Schema: public; Owner: wc-sample.pos
--

CREATE SEQUENCE sites_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sites_id_seq OWNER TO "wc-sample.pos";

--
-- Name: sites_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: wc-sample.pos
--

ALTER SEQUENCE sites_id_seq OWNED BY sites.id;


--
-- Name: statuses; Type: TABLE; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE TABLE statuses (
    id bigint NOT NULL,
    datetime timestamp without time zone,
    user_id bigint,
    item_id bigint,
    CONSTRAINT statuses_item_id_check CHECK ((item_id >= 0)),
    CONSTRAINT statuses_user_id_check CHECK ((user_id >= 0))
);


ALTER TABLE public.statuses OWNER TO "wc-sample.pos";

--
-- Name: statuses_id_seq; Type: SEQUENCE; Schema: public; Owner: wc-sample.pos
--

CREATE SEQUENCE statuses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.statuses_id_seq OWNER TO "wc-sample.pos";

--
-- Name: statuses_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: wc-sample.pos
--

ALTER SEQUENCE statuses_id_seq OWNED BY statuses.id;


--
-- Name: subscribe_channels_id_seq; Type: SEQUENCE; Schema: public; Owner: wc-sample.pos
--

CREATE SEQUENCE subscribe_channels_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.subscribe_channels_id_seq OWNER TO "wc-sample.pos";

--
-- Name: subscribe_channels; Type: TABLE; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE TABLE subscribe_channels (
    id integer DEFAULT nextval('subscribe_channels_id_seq'::regclass) NOT NULL,
    name character varying(255),
    description text,
    handler character varying(255),
    last_time timestamp without time zone,
    enabled smallint,
    site_id bigint,
    index bigint
);


ALTER TABLE public.subscribe_channels OWNER TO "wc-sample.pos";

--
-- Name: subscribe_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: wc-sample.pos
--

CREATE SEQUENCE subscribe_settings_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.subscribe_settings_id_seq OWNER TO "wc-sample.pos";

--
-- Name: subscribe_settings; Type: TABLE; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE TABLE subscribe_settings (
    id bigint DEFAULT nextval('subscribe_settings_id_seq'::regclass) NOT NULL,
    site_id bigint,
    data text
);


ALTER TABLE public.subscribe_settings OWNER TO "wc-sample.pos";

--
-- Name: subscribe_users_id_seq; Type: SEQUENCE; Schema: public; Owner: wc-sample.pos
--

CREATE SEQUENCE subscribe_users_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.subscribe_users_id_seq OWNER TO "wc-sample.pos";

--
-- Name: subscribe_users; Type: TABLE; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE TABLE subscribe_users (
    id integer DEFAULT nextval('subscribe_users_id_seq'::regclass) NOT NULL,
    name text,
    email text,
    enabled integer,
    registred timestamp without time zone,
    site_id bigint,
    confirmed timestamp without time zone,
    token text
);


ALTER TABLE public.subscribe_users OWNER TO "wc-sample.pos";

--
-- Name: subscribe_users_channels; Type: TABLE; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE TABLE subscribe_users_channels (
    user_id bigint,
    channel_id bigint
);


ALTER TABLE public.subscribe_users_channels OWNER TO "wc-sample.pos";

--
-- Name: tags; Type: TABLE; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE TABLE tags (
    id bigint NOT NULL,
    name character varying,
    count bigint,
    site_id bigint,
    CONSTRAINT tags_count_check CHECK ((count >= 0)),
    CONSTRAINT tags_site_id_check CHECK ((site_id >= 0))
);


ALTER TABLE public.tags OWNER TO "wc-sample.pos";

--
-- Name: tags_id_seq; Type: SEQUENCE; Schema: public; Owner: wc-sample.pos
--

CREATE SEQUENCE tags_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.tags_id_seq OWNER TO "wc-sample.pos";

--
-- Name: tags_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: wc-sample.pos
--

ALTER SEQUENCE tags_id_seq OWNED BY tags.id;


--
-- Name: tags_links; Type: TABLE; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE TABLE tags_links (
    id bigint NOT NULL,
    tag_id bigint,
    item_id bigint,
    item_type character varying,
    factory_key character varying,
    CONSTRAINT tags_links_item_id_check CHECK ((item_id >= 0)),
    CONSTRAINT tags_links_tag_id_check CHECK ((tag_id >= 0))
);


ALTER TABLE public.tags_links OWNER TO "wc-sample.pos";

--
-- Name: tags_links_id_seq; Type: SEQUENCE; Schema: public; Owner: wc-sample.pos
--

CREATE SEQUENCE tags_links_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.tags_links_id_seq OWNER TO "wc-sample.pos";

--
-- Name: tags_links_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: wc-sample.pos
--

ALTER SEQUENCE tags_links_id_seq OWNED BY tags_links.id;


--
-- Name: user_group_structure_item_roles; Type: TABLE; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE TABLE user_group_structure_item_roles (
    id bigint NOT NULL,
    item_id bigint,
    group_id bigint,
    key character varying,
    value smallint
);


ALTER TABLE public.user_group_structure_item_roles OWNER TO "wc-sample.pos";

--
-- Name: user_group_structure_item_roles_id_seq; Type: SEQUENCE; Schema: public; Owner: wc-sample.pos
--

CREATE SEQUENCE user_group_structure_item_roles_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.user_group_structure_item_roles_id_seq OWNER TO "wc-sample.pos";

--
-- Name: user_group_structure_item_roles_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: wc-sample.pos
--

ALTER SEQUENCE user_group_structure_item_roles_id_seq OWNED BY user_group_structure_item_roles.id;


--
-- Name: user_groups; Type: TABLE; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE TABLE user_groups (
    id bigint NOT NULL,
    name character varying DEFAULT ''::character varying,
    site_id bigint
);


ALTER TABLE public.user_groups OWNER TO "wc-sample.pos";

--
-- Name: user_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: wc-sample.pos
--

CREATE SEQUENCE user_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.user_groups_id_seq OWNER TO "wc-sample.pos";

--
-- Name: user_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: wc-sample.pos
--

ALTER SEQUENCE user_groups_id_seq OWNED BY user_groups.id;


--
-- Name: user_tokens; Type: TABLE; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE TABLE user_tokens (
    id bigint NOT NULL,
    user_id integer,
    user_agent character varying(40),
    token character varying(40),
    created integer,
    expires integer,
    CONSTRAINT user_tokens_created_check CHECK ((created >= 0)),
    CONSTRAINT user_tokens_expires_check CHECK ((expires >= 0)),
    CONSTRAINT user_tokens_user_id_check CHECK ((user_id >= 0))
);


ALTER TABLE public.user_tokens OWNER TO "wc-sample.pos";

--
-- Name: user_tokens_id_seq; Type: SEQUENCE; Schema: public; Owner: wc-sample.pos
--

CREATE SEQUENCE user_tokens_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.user_tokens_id_seq OWNER TO "wc-sample.pos";

--
-- Name: user_tokens_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: wc-sample.pos
--

ALTER SEQUENCE user_tokens_id_seq OWNED BY user_tokens.id;


--
-- Name: users; Type: TABLE; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE TABLE users (
    id bigint NOT NULL,
    username character varying DEFAULT ''::character varying,
    name character varying,
    post text,
    password character(32) DEFAULT ''::bpchar,
    email character varying DEFAULT ''::character varying,
    "join" integer DEFAULT 0,
    last_login integer DEFAULT 0,
    logins integer DEFAULT 0,
    active_from timestamp without time zone,
    active_to timestamp without time zone,
    disabled smallint,
    site_id bigint,
    CONSTRAINT users_join_check CHECK (("join" >= 0)),
    CONSTRAINT users_last_login_check CHECK ((last_login >= 0)),
    CONSTRAINT users_logins_check CHECK ((logins >= 0))
);


ALTER TABLE public.users OWNER TO "wc-sample.pos";

--
-- Name: users_groups; Type: TABLE; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE TABLE users_groups (
    user_id integer,
    group_id integer
);


ALTER TABLE public.users_groups OWNER TO "wc-sample.pos";

--
-- Name: users_id_seq; Type: SEQUENCE; Schema: public; Owner: wc-sample.pos
--

CREATE SEQUENCE users_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.users_id_seq OWNER TO "wc-sample.pos";

--
-- Name: users_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: wc-sample.pos
--

ALTER SEQUENCE users_id_seq OWNED BY users.id;


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: wc-sample.pos
--

ALTER TABLE ONLY changelog ALTER COLUMN id SET DEFAULT nextval('changelog_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: wc-sample.pos
--

ALTER TABLE ONLY crosssite_channels_outbox ALTER COLUMN id SET DEFAULT nextval('crosssite_channels_outbox_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: wc-sample.pos
--

ALTER TABLE ONLY crosssite_inbox ALTER COLUMN id SET DEFAULT nextval('crosssite_inbox_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: wc-sample.pos
--

ALTER TABLE ONLY crosssite_outbox ALTER COLUMN id SET DEFAULT nextval('crosssite_outbox_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: wc-sample.pos
--

ALTER TABLE ONLY crosssite_sites ALTER COLUMN id SET DEFAULT nextval('crosssite_sites_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: wc-sample.pos
--

ALTER TABLE ONLY dataset_fields ALTER COLUMN id SET DEFAULT nextval('dataset_fields_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: wc-sample.pos
--

ALTER TABLE ONLY dataset_sync ALTER COLUMN id SET DEFAULT nextval('dataset_sync_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: wc-sample.pos
--

ALTER TABLE ONLY document_audio ALTER COLUMN id SET DEFAULT nextval('document_audio_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: wc-sample.pos
--

ALTER TABLE ONLY document_file ALTER COLUMN id SET DEFAULT nextval('document_file_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: wc-sample.pos
--

ALTER TABLE ONLY document_image ALTER COLUMN id SET DEFAULT nextval('document_image_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: wc-sample.pos
--

ALTER TABLE ONLY document_news ALTER COLUMN id SET DEFAULT nextval('document_news_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: wc-sample.pos
--

ALTER TABLE ONLY document_text ALTER COLUMN id SET DEFAULT nextval('document_text_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: wc-sample.pos
--

ALTER TABLE ONLY document_video ALTER COLUMN id SET DEFAULT nextval('document_video_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: wc-sample.pos
--

ALTER TABLE ONLY feedbacks ALTER COLUMN id SET DEFAULT nextval('feedbacks_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: wc-sample.pos
--

ALTER TABLE ONLY files ALTER COLUMN id SET DEFAULT nextval('files_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: wc-sample.pos
--

ALTER TABLE ONLY folder_album ALTER COLUMN id SET DEFAULT nextval('folder_album_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: wc-sample.pos
--

ALTER TABLE ONLY folder_gallery ALTER COLUMN id SET DEFAULT nextval('folder_gallery_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: wc-sample.pos
--

ALTER TABLE ONLY folder_homepage ALTER COLUMN id SET DEFAULT nextval('folder_homepage_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: wc-sample.pos
--

ALTER TABLE ONLY folder_link ALTER COLUMN id SET DEFAULT nextval('folder_link_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: wc-sample.pos
--

ALTER TABLE ONLY folder_news ALTER COLUMN id SET DEFAULT nextval('folder_news_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: wc-sample.pos
--

ALTER TABLE ONLY folder_page ALTER COLUMN id SET DEFAULT nextval('folder_page_id_seq'::regclass);


--
-- Name: item_id; Type: DEFAULT; Schema: public; Owner: wc-sample.pos
--

ALTER TABLE ONLY links ALTER COLUMN item_id SET DEFAULT nextval('links_item_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: wc-sample.pos
--

ALTER TABLE ONLY roles ALTER COLUMN id SET DEFAULT nextval('roles_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: wc-sample.pos
--

ALTER TABLE ONLY search_index ALTER COLUMN id SET DEFAULT nextval('search_index_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: wc-sample.pos
--

ALTER TABLE ONLY setting_categories ALTER COLUMN id SET DEFAULT nextval('setting_categories_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: wc-sample.pos
--

ALTER TABLE ONLY setting_values ALTER COLUMN id SET DEFAULT nextval('setting_values_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: wc-sample.pos
--

ALTER TABLE ONLY settings ALTER COLUMN id SET DEFAULT nextval('settings_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: wc-sample.pos
--

ALTER TABLE ONLY site_hosts ALTER COLUMN id SET DEFAULT nextval('site_hosts_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: wc-sample.pos
--

ALTER TABLE ONLY sites ALTER COLUMN id SET DEFAULT nextval('sites_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: wc-sample.pos
--

ALTER TABLE ONLY statuses ALTER COLUMN id SET DEFAULT nextval('statuses_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: wc-sample.pos
--

ALTER TABLE ONLY tags ALTER COLUMN id SET DEFAULT nextval('tags_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: wc-sample.pos
--

ALTER TABLE ONLY tags_links ALTER COLUMN id SET DEFAULT nextval('tags_links_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: wc-sample.pos
--

ALTER TABLE ONLY user_group_structure_item_roles ALTER COLUMN id SET DEFAULT nextval('user_group_structure_item_roles_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: wc-sample.pos
--

ALTER TABLE ONLY user_groups ALTER COLUMN id SET DEFAULT nextval('user_groups_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: wc-sample.pos
--

ALTER TABLE ONLY user_tokens ALTER COLUMN id SET DEFAULT nextval('user_tokens_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: wc-sample.pos
--

ALTER TABLE ONLY users ALTER COLUMN id SET DEFAULT nextval('users_id_seq'::regclass);


--
-- Data for Name: changelog; Type: TABLE DATA; Schema: public; Owner: wc-sample.pos
--

COPY changelog (id, datetime, class, class_id, factory_key, site_id, user_id, username, action, details) FROM stdin;
933	2015-08-27 10:00:11	Model_User	\N	\N	2	1	root	login	\N
934	2015-08-27 10:00:27	Model_User	1	\N	2	1	root	logout	\N
935	2015-08-27 10:00:28	Model_User	\N	\N	2	1	root	login	\N
936	2015-08-27 14:43:39	Model_User	\N	\N	2	1	root	login	\N
937	2015-08-28 12:22:59	Model_User	\N	\N	2	1	root	login	\N
938	2015-08-28 13:30:31	Model_User	\N	\N	2	1	root	login	\N
939	2015-08-28 13:59:48	Model_User	\N	\N	2	1	root	login	\N
940	2015-08-28 15:27:35	Model_User	\N	\N	2	1	root	login	\N
941	2015-09-08 15:46:28	Model_User	\N	\N	2	1	root	login	\N
942	2015-09-14 11:44:40	Model_User	\N	\N	2	1	root	login	\N
943	2015-09-29 11:37:40	Model_User	\N	\N	2	1	root	login	\N
944	2015-09-29 12:09:36	Model_User	\N	\N	2	1	root	login	\N
945	2015-09-29 13:30:21	Model_User	\N	\N	2	1	root	login	\N
946	2015-09-29 15:46:52	Model_User	\N	\N	2	1	root	login	\N
947	2015-09-30 15:10:05	Model_User	\N	\N	2	1	root	login	\N
948	2015-10-02 10:13:14	Model_User	\N	\N	2	1	root	login	\N
949	2015-10-02 13:19:57	Model_User	\N	\N	2	1	root	login	\N
950	2015-10-08 13:02:59	Model_User	\N	\N	2	1	root	login	\N
951	2015-10-08 13:04:25	Model_Document_Text	615	Model_Document_Text:615:document_text	2	1	root	create	a:5:{s:11:"object_type";s:35:"Текстовый документ";s:12:"object_title";s:4:"test";s:12:"dataset_name";s:13:"document_text";s:7:"changed";a:0:{}s:6:"parent";a:5:{s:2:"id";s:3:"574";s:11:"object_type";s:16:"Страница";s:12:"object_title";s:18:"Документы";s:12:"dataset_name";s:11:"folder_page";s:12:"dataset_type";s:6:"folder";}}
952	2015-10-08 13:05:36	Model_Document_Text	615	Model_Document_Text:615:document_text	2	1	root	delete	a:6:{s:11:"object_type";s:35:"Текстовый документ";s:12:"object_title";s:4:"test";s:12:"dataset_name";s:13:"document_text";s:7:"changed";a:0:{}s:13:"inner_folders";s:1:"0";s:15:"inner_documents";s:1:"0";}
953	2015-10-14 14:04:47	Model_User	\N	\N	2	1	root	login	\N
954	2015-10-15 13:02:37	Model_User	\N	\N	2	1	root	login	\N
955	2015-10-20 15:15:12	Model_User	\N	\N	2	1	root	login	\N
956	2015-10-20 15:16:06	Model_Document	586	Model_Document:586:document_news	2	1	root	update	a:5:{s:11:"object_type";s:14:"Новость";s:12:"object_title";s:70:"Профсоюзы создали партию «Союз труда»";s:12:"dataset_name";s:13:"document_news";s:7:"changed";a:3:{s:5:"image";a:1:{s:5:"label";s:22:"Изображение";}s:11:"description";a:1:{s:5:"label";s:10:"Анонс";}s:4:"text";a:1:{s:5:"label";s:10:"Текст";}}s:6:"parent";a:5:{s:2:"id";s:3:"582";s:11:"object_type";s:27:"Лента новостей";s:12:"object_title";s:14:"Новости";s:12:"dataset_name";s:11:"folder_news";s:12:"dataset_type";s:6:"folder";}}
957	2015-11-08 19:28:39	Model_User	\N	\N	2	1	root	login	\N
958	2015-11-08 19:28:53	Model_Folder	574	Model_Folder:574:folder_page	2	1	root	disable	a:4:{s:11:"object_type";s:16:"Страница";s:12:"object_title";s:18:"Документы";s:12:"dataset_name";s:11:"folder_page";s:7:"changed";a:0:{}}
959	2015-11-08 19:29:02	Model_Folder	574	Model_Folder:574:folder_page	2	1	root	enable	a:4:{s:11:"object_type";s:16:"Страница";s:12:"object_title";s:18:"Документы";s:12:"dataset_name";s:11:"folder_page";s:7:"changed";a:0:{}}
960	2015-11-20 13:44:59	Model_User	\N	\N	2	1	root	login	\N
961	2015-11-20 15:32:22	Model_User	\N	\N	2	1	root	login	\N
962	2015-11-25 08:40:19	Model_User	\N	\N	2	1	root	login	\N
963	2015-12-14 10:29:08	Model_User	\N	\N	2	1	root	login	\N
964	2015-12-17 09:30:33	Model_User	\N	\N	2	1	root	login	\N
965	2016-01-12 12:46:41	Model_User	\N	\N	2	1	root	login	\N
966	2016-01-22 16:00:18	Model_User	\N	\N	2	2	admin	login	\N
967	2016-01-22 16:04:36	Model_User	2	\N	2	2	admin	logout	\N
968	2016-01-22 16:04:56	Model_User	\N	\N	2	1	root	login	\N
969	2016-01-22 16:17:52	Model_User	\N	\N	2	1	root	login	\N
970	2016-01-22 17:20:33	Model_User	\N	\N	2	1	root	login	\N
971	2016-02-10 09:49:42	Model_User	\N	\N	2	2	admin	login	\N
972	2016-02-10 10:18:43	Model_User	\N	\N	2	\N	\N	logout	\N
973	2016-02-10 10:18:47	Model_User	\N	\N	2	1	root	login	\N
974	2016-02-10 14:28:28	Model_User	\N	\N	2	1	root	login	\N
975	2016-02-18 09:54:03	Model_User	\N	\N	2	1	root	login	\N
976	2016-02-18 10:05:09	Model_Document	586	Model_Document:586:document_news	2	1	root	update	a:5:{s:11:"object_type";s:14:"Новость";s:12:"object_title";s:70:"Профсоюзы создали партию «Союз труда»";s:12:"dataset_name";s:13:"document_news";s:7:"changed";a:1:{s:4:"tags";a:1:{s:5:"label";s:8:"Тэги";}}s:6:"parent";a:5:{s:2:"id";s:3:"582";s:11:"object_type";s:27:"Лента новостей";s:12:"object_title";s:14:"Новости";s:12:"dataset_name";s:11:"folder_news";s:12:"dataset_type";s:6:"folder";}}
\.


--
-- Name: changelog_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wc-sample.pos
--

SELECT pg_catalog.setval('changelog_id_seq', 976, true);


--
-- Data for Name: crosssite_channels_outbox; Type: TABLE DATA; Schema: public; Owner: wc-sample.pos
--

COPY crosssite_channels_outbox (id, parent_id, dataset_name, remotes, enabled, site_id) FROM stdin;
\.


--
-- Name: crosssite_channels_outbox_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wc-sample.pos
--

SELECT pg_catalog.setval('crosssite_channels_outbox_id_seq', 1, false);


--
-- Data for Name: crosssite_inbox; Type: TABLE DATA; Schema: public; Owner: wc-sample.pos
--

COPY crosssite_inbox (id, datetime, site_id, crosssite_id, factory_key) FROM stdin;
\.


--
-- Name: crosssite_inbox_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wc-sample.pos
--

SELECT pg_catalog.setval('crosssite_inbox_id_seq', 1, false);


--
-- Data for Name: crosssite_outbox; Type: TABLE DATA; Schema: public; Owner: wc-sample.pos
--

COPY crosssite_outbox (id, datetime, crosssite_id, factory_key, site_id, crosssite_channel_id, remote_id, remote_parent_id, remote_site_id, remote_site) FROM stdin;
\.


--
-- Name: crosssite_outbox_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wc-sample.pos
--

SELECT pg_catalog.setval('crosssite_outbox_id_seq', 1, false);


--
-- Data for Name: crosssite_sites; Type: TABLE DATA; Schema: public; Owner: wc-sample.pos
--

COPY crosssite_sites (id, host, token, enabled, index, site_id) FROM stdin;
\.


--
-- Name: crosssite_sites_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wc-sample.pos
--

SELECT pg_catalog.setval('crosssite_sites_id_seq', 1, false);


--
-- Data for Name: dataset_fields; Type: TABLE DATA; Schema: public; Owner: wc-sample.pos
--

COPY dataset_fields (id, key, label, index, dataset_name, type, settings, enabled) FROM stdin;
3	text	Текст	4	document_text	wysiwyg	a:4:{s:4:"form";a:2:{s:4:"note";s:0:"";s:8:"required";N;}s:4:"list";a:2:{s:4:"show";N;s:5:"order";N;}s:6:"filter";a:1:{s:4:"show";N;}s:6:"search";a:1:{s:3:"key";s:4:"text";}}	1
4	name	Название	1	document_file	text	a:4:{s:4:"form";a:3:{s:4:"note";s:0:"";s:8:"required";s:0:"";s:6:"format";s:3:"any";}s:4:"list";a:2:{s:4:"show";s:0:"";s:5:"order";s:0:"";}s:6:"filter";a:1:{s:4:"show";s:0:"";}s:6:"search";a:1:{s:3:"key";s:5:"title";}}	1
5	file	Файл	2	document_file	file	a:5:{s:4:"form";a:2:{s:4:"note";s:0:"";s:8:"required";s:1:"1";}s:4:"list";a:3:{s:4:"show";s:0:"";s:5:"order";s:0:"";s:10:"base_order";s:0:"";}s:6:"filter";a:1:{s:4:"show";s:0:"";}s:6:"search";a:1:{s:3:"key";s:0:"";}s:6:"upload";a:4:{s:6:"subdir";s:13:"document_file";s:12:"filesize_max";s:0:"";s:11:"ext_allowed";a:12:{i:0;s:3:"doc";i:1;s:4:"docx";i:2;s:3:"ods";i:3;s:3:"odt";i:4;s:3:"pdf";i:5;s:3:"rar";i:6;s:3:"rtf";i:7;s:3:"txt";i:8;s:2:"un";i:9;s:3:"xls";i:10;s:4:"xlsx";i:11;s:3:"zip";}s:12:"mime_allowed";a:0:{}}}	1
6	name	Название	2	document_image	text	a:4:{s:4:"form";a:3:{s:4:"note";s:0:"";s:8:"required";s:0:"";s:6:"format";s:3:"any";}s:4:"list";a:3:{s:4:"show";s:1:"1";s:5:"order";s:0:"";s:10:"base_order";s:0:"";}s:6:"filter";a:1:{s:4:"show";s:0:"";}s:6:"search";a:1:{s:3:"key";s:5:"title";}}	1
7	file	Файл	1	document_image	image	a:5:{s:4:"form";a:2:{s:4:"note";s:0:"";s:8:"required";s:0:"";}s:4:"list";a:3:{s:4:"show";s:1:"1";s:5:"order";s:0:"";s:10:"base_order";s:0:"";}s:6:"filter";a:1:{s:4:"show";s:0:"";}s:6:"search";a:1:{s:3:"key";s:5:"image";}s:6:"upload";a:5:{s:6:"subdir";s:15:"document_images";s:12:"filesize_max";s:0:"";s:11:"ext_allowed";a:0:{}s:12:"mime_allowed";a:0:{}s:15:"formats_allowed";a:3:{i:0;s:3:"jpg";i:1;s:3:"gif";i:2;s:3:"png";}}}	1
8	name	Название	1	document_video	text	a:4:{s:4:"form";a:3:{s:4:"note";s:0:"";s:8:"required";s:0:"";s:6:"format";s:3:"any";}s:4:"list";a:2:{s:4:"show";s:1:"1";s:5:"order";s:1:"1";}s:6:"filter";a:1:{s:4:"show";s:1:"1";}s:6:"search";a:1:{s:3:"key";s:5:"title";}}	1
9	file	Файл	2	document_video	file	a:5:{s:4:"form";a:2:{s:4:"note";s:0:"";s:8:"required";s:0:"";}s:4:"list";a:3:{s:4:"show";s:0:"";s:5:"order";s:0:"";s:10:"base_order";s:0:"";}s:6:"filter";a:1:{s:4:"show";s:0:"";}s:6:"search";a:1:{s:3:"key";s:0:"";}s:6:"upload";a:4:{s:6:"subdir";s:14:"document_video";s:12:"filesize_max";s:0:"";s:11:"ext_allowed";a:7:{i:0;s:3:"swf";i:1;s:3:"flv";i:2;s:3:"avi";i:3;s:3:"wmv";i:4;s:3:"3gp";i:5;s:3:"mp4";i:6;s:5:"mpeg4";}s:12:"mime_allowed";a:0:{}}}	1
10	image	Изображение	3	document_video	image	a:5:{s:4:"form";a:2:{s:4:"note";s:0:"";s:8:"required";s:0:"";}s:4:"list";a:2:{s:4:"show";s:1:"1";s:5:"order";s:0:"";}s:6:"filter";a:1:{s:4:"show";s:0:"";}s:6:"search";a:1:{s:3:"key";s:5:"image";}s:6:"upload";a:5:{s:6:"subdir";s:20:"document_video/image";s:12:"filesize_max";s:0:"";s:11:"ext_allowed";a:0:{}s:12:"mime_allowed";a:0:{}s:15:"formats_allowed";a:0:{}}}	1
11	description	Описание	4	document_video	wysiwyg	a:4:{s:4:"form";a:3:{s:4:"note";s:0:"";s:8:"required";s:0:"";s:5:"basic";s:5:"basic";}s:4:"list";a:2:{s:4:"show";s:0:"";s:5:"order";s:0:"";}s:6:"filter";a:1:{s:4:"show";s:1:"1";}s:6:"search";a:1:{s:3:"key";s:11:"description";}}	1
16	name	Заголовок	2	document_news	text	a:4:{s:4:"form";a:3:{s:4:"note";s:0:"";s:8:"required";s:1:"1";s:6:"format";s:3:"any";}s:4:"list";a:2:{s:4:"show";s:1:"1";s:5:"order";s:1:"1";}s:6:"filter";a:1:{s:4:"show";s:1:"1";}s:6:"search";a:1:{s:3:"key";s:5:"title";}}	1
2	alias	Alias	1	folder_page	alias	a:4:{s:4:"form";a:2:{s:4:"note";s:0:"";s:8:"required";s:0:"";}s:4:"list";a:2:{s:4:"show";N;s:5:"order";N;}s:6:"filter";a:1:{s:4:"show";N;}s:6:"search";a:1:{s:3:"key";s:21:"(не выбрано)";}}	2
1	text	Текст	2	folder_page	wysiwyg	a:4:{s:4:"form";a:4:{s:4:"note";s:0:"";s:8:"required";N;s:5:"basic";N;s:6:"format";N;}s:4:"list";a:2:{s:4:"show";N;s:5:"order";N;}s:6:"filter";a:1:{s:4:"show";N;}s:6:"search";a:1:{s:3:"key";s:4:"text";}}	1
17	description	Анонс	3	document_news	wysiwyg	a:4:{s:4:"form";a:3:{s:4:"note";s:0:"";s:8:"required";s:0:"";s:5:"basic";s:5:"basic";}s:4:"list";a:3:{s:4:"show";s:0:"";s:5:"order";s:0:"";s:10:"base_order";s:0:"";}s:6:"filter";a:1:{s:4:"show";s:0:"";}s:6:"search";a:1:{s:3:"key";s:11:"description";}}	1
18	text	Текст	4	document_news	wysiwyg	a:4:{s:4:"form";a:3:{s:4:"note";s:0:"";s:8:"required";s:1:"1";s:5:"basic";s:0:"";}s:4:"list";a:3:{s:4:"show";s:0:"";s:5:"order";s:0:"";s:10:"base_order";s:0:"";}s:6:"filter";a:1:{s:4:"show";s:0:"";}s:6:"search";a:1:{s:3:"key";s:4:"text";}}	1
19	image	Изображение	1	document_news	image	a:6:{s:4:"form";a:3:{s:4:"note";s:0:"";s:8:"required";s:0:"";s:7:"resizes";a:2:{s:6:"65xx65";a:3:{s:3:"key";s:6:"65xx65";s:4:"size";s:6:"65xx65";s:5:"title";N;}s:7:"100x100";a:3:{s:3:"key";s:7:"100x100";s:4:"size";s:7:"100x100";s:5:"title";N;}}}s:4:"list";a:3:{s:4:"show";s:1:"1";s:5:"order";s:0:"";s:10:"base_order";s:0:"";}s:6:"filter";a:1:{s:4:"show";s:0:"";}s:6:"search";a:1:{s:3:"key";s:5:"image";}s:6:"upload";a:5:{s:6:"subdir";s:13:"document_news";s:12:"filesize_max";s:0:"";s:11:"ext_allowed";a:0:{}s:12:"mime_allowed";a:0:{}s:15:"formats_allowed";a:0:{}}s:4:"view";a:1:{s:4:"type";s:0:"";}}	1
414	description	Описание	\N	folder_gallery	textarea	a:4:{s:4:"form";a:2:{s:4:"note";s:0:"";s:8:"required";s:0:"";}s:4:"list";a:3:{s:4:"show";N;s:5:"order";N;s:10:"base_order";N;}s:6:"filter";a:1:{s:4:"show";N;}s:6:"search";a:1:{s:3:"key";s:0:"";}}	1
31	alias	Алиас	1	folder_news	alias	a:4:{s:4:"form";a:2:{s:4:"note";s:0:"";s:8:"required";s:0:"";}s:4:"list";a:2:{s:4:"show";N;s:5:"order";N;}s:6:"filter";a:1:{s:4:"show";N;}s:6:"search";a:1:{s:3:"key";s:0:"";}}	1
36	name	Название	0	folder_page	text	a:4:{s:4:"form";a:3:{s:4:"note";s:0:"";s:8:"required";s:1:"1";s:6:"format";s:3:"any";}s:4:"list";a:2:{s:4:"show";N;s:5:"order";N;}s:6:"filter";a:1:{s:4:"show";N;}s:6:"search";a:1:{s:3:"key";s:5:"title";}}	1
15	datetime	Дата	0	document_news	datetime	a:4:{s:4:"form";a:3:{s:4:"note";s:0:"";s:8:"required";s:1:"1";s:7:"default";i:0;}s:4:"list";a:3:{s:4:"show";s:1:"1";s:5:"order";s:1:"1";s:10:"base_order";s:4:"desc";}s:6:"filter";a:1:{s:4:"show";s:1:"1";}s:6:"search";a:1:{s:3:"key";s:8:"datetime";}}	1
64	name	Название	0	folder_news	text	a:4:{s:4:"form";a:3:{s:4:"note";s:0:"";s:8:"required";s:1:"1";s:6:"format";N;}s:4:"list";a:2:{s:4:"show";N;s:5:"order";N;}s:6:"filter";a:1:{s:4:"show";N;}s:6:"search";a:1:{s:3:"key";s:0:"";}}	1
66	url	URL	1	folder_link	text	a:4:{s:4:"form";a:3:{s:4:"note";s:0:"";s:8:"required";s:1:"1";s:6:"format";N;}s:4:"list";a:2:{s:4:"show";N;s:5:"order";N;}s:6:"filter";a:1:{s:4:"show";N;}s:6:"search";a:1:{s:3:"key";s:0:"";}}	1
67	name	Название	0	folder_link	text	a:4:{s:4:"form";a:3:{s:4:"note";s:0:"";s:8:"required";s:1:"1";s:6:"format";N;}s:4:"list";a:2:{s:4:"show";N;s:5:"order";N;}s:6:"filter";a:1:{s:4:"show";N;}s:6:"search";a:1:{s:3:"key";s:5:"title";}}	1
121	tags	Тэги	6	document_news	tags	a:4:{s:4:"form";a:2:{s:4:"note";s:0:"";s:8:"required";s:0:"";}s:4:"list";a:2:{s:4:"show";s:0:"";s:5:"order";s:0:"";}s:6:"filter";a:1:{s:4:"show";s:0:"";}s:6:"search";a:1:{s:3:"key";s:0:"";}}	1
465	is_main	Главная новость	5	document_news	checkbox	a:4:{s:4:"form";a:2:{s:4:"note";s:0:"";s:8:"required";s:0:"";}s:4:"list";a:3:{s:4:"show";s:1:"1";s:5:"order";s:0:"";s:10:"base_order";s:0:"";}s:6:"filter";a:1:{s:4:"show";s:0:"";}s:6:"search";a:1:{s:3:"key";s:0:"";}}	1
144	name	Заголовок	2	folder_homepage	text	a:4:{s:4:"form";a:3:{s:4:"note";s:0:"";s:8:"required";s:1:"1";s:6:"format";N;}s:4:"list";a:3:{s:4:"show";N;s:5:"order";N;s:10:"base_order";N;}s:6:"filter";a:1:{s:4:"show";N;}s:6:"search";a:1:{s:3:"key";s:5:"title";}}	1
158	image	Изображение	7	document_text	image	a:6:{s:4:"form";a:3:{s:4:"note";s:0:"";s:8:"required";s:0:"";s:7:"resizes";a:0:{}}s:4:"list";a:3:{s:4:"show";s:0:"";s:5:"order";s:0:"";s:10:"base_order";s:0:"";}s:6:"filter";a:1:{s:4:"show";s:0:"";}s:6:"search";a:1:{s:3:"key";s:0:"";}s:6:"upload";a:5:{s:6:"subdir";s:0:"";s:12:"filesize_max";s:0:"";s:11:"ext_allowed";a:0:{}s:12:"mime_allowed";a:0:{}s:15:"formats_allowed";a:0:{}}s:4:"view";a:1:{s:4:"type";s:0:"";}}	1
154	name	Заголовок	1	document_text	text	a:4:{s:4:"form";a:3:{s:4:"note";s:0:"";s:8:"required";s:1:"1";s:6:"format";s:3:"any";}s:4:"list";a:3:{s:4:"show";s:1:"1";s:5:"order";s:1:"1";s:10:"base_order";s:0:"";}s:6:"filter";a:1:{s:4:"show";s:0:"";}s:6:"search";a:1:{s:3:"key";s:0:"";}}	1
155	datetime	Дата	0	document_text	datetime	a:4:{s:4:"form";a:2:{s:4:"note";s:0:"";s:8:"required";s:0:"";}s:4:"list";a:3:{s:4:"show";s:0:"";s:5:"order";s:0:"";s:10:"base_order";s:0:"";}s:6:"filter";a:1:{s:4:"show";s:0:"";}s:6:"search";a:1:{s:3:"key";s:0:"";}}	1
157	description	Анонс	5	document_text	wysiwyg	a:4:{s:4:"form";a:3:{s:4:"note";s:0:"";s:8:"required";s:0:"";s:5:"basic";s:5:"basic";}s:4:"list";a:3:{s:4:"show";s:0:"";s:5:"order";s:0:"";s:10:"base_order";s:0:"";}s:6:"filter";a:1:{s:4:"show";s:0:"";}s:6:"search";a:1:{s:3:"key";s:0:"";}}	1
178	datetime	Дата и время	2	document_text	datetime	a:4:{s:4:"form";a:2:{s:4:"note";s:0:"";s:8:"required";s:0:"";}s:4:"list";a:3:{s:4:"show";s:1:"1";s:5:"order";s:1:"1";s:10:"base_order";s:4:"desc";}s:6:"filter";a:1:{s:4:"show";s:0:"";}s:6:"search";a:1:{s:3:"key";s:0:"";}}	1
179	image	Изображение	6	document_text	image	a:5:{s:4:"form";a:2:{s:4:"note";s:0:"";s:8:"required";s:0:"";}s:4:"list";a:3:{s:4:"show";s:1:"1";s:5:"order";s:1:"1";s:10:"base_order";s:0:"";}s:6:"filter";a:1:{s:4:"show";s:0:"";}s:6:"search";a:1:{s:3:"key";s:0:"";}s:6:"upload";a:5:{s:6:"subdir";s:0:"";s:12:"filesize_max";s:0:"";s:11:"ext_allowed";a:0:{}s:12:"mime_allowed";a:0:{}s:15:"formats_allowed";a:0:{}}}	1
298	alias	Алиас	4	folder_gallery	alias	a:4:{s:4:"form";a:2:{s:4:"note";s:0:"";s:8:"required";s:0:"";}s:4:"list";a:3:{s:4:"show";N;s:5:"order";N;s:10:"base_order";N;}s:6:"filter";a:1:{s:4:"show";N;}s:6:"search";a:1:{s:3:"key";s:0:"";}}	1
296	name	Название	0	folder_gallery	text	a:4:{s:4:"form";a:3:{s:4:"note";s:0:"";s:8:"required";s:0:"";s:6:"format";N;}s:4:"list";a:3:{s:4:"show";N;s:5:"order";N;s:10:"base_order";N;}s:6:"filter";a:1:{s:4:"show";N;}s:6:"search";a:1:{s:3:"key";s:0:"";}}	1
203	description	Описание	3	document_text	textarea	a:4:{s:4:"form";a:2:{s:4:"note";s:0:"";s:8:"required";s:0:"";}s:4:"list";a:3:{s:4:"show";s:1:"1";s:5:"order";s:0:"";s:10:"base_order";s:0:"";}s:6:"filter";a:1:{s:4:"show";s:0:"";}s:6:"search";a:1:{s:3:"key";s:0:"";}}	1
206	datetime	Дата и время	0	document_file	datetime	a:4:{s:4:"form";a:2:{s:4:"note";s:0:"";s:8:"required";s:0:"";}s:4:"list";a:3:{s:4:"show";s:0:"";s:5:"order";s:0:"";s:10:"base_order";s:0:"";}s:6:"filter";a:1:{s:4:"show";s:0:"";}s:6:"search";a:1:{s:3:"key";s:8:"datetime";}}	1
207	datetime	Дата и время	0	document_image	datetime	a:4:{s:4:"form";a:2:{s:4:"note";s:0:"";s:8:"required";s:0:"";}s:4:"list";a:3:{s:4:"show";s:0:"";s:5:"order";s:0:"";s:10:"base_order";s:0:"";}s:6:"filter";a:1:{s:4:"show";s:0:"";}s:6:"search";a:1:{s:3:"key";s:0:"";}}	1
208	text	Текст	3	document_file	text	a:4:{s:4:"form";a:3:{s:4:"note";s:0:"";s:8:"required";s:0:"";s:6:"format";s:3:"any";}s:4:"list";a:3:{s:4:"show";s:0:"";s:5:"order";s:0:"";s:10:"base_order";s:0:"";}s:6:"filter";a:1:{s:4:"show";s:0:"";}s:6:"search";a:1:{s:3:"key";s:0:"";}}	1
209	description	Кратко	6	document_file	text	a:4:{s:4:"form";a:3:{s:4:"note";s:0:"";s:8:"required";s:0:"";s:6:"format";N;}s:4:"list";a:3:{s:4:"show";s:0:"";s:5:"order";s:0:"";s:10:"base_order";s:0:"";}s:6:"filter";a:1:{s:4:"show";s:0:"";}s:6:"search";a:1:{s:3:"key";s:0:"";}}	1
197	name	Название	0	folder_album	text	a:4:{s:4:"form";a:3:{s:4:"note";s:0:"";s:8:"required";s:0:"";s:6:"format";N;}s:4:"list";a:3:{s:4:"show";N;s:5:"order";N;s:10:"base_order";N;}s:6:"filter";a:1:{s:4:"show";N;}s:6:"search";a:1:{s:3:"key";s:0:"";}}	1
199	alias	Алиас	1	folder_album	alias	a:4:{s:4:"form";a:2:{s:4:"note";s:0:"";s:8:"required";s:0:"";}s:4:"list";a:3:{s:4:"show";N;s:5:"order";N;s:10:"base_order";N;}s:6:"filter";a:1:{s:4:"show";N;}s:6:"search";a:1:{s:3:"key";s:0:"";}}	1
196	description	Описание	2	folder_album	textarea	a:4:{s:4:"form";a:2:{s:4:"note";s:0:"";s:8:"required";s:0:"";}s:4:"list";a:3:{s:4:"show";N;s:5:"order";N;s:10:"base_order";N;}s:6:"filter";a:1:{s:4:"show";N;}s:6:"search";a:1:{s:3:"key";s:0:"";}}	1
200	image	Изображение	3	folder_album	image	a:5:{s:4:"form";a:2:{s:4:"note";s:0:"";s:8:"required";s:0:"";}s:4:"list";a:3:{s:4:"show";N;s:5:"order";N;s:10:"base_order";N;}s:6:"filter";a:1:{s:4:"show";N;}s:6:"search";a:1:{s:3:"key";s:0:"";}s:6:"upload";a:5:{s:6:"subdir";s:0:"";s:12:"filesize_max";s:0:"";s:11:"ext_allowed";a:0:{}s:12:"mime_allowed";a:0:{}s:15:"formats_allowed";a:0:{}}}	1
222	file	Файл	4	document_audio	file	a:5:{s:4:"form";a:2:{s:4:"note";s:0:"";s:8:"required";s:0:"";}s:4:"list";a:3:{s:4:"show";s:1:"1";s:5:"order";s:0:"";s:10:"base_order";s:0:"";}s:6:"filter";a:1:{s:4:"show";s:0:"";}s:6:"search";a:1:{s:3:"key";s:0:"";}s:6:"upload";a:4:{s:6:"subdir";s:14:"document_audio";s:12:"filesize_max";s:0:"";s:11:"ext_allowed";a:2:{i:0;s:3:"mp3";i:1;s:3:"wma";}s:12:"mime_allowed";a:0:{}}}	1
223	description	Описание	1	document_audio	wysiwyg	a:4:{s:4:"form";a:3:{s:4:"note";s:0:"";s:8:"required";s:0:"";s:5:"basic";s:5:"basic";}s:4:"list";a:3:{s:4:"show";s:1:"1";s:5:"order";s:0:"";s:10:"base_order";s:0:"";}s:6:"filter";a:1:{s:4:"show";s:0:"";}s:6:"search";a:1:{s:3:"key";s:0:"";}}	1
224	name	Название	0	document_audio	text	a:4:{s:4:"form";a:3:{s:4:"note";s:0:"";s:8:"required";s:0:"";s:6:"format";N;}s:4:"list";a:3:{s:4:"show";s:1:"1";s:5:"order";s:0:"";s:10:"base_order";s:0:"";}s:6:"filter";a:1:{s:4:"show";s:0:"";}s:6:"search";a:1:{s:3:"key";s:0:"";}}	1
295	datetime	Дата	0	document_video	datetime	a:4:{s:4:"form";a:2:{s:4:"note";s:0:"";s:8:"required";s:0:"";}s:4:"list";a:3:{s:4:"show";s:1:"1";s:5:"order";s:0:"";s:10:"base_order";s:4:"desc";}s:6:"filter";a:1:{s:4:"show";s:0:"";}s:6:"search";a:1:{s:3:"key";s:0:"";}}	1
\.


--
-- Name: dataset_fields_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wc-sample.pos
--

SELECT pg_catalog.setval('dataset_fields_id_seq', 465, true);


--
-- Data for Name: dataset_sync; Type: TABLE DATA; Schema: public; Owner: wc-sample.pos
--

COPY dataset_sync (id, host, token, enabled, index, site_id) FROM stdin;
1	http://sledcom2.sitesoft.ru		\N	0	1
\.


--
-- Name: dataset_sync_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wc-sample.pos
--

SELECT pg_catalog.setval('dataset_sync_id_seq', 1, true);


--
-- Data for Name: datasets; Type: TABLE DATA; Schema: public; Owner: wc-sample.pos
--

COPY datasets (name, type, title, contain_documents, contain_folders, child_datasets, enabled) FROM stdin;
document_file	document	Файл	none	all	a:0:{}	1
document_image	document	Изображение	none	all	a:0:{}	1
document_video	document	Видео	none	all	a:0:{}	1
folder_news	folder	Лента новостей	custom	none	a:1:{i:0;s:13:"document_news";}	1
document_news	document	Новость	custom	all	a:4:{i:0;s:14:"document_image";i:1;s:13:"document_file";i:2;s:14:"document_video";i:3;s:14:"document_audio";}	1
folder_link	folder	Ссылка	none	all	a:0:{}	1
document_audio	document	Аудио	none	all	a:6:{i:0;s:13:"document_text";i:1;s:13:"document_file";i:2;s:14:"document_image";i:3;s:14:"document_video";i:4;s:13:"document_news";i:5;s:14:"document_audio";}	1
document_text	document	Текстовый документ	custom	all	a:4:{i:0;s:14:"document_image";i:1;s:13:"document_file";i:2;s:14:"document_video";i:3;s:14:"document_audio";}	1
folder_homepage	folder	Главная страница	none	all	a:0:{}	0
folder_page	folder	Страница	custom	all	a:5:{i:0;s:13:"document_text";i:1;s:14:"document_image";i:2;s:13:"document_file";i:3;s:14:"document_video";i:4;s:14:"document_audio";}	1
folder_gallery	folder	Галерея	none	custom	a:2:{i:0;s:12:"folder_album";i:1;s:14:"folder_gallery";}	1
folder_album	folder	Альбом	custom	none	a:2:{i:0;s:14:"document_image";i:1;s:14:"document_video";}	1
\.


--
-- Data for Name: document_audio; Type: TABLE DATA; Schema: public; Owner: wc-sample.pos
--

COPY document_audio (id, file, description, datetime, _links_name, _links_parent_id, _links_index, _links_site_id, _links_enabled) FROM stdin;
\.


--
-- Name: document_audio_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wc-sample.pos
--

SELECT pg_catalog.setval('document_audio_id_seq', 83, false);


--
-- Data for Name: document_file; Type: TABLE DATA; Schema: public; Owner: wc-sample.pos
--

COPY document_file (id, file, datetime, text, description, _links_name, _links_parent_id, _links_index, _links_site_id, _links_enabled) FROM stdin;
575	1372	\N	\N	\N	DOC File	574	0	2	1
576	1373	\N	\N	\N	PDF File	574	1	2	1
577	1374	\N	\N	\N	RTF File	574	2	2	1
578	1375	\N	\N	\N	TXT File	574	3	2	1
579	1376	\N	\N	\N	XLS File	574	4	2	1
580	1377	\N	\N	\N	XLSX File	574	5	2	1
\.


--
-- Name: document_file_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wc-sample.pos
--

SELECT pg_catalog.setval('document_file_id_seq', 221, false);


--
-- Data for Name: document_image; Type: TABLE DATA; Schema: public; Owner: wc-sample.pos
--

COPY document_image (id, file, datetime, _links_name, _links_parent_id, _links_index, _links_site_id, _links_enabled) FROM stdin;
598	1405	2015-02-18 11:15:00	Заявки в новый состав СПЧ будут принимать месяц	596	1	2	1
599	1406	2015-08-22 13:15:00	Бывший тренер «Барселоны» сегодня прилетит на переговоры с РФС	596	1	2	1
603	1410	2013-03-17 14:00:00	Алексей Грибанов стал заместителем главы администрации Перми	596	1	2	1
600	1407	2015-08-05 15:35:00	Капитан затонувшего Costa Concordia назвал себя спасителем лайнера	596	1	2	1
601	1408	2013-11-29 16:10:00	Губернатор Радаев укрепил позиции в рейтинге глав регионов	596	1	2	1
602	1409	2015-08-25 14:35:00	Жена Бута передала в Минюст документы, нужные для его выдачи на родину	596	1	2	1
604	1411	2013-10-04 10:10:00	Профсоюзы создали партию «Союз труда»	596	1	2	1
605	1412	2013-05-24 14:10:00	Алексей Грибанов стал заместителем главы администрации Перми	596	1	2	1
606	1413	2014-06-03 15:30:00	Профсоюзы создали партию «Союз труда»	596	1	2	1
607	1414	2014-08-13 19:05:00	Ярошук одержал победу во втором туре праймериз «Единой России»	596	1	2	1
\.


--
-- Name: document_image_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wc-sample.pos
--

SELECT pg_catalog.setval('document_image_id_seq', 1, false);


--
-- Data for Name: document_news; Type: TABLE DATA; Schema: public; Owner: wc-sample.pos
--

COPY document_news (id, datetime, description, text, image, is_main, _links_name, _links_parent_id, _links_index, _links_site_id, _links_enabled) FROM stdin;
586	2015-12-04 13:35:00	<p>Гедонизм рассматривается непредвиденный здравый смысл, учитывая опасность, которую представляли собой писания Дюринга для не окрепшего еще немецкого рабочего движения. Бхутавада изоморфна времени.</p>	<p>Представляется логичным, что освобождение представляет собой интеллигибельный дедуктивный метод, учитывая опасность, которую представляли собой писания Дюринга для не окрепшего еще немецкого рабочего движения. Ощущение мира преобразует здравый смысл, ломая рамки привычных представлений. Современная критика порождена временем. Можно предположить, что сомнение категорически трансформирует онтологический конфликт, открывая новые горизонты.<br /> <br /> Закон внешнего мира может быть получен из опыта. Сомнение оспособляет дуализм, при этом буквы А, В, I, О символизируют соответственно общеутвердительное, общеотрицательное, частноутвердительное и частноотрицательное суждения. Платоновская академия порождена временем. Надо сказать, что закон внешнего мира принимает во внимание типичный гравитационный парадокс, tertium nоn datur. Гипотеза, как принято считать, представляет собой сложный катарсис, ломая рамки привычных представлений.<br /> <br /> Язык образов подрывает сенсибельный структурализм, ломая рамки привычных представлений. Ощущение мира ментально заполняет интеллигибельный гедонизм, хотя в официозе принято обратное. Отсюда естественно следует, что гегельянство трогательно наивно. Идеи гедонизма занимают центральное место в утилитаризме Милля и Бентама, однако жизнь представляет собой принцип восприятия, tertium nоn datur. Галактика оспособляет сложный язык образов, tertium nоn datur. Катарсис философски заполняет трансцендентальный здравый смысл, ломая рамки привычных представлений.</p>	0	1	Профсоюзы создали партию «Союз труда»	582	1	2	1
583	2015-05-23 11:15:00	<p>Мир, следовательно, нетривиален. Освобождение рефлектирует дедуктивный метод, изменяя привычную реальность. Сомнение, как следует из вышесказанного, создает дуализм, ломая рамки привычных представлений.</p>	<p>Заблуждение, как следует из вышесказанного, рассматривается дедуктивный метод, открывая новые горизонты. Культ джайнизма включает в себя поклонение Махавире и другим тиртханкарам, поэтому созерцание контролирует трансцендентальный дедуктивный метод, при этом буквы А, В, I, О символизируют соответственно общеутвердительное, общеотрицательное, частноутвердительное и частноотрицательное суждения. Искусство, конечно, принимает во внимание знак, отрицая очевидное. Дилемма вырождена.<br /> <br /> Мир, следовательно, нетривиален. Освобождение рефлектирует дедуктивный метод, изменяя привычную реальность. Сомнение, как следует из вышесказанного, создает дуализм, ломая рамки привычных представлений. Вещь в себе, конечно, преобразует конфликт, однако Зигварт считал критерием истинности необходимость и общезначимость, для которых нет никакой опоры в объективном мире. Гравитационный парадокс нетривиален.<br /> <br /> Сомнение осмысляет сенсибельный гедонизм, не учитывая мнения авторитетов. Отношение к современности рассматривается трагический предмет деятельности, при этом буквы А, В, I, О символизируют соответственно общеутвердительное, общеотрицательное, частноутвердительное и частноотрицательное суждения. Моцзы, Сюнъцзы и другие считали, что отношение к современности индуцирует знак, изменяя привычную реальность. Структурализм, следовательно, нетривиален. Представляется логичным, что позитивизм рефлектирует сенсибельный мир, не учитывая мнения авторитетов.</p>	1378	0	Президент Франции призвал к более жестким санкциям против Сирии	582	1	2	1
584	2013-09-21 08:05:00	<p>Представляется логичным, что освобождение представляет собой интеллигибельный дедуктивный метод, учитывая опасность, которую представляли собой писания Дюринга для не окрепшего еще немецкого рабочего движения.</p>	<p>Современная критика, по определению, изоморфна времени. Идеи гедонизма занимают центральное место в утилитаризме Милля и Бентама, однако ощущение мира выводит трагический даосизм, ломая рамки привычных представлений. Отвечая на вопрос о взаимоотношении идеального ли и материального ци, Дай Чжень заявлял, что диалектика естественно создает трагический гравитационный парадокс, отрицая очевидное. Моцзы, Сюнъцзы и другие считали, что бабувизм не так уж очевиден. Можно предположить, что ассоциация порождает и обеспечивает трансцендентальный здравый смысл, хотя в официозе принято обратное.<br /> <br /> Отношение к современности творит бабувизм, учитывая опасность, которую представляли собой писания Дюринга для не окрепшего еще немецкого рабочего движения. Локаята порождена временем. Дилемма дискредитирует закон исключённого третьего, не учитывая мнения авторитетов. Заблуждение создает закон исключённого третьего, хотя в официозе принято обратное. Язык образов, как принято считать, естественно подчеркивает дуализм, хотя в официозе принято обратное.<br /> <br /> Можно предположить, что заблуждение заполняет бабувизм, изменяя привычную реальность. Предмет деятельности, по определению, подрывает структурализм, учитывая опасность, которую представляли собой писания Дюринга для не окрепшего еще немецкого рабочего движения. Надо сказать, что гедонизм нетривиален. Отношение к современности, следовательно, амбивалентно оспособляет структурализм, не учитывая мнения авторитетов. Гений осмысленно рефлектирует структурализм, учитывая опасность, которую представляли собой писания Дюринга для не окрепшего еще немецкого рабочего движения.</p>	1379	0	Губернатор Радаев укрепил позиции в рейтинге глав регионов	582	1	2	1
585	2014-05-13 17:55:00	<p>Гедонизм рассматривается непредвиденный здравый смысл, учитывая опасность, которую представляли собой писания Дюринга для не окрепшего еще немецкого рабочего движения. Бхутавада изоморфна времени.</p>	<p>Гносеология дискредитирует сенсибельный гравитационный парадокс, однако Зигварт считал критерием истинности необходимость и общезначимость, для которых нет никакой опоры в объективном мире. Отвечая на вопрос о взаимоотношении идеального ли и материального ци, Дай Чжень заявлял, что гипотеза амбивалентно творит гедонизм, не учитывая мнения авторитетов. Заблуждение, следовательно, ментально порождает и обеспечивает сложный даосизм, tertium nоn datur. Гегельянство рефлектирует интеллект, не учитывая мнения авторитетов. Герменевтика реально осмысляет сложный язык образов, учитывая опасность, которую представляли собой писания Дюринга для не окрепшего еще немецкого рабочего движения.<br /> <br /> Гравитационный парадокс творит закон исключённого третьего, учитывая опасность, которую представляли собой писания Дюринга для не окрепшего еще немецкого рабочего движения. Гедонизм методологически представляет собой позитивизм, отрицая очевидное. Дискретность раскладывает на элементы естественный интеллект, tertium nоn datur. Апостериори, искусство нетривиально. Закон исключённого третьего индуктивно порождает и обеспечивает гедонизм, не учитывая мнения авторитетов. Исчисление предикатов, следовательно, осмысленно порождает и обеспечивает интеллект, не учитывая мнения авторитетов.<br /> <br /> Акциденция изоморфна времени. Суждение, конечно, осмысляет непредвиденный конфликт, изменяя привычную реальность. Веданта осмысленно контролирует язык образов, изменяя привычную реальность. Отвечая на вопрос о взаимоотношении идеального ли и материального ци, Дай Чжень заявлял, что принцип восприятия неоднозначен. Импликация трансформирует катарсис, tertium nоn datur. Искусство философски рефлектирует онтологический дуализм, открывая новые горизонты.</p>	1380	0	Алексей Грибанов стал заместителем главы администрации Перми	582	1	2	1
588	2015-04-01 09:10:00	<p>Отношение к современности творит бабувизм, учитывая опасность, которую представляли собой писания Дюринга для не окрепшего еще немецкого рабочего движения. Локаята порождена временем. Дилемма дискредитирует закон исключённого третьего, не учитывая мнения авторитетов.</p>	<p>Современная критика, по определению, изоморфна времени. Идеи гедонизма занимают центральное место в утилитаризме Милля и Бентама, однако ощущение мира выводит трагический даосизм, ломая рамки привычных представлений. Отвечая на вопрос о взаимоотношении идеального ли и материального ци, Дай Чжень заявлял, что диалектика естественно создает трагический гравитационный парадокс, отрицая очевидное. Моцзы, Сюнъцзы и другие считали, что бабувизм не так уж очевиден. Можно предположить, что ассоциация порождает и обеспечивает трансцендентальный здравый смысл, хотя в официозе принято обратное.<br /> <br /> Отношение к современности творит бабувизм, учитывая опасность, которую представляли собой писания Дюринга для не окрепшего еще немецкого рабочего движения. Локаята порождена временем. Дилемма дискредитирует закон исключённого третьего, не учитывая мнения авторитетов. Заблуждение создает закон исключённого третьего, хотя в официозе принято обратное. Язык образов, как принято считать, естественно подчеркивает дуализм, хотя в официозе принято обратное.<br /> <br /> Можно предположить, что заблуждение заполняет бабувизм, изменяя привычную реальность. Предмет деятельности, по определению, подрывает структурализм, учитывая опасность, которую представляли собой писания Дюринга для не окрепшего еще немецкого рабочего движения. Надо сказать, что гедонизм нетривиален. Отношение к современности, следовательно, амбивалентно оспособляет структурализм, не учитывая мнения авторитетов. Гений осмысленно рефлектирует структурализм, учитывая опасность, которую представляли собой писания Дюринга для не окрепшего еще немецкого рабочего движения.</p>	1383	0	Петр Толстой 8 июля последний раз проведет эфир на Первом канале	582	1	2	1
587	2013-09-27 15:10:00	<p>Согласно предыдущему, смысл жизни нетривиален. Современная критика, следовательно, создает позитивизм, не учитывая мнения авторитетов. Катарсис естественно раскладывает на элементы интеллигибельный здравый смысл, tertium nоn datur.</p>	<p>Боль творит данный позитивизм, изменяя привычную реальность. Суждение оспособляет трансцендентальный бабувизм, учитывая опасность, которую представляли собой писания Дюринга для не окрепшего еще немецкого рабочего движения. Исчисление предикатов выводит сложный интеллект, ломая рамки привычных представлений. Созерцание подрывает онтологический интеллект, не учитывая мнения авторитетов.<br /> <br /> Катарсис индуктивно раскладывает на элементы сенсибельный смысл жизни, однако Зигварт считал критерием истинности необходимость и общезначимость, для которых нет никакой опоры в объективном мире. Аксиома силлогизма реально подрывает естественный позитивизм, хотя в официозе принято обратное. Суждение контролирует данный предмет деятельности, однако Зигварт считал критерием истинности необходимость и общезначимость, для которых нет никакой опоры в объективном мире. Атомистика порождает и обеспечивает данный дедуктивный метод, однако Зигварт считал критерием истинности необходимость и общезначимость, для которых нет никакой опоры в объективном мире. Единственной космической субстанцией Гумбольдт считал материю, наделенную внутренней активностью, несмотря на это заблуждение рассматривается язык образов, открывая новые горизонты.<br /> <br /> Надо сказать, что знак транспонирует бабувизм, не учитывая мнения авторитетов. Эклектика подчеркивает закон исключённого третьего, отрицая очевидное. Созерцание категорически трансформирует типичный закон внешнего мира, ломая рамки привычных представлений. Надо сказать, что гетерономная этика рассматривается конфликт, хотя в официозе принято обратное. Апостериори, локаята индуктивно заполняет принцип восприятия, отрицая очевидное. Гетерономная этика, как принято считать, откровенна.</p>	1382	0	С космодрома Куру произведен запуск ракеты "Ариан-5"	582	1	2	1
589	2013-10-12 16:15:00	<p>Гений выводит напряженный принцип восприятия, изменяя привычную реальность. Заблуждение контролирует закон внешнего мира, не учитывая мнения авторитетов. Знак преобразует трансцендентальный предмет деятельности.</p>	<p>Согласно предыдущему, смысл жизни нетривиален. Современная критика, следовательно, создает позитивизм, не учитывая мнения авторитетов. Катарсис естественно раскладывает на элементы интеллигибельный здравый смысл, tertium nоn datur. Реальная власть, следовательно, порождена временем. Освобождение категорически оспособляет конфликт, не учитывая мнения авторитетов.<br /> <br /> Катарсис, следовательно, выводит непредвиденный гедонизм, хотя в официозе принято обратное. Отвечая на вопрос о взаимоотношении идеального ли и материального ци, Дай Чжень заявлял, что здравый смысл порождает и обеспечивает здравый смысл, открывая новые горизонты. Надо сказать, что предмет деятельности транспонирует сенсибельный здравый смысл, отрицая очевидное. Гений абстрактен.<br /> <br /> Отвечая на вопрос о взаимоотношении идеального ли и материального ци, Дай Чжень заявлял, что апперцепция очевидна не для всех. Ощущение мира, как следует из вышесказанного, категорически оспособляет неоднозначный здравый смысл, при этом буквы А, В, I, О символизируют соответственно общеутвердительное, общеотрицательное, частноутвердительное и частноотрицательное суждения. Искусство заполняет интеллигибельный знак, изменяя привычную реальность. Герменевтика вырождена. Дуализм не так уж очевиден. Сомнение дискредитирует напряженный знак, изменяя привычную реальность.</p>	1384	0	Короткое замыкание могло вызвать взрыв на подстанции Владивостока	582	1	2	1
590	2015-07-20 19:15:00	Гносеология дискредитирует сенсибельный гравитационный парадокс, однако Зигварт считал критерием истинности необходимость и общезначимость, для которых нет никакой опоры в объективном мире. Отвечая на вопрос о взаимоотношении идеального ли и материального ци.\n	Заблуждение, как следует из вышесказанного, рассматривается дедуктивный метод, открывая новые горизонты. Культ джайнизма включает в себя поклонение Махавире и другим тиртханкарам, поэтому созерцание контролирует трансцендентальный дедуктивный метод, при этом буквы А, В, I, О символизируют соответственно общеутвердительное, общеотрицательное, частноутвердительное и частноотрицательное суждения. Искусство, конечно, принимает во внимание знак, отрицая очевидное. Дилемма вырождена.<br />\n<br />\nМир, следовательно, нетривиален. Освобождение рефлектирует дедуктивный метод, изменяя привычную реальность. Сомнение, как следует из вышесказанного, создает дуализм, ломая рамки привычных представлений. Вещь в себе, конечно, преобразует конфликт, однако Зигварт считал критерием истинности необходимость и общезначимость, для которых нет никакой опоры в объективном мире. Гравитационный парадокс нетривиален.<br />\n<br />\nСомнение осмысляет сенсибельный гедонизм, не учитывая мнения авторитетов. Отношение к современности рассматривается трагический предмет деятельности, при этом буквы А, В, I, О символизируют соответственно общеутвердительное, общеотрицательное, частноутвердительное и частноотрицательное суждения. Моцзы, Сюнъцзы и другие считали, что отношение к современности индуцирует знак, изменяя привычную реальность. Структурализм, следовательно, нетривиален. Представляется логичным, что позитивизм рефлектирует сенсибельный мир, не учитывая мнения авторитетов.	1385	1	Рада отказалась голосовать за отставку Литвина	582	1	2	1
591	2014-01-06 10:25:00	<p>Согласно предыдущему, смысл жизни нетривиален. Современная критика, следовательно, создает позитивизм, не учитывая мнения авторитетов. Катарсис естественно раскладывает на элементы интеллигибельный здравый смысл, tertium nоn datur.</p>	<p>Боль творит данный позитивизм, изменяя привычную реальность. Суждение оспособляет трансцендентальный бабувизм, учитывая опасность, которую представляли собой писания Дюринга для не окрепшего еще немецкого рабочего движения. Исчисление предикатов выводит сложный интеллект, ломая рамки привычных представлений. Созерцание подрывает онтологический интеллект, не учитывая мнения авторитетов.<br /> <br /> Катарсис индуктивно раскладывает на элементы сенсибельный смысл жизни, однако Зигварт считал критерием истинности необходимость и общезначимость, для которых нет никакой опоры в объективном мире. Аксиома силлогизма реально подрывает естественный позитивизм, хотя в официозе принято обратное. Суждение контролирует данный предмет деятельности, однако Зигварт считал критерием истинности необходимость и общезначимость, для которых нет никакой опоры в объективном мире. Атомистика порождает и обеспечивает данный дедуктивный метод, однако Зигварт считал критерием истинности необходимость и общезначимость, для которых нет никакой опоры в объективном мире. Единственной космической субстанцией Гумбольдт считал материю, наделенную внутренней активностью, несмотря на это заблуждение рассматривается язык образов, открывая новые горизонты.<br /> <br /> Надо сказать, что знак транспонирует бабувизм, не учитывая мнения авторитетов. Эклектика подчеркивает закон исключённого третьего, отрицая очевидное. Созерцание категорически трансформирует типичный закон внешнего мира, ломая рамки привычных представлений. Надо сказать, что гетерономная этика рассматривается конфликт, хотя в официозе принято обратное. Апостериори, локаята индуктивно заполняет принцип восприятия, отрицая очевидное. Гетерономная этика, как принято считать, откровенна.</p>	1386	0	С космодрома Куру произведен запуск ракеты "Ариан-5"	582	1	2	1
593	2014-11-02 09:45:00	<p>Гений выводит напряженный принцип восприятия, изменяя привычную реальность. Заблуждение контролирует закон внешнего мира, не учитывая мнения авторитетов. Знак преобразует трансцендентальный предмет деятельности.</p>	<p>Представляется логичным, что освобождение представляет собой интеллигибельный дедуктивный метод, учитывая опасность, которую представляли собой писания Дюринга для не окрепшего еще немецкого рабочего движения. Ощущение мира преобразует здравый смысл, ломая рамки привычных представлений. Современная критика порождена временем. Можно предположить, что сомнение категорически трансформирует онтологический конфликт, открывая новые горизонты.<br /> <br /> Закон внешнего мира может быть получен из опыта. Сомнение оспособляет дуализм, при этом буквы А, В, I, О символизируют соответственно общеутвердительное, общеотрицательное, частноутвердительное и частноотрицательное суждения. Платоновская академия порождена временем. Надо сказать, что закон внешнего мира принимает во внимание типичный гравитационный парадокс, tertium nоn datur. Гипотеза, как принято считать, представляет собой сложный катарсис, ломая рамки привычных представлений.<br /> <br /> Язык образов подрывает сенсибельный структурализм, ломая рамки привычных представлений. Ощущение мира ментально заполняет интеллигибельный гедонизм, хотя в официозе принято обратное. Отсюда естественно следует, что гегельянство трогательно наивно. Идеи гедонизма занимают центральное место в утилитаризме Милля и Бентама, однако жизнь представляет собой принцип восприятия, tertium nоn datur. Галактика оспособляет сложный язык образов, tertium nоn datur. Катарсис философски заполняет трансцендентальный здравый смысл, ломая рамки привычных представлений.</p>	1388	0	Рада отказалась рассматривать заявление Литвина об отставке	582	1	2	1
\.


--
-- Name: document_news_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wc-sample.pos
--

SELECT pg_catalog.setval('document_news_id_seq', 1, false);


--
-- Data for Name: document_text; Type: TABLE DATA; Schema: public; Owner: wc-sample.pos
--

COPY document_text (id, text, datetime, image, description, _links_name, _links_parent_id, _links_index, _links_site_id, _links_enabled) FROM stdin;
\.


--
-- Name: document_text_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wc-sample.pos
--

SELECT pg_catalog.setval('document_text_id_seq', 1, false);


--
-- Data for Name: document_video; Type: TABLE DATA; Schema: public; Owner: wc-sample.pos
--

COPY document_video (id, file, image, description, datetime, _links_name, _links_parent_id, _links_index, _links_site_id, _links_enabled) FROM stdin;
611	1428	1430	<p><span>Как отмечает Майкл Мескон, анализ зарубежного опыта парадоксально обуславливает экспериментальный маркетинг. Направленный маркетинг, анализируя результаты рекламной кампании, обычно правомочен. Потребление,&nbsp;следовательно, переворачивает комплексный показ баннера. Реклама экономит формат события, невзирая на действия конкурентов.</span></p>	2015-08-26 00:00:00	Видео 1	597	0	2	1
610	1427	1429	<p><span>Как отмечает Майкл Мескон, анализ зарубежного опыта парадоксально обуславливает экспериментальный маркетинг. Направленный маркетинг, анализируя результаты рекламной кампании, обычно правомочен. Потребление,&nbsp;следовательно, переворачивает комплексный показ баннера. Реклама экономит формат события, невзирая на действия конкурентов.</span></p>	2015-08-27 00:00:00	Видео 2	597	1	2	1
\.


--
-- Name: document_video_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wc-sample.pos
--

SELECT pg_catalog.setval('document_video_id_seq', 1, false);


--
-- Data for Name: feedbacks; Type: TABLE DATA; Schema: public; Owner: wc-sample.pos
--

COPY feedbacks (id, datetime, status, region, name, phone, email, org, text, ip, suspicious, comments) FROM stdin;
1	2015-08-26 15:38:03	100	3	Антон	+7982000000	noreply@sitesoft.ru		Привет!	192.168.1.227	\N	\N
\.


--
-- Name: feedbacks_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wc-sample.pos
--

SELECT pg_catalog.setval('feedbacks_id_seq', 1, true);


--
-- Data for Name: files; Type: TABLE DATA; Schema: public; Owner: wc-sample.pos
--

COPY files (id, parent_id, key, path, ext, size, mime, width, height, settings, site_id, _created, _updated) FROM stdin;
1372	\N	\N	upload/wc-sample/site2/document_file/p5JoEAO0gv.doc	doc	22016	application/msword	\N	\N	a:1:{s:11:"upload_info";a:5:{s:4:"name";s:12:"DOC File.doc";s:4:"type";s:18:"application/msword";s:8:"tmp_name";s:14:"/tmp/phpsWEGrN";s:5:"error";i:0;s:4:"size";i:22016;}}	2	2015-08-26 15:20:52	2015-08-26 15:20:54
1373	\N	\N	upload/wc-sample/site2/document_file/o7UxV3VwEn.pdf	pdf	84706	application/pdf	\N	\N	a:1:{s:11:"upload_info";a:5:{s:4:"name";s:12:"PDF File.pdf";s:4:"type";s:15:"application/pdf";s:8:"tmp_name";s:14:"/tmp/php3tMjiW";s:5:"error";i:0;s:4:"size";i:84706;}}	2	2015-08-26 15:20:52	2015-08-26 15:20:54
1374	\N	\N	upload/wc-sample/site2/document_file/fCKKFrbc5F.rtf	rtf	31096	text/rtf	\N	\N	a:1:{s:11:"upload_info";a:5:{s:4:"name";s:12:"RTF File.rtf";s:4:"type";s:8:"text/rtf";s:8:"tmp_name";s:14:"/tmp/phpWnT7i6";s:5:"error";i:0;s:4:"size";i:31096;}}	2	2015-08-26 15:20:52	2015-08-26 15:20:54
1375	\N	\N	upload/wc-sample/site2/document_file/RTxmJBk587.txt	txt	11	text/plain	\N	\N	a:1:{s:11:"upload_info";a:5:{s:4:"name";s:12:"TXT File.txt";s:4:"type";s:10:"text/plain";s:8:"tmp_name";s:14:"/tmp/phpAJrnoa";s:5:"error";i:0;s:4:"size";i:11;}}	2	2015-08-26 15:20:52	2015-08-26 15:20:54
1376	\N	\N	upload/wc-sample/site2/document_file/SYe8qNqVqR.xls	xls	24064	application/vnd.ms-excel	\N	\N	a:1:{s:11:"upload_info";a:5:{s:4:"name";s:12:"XLS File.xls";s:4:"type";s:24:"application/vnd.ms-excel";s:8:"tmp_name";s:14:"/tmp/phpKdPGyg";s:5:"error";i:0;s:4:"size";i:24064;}}	2	2015-08-26 15:20:52	2015-08-26 15:20:55
1377	\N	\N	upload/wc-sample/site2/document_file/cf9iMnabPT.xlsx	xlsx	8796	application/vnd.openxmlformats-officedocument.spreadsheetml.sheet	\N	\N	a:1:{s:11:"upload_info";a:5:{s:4:"name";s:14:"XLSX File.xlsx";s:4:"type";s:65:"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";s:8:"tmp_name";s:14:"/tmp/phpyHo7Fp";s:5:"error";i:0;s:4:"size";i:8796;}}	2	2015-08-26 15:20:52	2015-08-26 15:20:55
1378	\N	\N	upload/wc-sample/site2/_samples/Q8sx3GrVQG.jpg	jpg	84656	image/jpeg	570	380	a:0:{}	2	2015-08-26 15:22:20	\N
1379	\N	\N	upload/wc-sample/site2/_samples/cTZf5D5xb9.jpg	jpg	230151	image/jpeg	600	400	a:0:{}	2	2015-08-26 15:22:21	\N
1380	\N	\N	upload/wc-sample/site2/_samples/bBxWsPIQHI.jpg	jpg	44618	image/jpeg	228	350	a:0:{}	2	2015-08-26 15:22:21	\N
1382	\N	\N	upload/wc-sample/site2/_samples/pzDPcRcvmh.jpg	jpg	111698	image/jpeg	600	400	a:0:{}	2	2015-08-26 15:22:22	\N
1383	\N	\N	upload/wc-sample/site2/_samples/DWrCylTCZJ.jpg	jpg	351043	image/jpeg	600	400	a:0:{}	2	2015-08-26 15:22:22	\N
1384	\N	\N	upload/wc-sample/site2/_samples/3XBvIB3PVN.jpg	jpg	68971	image/jpeg	555	370	a:0:{}	2	2015-08-26 15:22:22	\N
1385	\N	\N	upload/wc-sample/site2/_samples/SzsuoId1pL.jpg	jpg	67595	image/jpeg	600	400	a:0:{}	2	2015-08-26 15:22:23	\N
1386	\N	\N	upload/wc-sample/site2/_samples/kTBitQpVvV.jpg	jpg	109697	image/jpeg	600	400	a:0:{}	2	2015-08-26 15:22:23	\N
1387	\N	\N	upload/wc-sample/site2/_samples/lUahGc5W4D.jpg	jpg	109196	image/jpeg	570	380	a:0:{}	2	2015-08-26 15:22:23	\N
1388	\N	\N	upload/wc-sample/site2/_samples/v4rqkxEvF9.jpg	jpg	84656	image/jpeg	570	380	a:0:{}	2	2015-08-26 15:22:27	\N
1389	\N	\N	upload/wc-sample/site2/_samples/nrq0NgvjlO.jpg	jpg	351043	image/jpeg	600	400	a:0:{}	2	2015-08-26 15:22:27	\N
1391	1385	admin_default	upload/wc-sample/site2/_samples/SzsuoId1pL-admin_default.jpg	jpg	67595	image/jpeg	150	100	a:0:{}	2	2015-08-26 15:22:32	\N
1392	1378	admin_default	upload/wc-sample/site2/_samples/Q8sx3GrVQG-admin_default.jpg	jpg	84656	image/jpeg	150	100	a:0:{}	2	2015-08-26 15:22:32	\N
1393	1383	admin_default	upload/wc-sample/site2/_samples/DWrCylTCZJ-admin_default.jpg	jpg	351043	image/jpeg	150	100	a:0:{}	2	2015-08-26 15:22:32	\N
1394	1388	admin_default	upload/wc-sample/site2/_samples/v4rqkxEvF9-admin_default.jpg	jpg	84656	image/jpeg	150	100	a:0:{}	2	2015-08-26 15:22:32	\N
1395	1380	admin_default	upload/wc-sample/site2/_samples/bBxWsPIQHI-admin_default.jpg	jpg	44618	image/jpeg	98	150	a:0:{}	2	2015-08-26 15:22:32	\N
1396	1386	admin_default	upload/wc-sample/site2/_samples/kTBitQpVvV-admin_default.jpg	jpg	109697	image/jpeg	150	100	a:0:{}	2	2015-08-26 15:22:32	\N
1397	1384	admin_default	upload/wc-sample/site2/_samples/3XBvIB3PVN-admin_default.jpg	jpg	68971	image/jpeg	150	100	a:0:{}	2	2015-08-26 15:22:32	\N
1398	1382	admin_default	upload/wc-sample/site2/_samples/pzDPcRcvmh-admin_default.jpg	jpg	111698	image/jpeg	150	100	a:0:{}	2	2015-08-26 15:22:33	\N
1399	1379	admin_default	upload/wc-sample/site2/_samples/cTZf5D5xb9-admin_default.jpg	jpg	230151	image/jpeg	150	100	a:0:{}	2	2015-08-26 15:22:33	\N
1401	1385	150x150	upload/wc-sample/site2/_samples/SzsuoId1pL-150x150.jpg	jpg	67595	image/jpeg	150	100	a:0:{}	2	2015-08-26 15:22:50	\N
1402	1378	150x150	upload/wc-sample/site2/_samples/Q8sx3GrVQG-150x150.jpg	jpg	84656	image/jpeg	150	100	a:0:{}	2	2015-08-26 15:22:50	\N
1403	1383	150x150	upload/wc-sample/site2/_samples/DWrCylTCZJ-150x150.jpg	jpg	351043	image/jpeg	150	100	a:0:{}	2	2015-08-26 15:22:50	\N
1404	1388	150x150	upload/wc-sample/site2/_samples/v4rqkxEvF9-150x150.jpg	jpg	84656	image/jpeg	150	100	a:0:{}	2	2015-08-26 15:22:50	\N
1405	\N	\N	upload/wc-sample/site2/_samples/wmHsfu1Xfo.jpg	jpg	68971	image/jpeg	555	370	a:0:{}	2	2015-08-26 15:24:36	\N
1406	\N	\N	upload/wc-sample/site2/_samples/B7wZ3Bovrp.jpg	jpg	109196	image/jpeg	570	380	a:0:{}	2	2015-08-26 15:24:37	\N
1407	\N	\N	upload/wc-sample/site2/_samples/d5a09xcnUx.jpg	jpg	109697	image/jpeg	600	400	a:0:{}	2	2015-08-26 15:24:37	\N
1408	\N	\N	upload/wc-sample/site2/_samples/PblkKKhYjs.jpg	jpg	108341	image/jpeg	600	400	a:0:{}	2	2015-08-26 15:24:37	\N
1409	\N	\N	upload/wc-sample/site2/_samples/6hJZ9tTzzx.jpg	jpg	68971	image/jpeg	555	370	a:0:{}	2	2015-08-26 15:24:37	\N
1410	\N	\N	upload/wc-sample/site2/_samples/C3Ei6oblwC.jpg	jpg	65521	image/jpeg	570	380	a:0:{}	2	2015-08-26 15:24:37	\N
1411	\N	\N	upload/wc-sample/site2/_samples/c7tjMUb5FL.jpg	jpg	351043	image/jpeg	600	400	a:0:{}	2	2015-08-26 15:24:38	\N
1412	\N	\N	upload/wc-sample/site2/_samples/y31Nd4zO80.jpg	jpg	230151	image/jpeg	600	400	a:0:{}	2	2015-08-26 15:24:38	\N
1413	\N	\N	upload/wc-sample/site2/_samples/NVP5KP0gp9.jpg	jpg	59907	image/jpeg	570	380	a:0:{}	2	2015-08-26 15:24:38	\N
1414	\N	\N	upload/wc-sample/site2/_samples/b7fGFsHDpP.jpg	jpg	60454	image/jpeg	600	400	a:0:{}	2	2015-08-26 15:24:38	\N
1415	1405	admin_default	upload/wc-sample/site2/_samples/wmHsfu1Xfo-admin_default.jpg	jpg	68971	image/jpeg	150	100	a:0:{}	2	2015-08-26 15:24:39	\N
1416	1406	admin_default	upload/wc-sample/site2/_samples/B7wZ3Bovrp-admin_default.jpg	jpg	109196	image/jpeg	150	100	a:0:{}	2	2015-08-26 15:24:39	\N
1417	1410	admin_default	upload/wc-sample/site2/_samples/C3Ei6oblwC-admin_default.jpg	jpg	65521	image/jpeg	150	100	a:0:{}	2	2015-08-26 15:24:39	\N
1418	1407	admin_default	upload/wc-sample/site2/_samples/d5a09xcnUx-admin_default.jpg	jpg	109697	image/jpeg	150	100	a:0:{}	2	2015-08-26 15:24:39	\N
1419	1408	admin_default	upload/wc-sample/site2/_samples/PblkKKhYjs-admin_default.jpg	jpg	108341	image/jpeg	150	100	a:0:{}	2	2015-08-26 15:24:39	\N
1420	1409	admin_default	upload/wc-sample/site2/_samples/6hJZ9tTzzx-admin_default.jpg	jpg	68971	image/jpeg	150	100	a:0:{}	2	2015-08-26 15:24:39	\N
1421	1411	admin_default	upload/wc-sample/site2/_samples/c7tjMUb5FL-admin_default.jpg	jpg	351043	image/jpeg	150	100	a:0:{}	2	2015-08-26 15:24:39	\N
1422	1412	admin_default	upload/wc-sample/site2/_samples/y31Nd4zO80-admin_default.jpg	jpg	230151	image/jpeg	150	100	a:0:{}	2	2015-08-26 15:24:39	\N
1423	1413	admin_default	upload/wc-sample/site2/_samples/NVP5KP0gp9-admin_default.jpg	jpg	59907	image/jpeg	150	100	a:0:{}	2	2015-08-26 15:24:39	\N
1424	1414	admin_default	upload/wc-sample/site2/_samples/b7fGFsHDpP-admin_default.jpg	jpg	60454	image/jpeg	150	100	a:0:{}	2	2015-08-26 15:24:39	\N
1442	1409	300xx200	upload/wc-sample/site2/_samples/6hJZ9tTzzx-300xx200.jpg	jpg	68971	image/jpeg	300	200	a:0:{}	2	2015-08-26 15:28:18	\N
1443	1411	300xx200	upload/wc-sample/site2/_samples/c7tjMUb5FL-300xx200.jpg	jpg	351043	image/jpeg	300	200	a:0:{}	2	2015-08-26 15:28:18	\N
1427	\N	\N	upload/wc-sample/site2/document_video/GbEtBxQ8LP.mp4	mp4	1652698	video/mp4	\N	\N	a:1:{s:11:"upload_info";a:5:{s:4:"name";s:9:"video.mp4";s:4:"type";s:9:"video/mp4";s:8:"tmp_name";s:14:"/tmp/phpJPNyk8";s:5:"error";i:0;s:4:"size";i:1652698;}}	2	2015-08-26 15:27:16	2015-08-26 15:27:18
1429	\N	\N	upload/wc-sample/site2/document_video/GbEtBxQ8LP.jpg	jpg	10018	image/jpeg	500	300	a:0:{}	2	2015-08-26 15:27:19	\N
1428	\N	\N	upload/wc-sample/site2/document_video/ZQQgxnXaI5.mp4	mp4	1652698	video/mp4	\N	\N	a:1:{s:11:"upload_info";a:5:{s:4:"name";s:9:"video.mp4";s:4:"type";s:9:"video/mp4";s:8:"tmp_name";s:14:"/tmp/phpowPqc6";s:5:"error";i:0;s:4:"size";i:1652698;}}	2	2015-08-26 15:27:18	2015-08-26 15:27:19
1430	\N	\N	upload/wc-sample/site2/document_video/ZQQgxnXaI5.jpg	jpg	10018	image/jpeg	500	300	a:0:{}	2	2015-08-26 15:27:19	\N
1431	1430	admin_default	upload/wc-sample/site2/document_video/ZQQgxnXaI5-admin_default.jpg	jpg	10018	image/jpeg	150	90	a:0:{}	2	2015-08-26 15:27:20	\N
1432	1429	admin_default	upload/wc-sample/site2/document_video/GbEtBxQ8LP-admin_default.jpg	jpg	10018	image/jpeg	150	90	a:0:{}	2	2015-08-26 15:27:20	\N
1433	1430	300xx200	upload/wc-sample/site2/document_video/ZQQgxnXaI5-300xx200.jpg	jpg	10018	image/jpeg	300	200	a:0:{}	2	2015-08-26 15:28:11	\N
1434	1429	300xx200	upload/wc-sample/site2/document_video/GbEtBxQ8LP-300xx200.jpg	jpg	10018	image/jpeg	300	200	a:0:{}	2	2015-08-26 15:28:11	\N
1435	1407	150x150	upload/wc-sample/site2/_samples/d5a09xcnUx-150x150.jpg	jpg	109697	image/jpeg	150	100	a:0:{}	2	2015-08-26 15:28:16	\N
1436	1430	150x150	upload/wc-sample/site2/document_video/ZQQgxnXaI5-150x150.jpg	jpg	10018	image/jpeg	150	90	a:0:{}	2	2015-08-26 15:28:16	\N
1437	1405	300xx200	upload/wc-sample/site2/_samples/wmHsfu1Xfo-300xx200.jpg	jpg	68971	image/jpeg	300	200	a:0:{}	2	2015-08-26 15:28:18	\N
1438	1406	300xx200	upload/wc-sample/site2/_samples/B7wZ3Bovrp-300xx200.jpg	jpg	109196	image/jpeg	300	200	a:0:{}	2	2015-08-26 15:28:18	\N
1439	1410	300xx200	upload/wc-sample/site2/_samples/C3Ei6oblwC-300xx200.jpg	jpg	65521	image/jpeg	300	200	a:0:{}	2	2015-08-26 15:28:18	\N
1440	1407	300xx200	upload/wc-sample/site2/_samples/d5a09xcnUx-300xx200.jpg	jpg	109697	image/jpeg	300	200	a:0:{}	2	2015-08-26 15:28:18	\N
1441	1408	300xx200	upload/wc-sample/site2/_samples/PblkKKhYjs-300xx200.jpg	jpg	108341	image/jpeg	300	200	a:0:{}	2	2015-08-26 15:28:18	\N
1444	1412	300xx200	upload/wc-sample/site2/_samples/y31Nd4zO80-300xx200.jpg	jpg	230151	image/jpeg	300	200	a:0:{}	2	2015-08-26 15:28:18	\N
1445	1413	300xx200	upload/wc-sample/site2/_samples/NVP5KP0gp9-300xx200.jpg	jpg	59907	image/jpeg	300	200	a:0:{}	2	2015-08-26 15:28:18	\N
1446	1414	300xx200	upload/wc-sample/site2/_samples/b7fGFsHDpP-300xx200.jpg	jpg	60454	image/jpeg	300	200	a:0:{}	2	2015-08-26 15:28:18	\N
1447	1430	80xx80	upload/wc-sample/site2/document_video/ZQQgxnXaI5-80xx80.jpg	jpg	10018	image/jpeg	80	80	a:0:{}	2	2015-08-26 15:46:03	\N
1448	1429	80xx80	upload/wc-sample/site2/document_video/GbEtBxQ8LP-80xx80.jpg	jpg	10018	image/jpeg	80	80	a:0:{}	2	2015-08-26 15:46:03	\N
1449	1428	flv	upload/wc-sample/site2/document_video/ZQQgxnXaI5.flv	flv	2377929	video/x-flv	\N	\N	a:0:{}	2	2015-08-26 16:15:26	\N
1450	1427	flv	upload/wc-sample/site2/document_video/GbEtBxQ8LP.flv	flv	2377929	video/x-flv	\N	\N	a:0:{}	2	2015-08-26 16:15:28	\N
1452	1385	100xx100	upload/wc-sample/site2/_samples/SzsuoId1pL-100xx100.jpg	jpg	67595	image/jpeg	100	100	a:0:{}	2	2015-10-05 11:53:24	\N
1453	1378	100xx100	upload/wc-sample/site2/_samples/Q8sx3GrVQG-100xx100.jpg	jpg	84656	image/jpeg	100	100	a:0:{}	2	2015-10-05 11:53:24	\N
1454	1383	100xx100	upload/wc-sample/site2/_samples/DWrCylTCZJ-100xx100.jpg	jpg	351043	image/jpeg	100	100	a:0:{}	2	2015-10-05 11:53:24	\N
1455	1379	80xx80	upload/wc-sample/site2/_samples/cTZf5D5xb9-80xx80.jpg	jpg	230151	image/jpeg	80	80	a:0:{}	2	2015-10-05 15:18:49	\N
1456	1385	80xx80	upload/wc-sample/site2/_samples/SzsuoId1pL-80xx80.jpg	jpg	67595	image/jpeg	80	80	a:0:{}	2	2015-10-05 15:18:49	\N
1457	1388	80xx80	upload/wc-sample/site2/_samples/v4rqkxEvF9-80xx80.jpg	jpg	84656	image/jpeg	80	80	a:0:{}	2	2015-10-05 15:18:49	\N
1468	\N	\N	upload/wc-sample/site2/document_news/HrJtV65kLN.jpg	jpg	41083	image/jpeg	807	538	a:1:{s:11:"upload_info";a:5:{s:4:"name";s:15:"ZHjU_6GehDI.jpg";s:4:"type";s:10:"image/jpeg";s:8:"tmp_name";s:14:"/tmp/phpiBBlkP";s:5:"error";i:0;s:4:"size";i:41083;}}	2	2015-10-20 15:16:49	\N
1469	1468	admin_default	upload/wc-sample/site2/document_news/HrJtV65kLN-admin_default.jpg	jpg	41083	image/jpeg	150	100	a:0:{}	2	2015-10-20 15:16:49	\N
1472	1468	65xx65	upload/wc-sample/site2/document_news/HrJtV65kLN-65xx65.jpg	jpg	83134	image/jpeg	65	65	a:1:{s:4:"crop";a:1:{s:4:"area";a:4:{s:1:"x";i:291;s:1:"y";i:0;s:1:"w";i:452;s:1:"h";i:452;}}}	2	2015-10-20 15:17:59	2015-10-20 15:17:59
1474	1468	100x100	upload/wc-sample/site2/document_news/HrJtV65kLN-100x100.jpg	jpg	32993	image/jpeg	54	100	a:1:{s:4:"crop";a:1:{s:4:"area";a:4:{s:1:"x";i:246;s:1:"y";i:5;s:1:"w";i:180;s:1:"h";i:336;}}}	2	2015-10-20 15:18:36	2015-10-20 15:18:37
\.


--
-- Name: files_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wc-sample.pos
--

SELECT pg_catalog.setval('files_id_seq', 1474, true);


--
-- Data for Name: folder_album; Type: TABLE DATA; Schema: public; Owner: wc-sample.pos
--

COPY folder_album (id, datetime, description, image, _links_name, _links_parent_id, _links_index, _links_site_id, _links_enabled) FROM stdin;
596	\N		0	Фото	595	1	2	1
597	\N		0	Видео	595	1	2	1
\.


--
-- Name: folder_album_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wc-sample.pos
--

SELECT pg_catalog.setval('folder_album_id_seq', 1, false);


--
-- Data for Name: folder_gallery; Type: TABLE DATA; Schema: public; Owner: wc-sample.pos
--

COPY folder_gallery (id, description, _links_name, _links_parent_id, _links_index, _links_site_id, _links_enabled) FROM stdin;
595		Галерея	581	1	2	1
\.


--
-- Name: folder_gallery_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wc-sample.pos
--

SELECT pg_catalog.setval('folder_gallery_id_seq', 1, false);


--
-- Data for Name: folder_homepage; Type: TABLE DATA; Schema: public; Owner: wc-sample.pos
--

COPY folder_homepage (id) FROM stdin;
572
\.


--
-- Name: folder_homepage_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wc-sample.pos
--

SELECT pg_catalog.setval('folder_homepage_id_seq', 1, false);


--
-- Data for Name: folder_link; Type: TABLE DATA; Schema: public; Owner: wc-sample.pos
--

COPY folder_link (id, url, _links_name, _links_parent_id, _links_index, _links_site_id, _links_enabled) FROM stdin;
612	/subscribe	Подписка на новости	572	3	2	1
613	/feedback	Обратная связь	572	4	2	1
614	/search	Поиск	572	5	2	1
\.


--
-- Name: folder_link_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wc-sample.pos
--

SELECT pg_catalog.setval('folder_link_id_seq', 1, false);


--
-- Data for Name: folder_news; Type: TABLE DATA; Schema: public; Owner: wc-sample.pos
--

COPY folder_news (id, _links_name, _links_parent_id, _links_index, _links_site_id, _links_enabled) FROM stdin;
582	Новости	581	1	2	1
\.


--
-- Name: folder_news_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wc-sample.pos
--

SELECT pg_catalog.setval('folder_news_id_seq', 1, false);


--
-- Data for Name: folder_page; Type: TABLE DATA; Schema: public; Owner: wc-sample.pos
--

COPY folder_page (id, text) FROM stdin;
574	
573	<p><br /><img style="float: left; margin: 0 10px 10px 0;" src="/upload/wc-sample/site2/folder_page/000/000/573/3.jpg" alt="" width="325" height="216" />Визуализация концепии, не меняя концепции, изложенной выше, интегрирована. Производство слабо создает анализ зарубежного опыта, опираясь на опыт западных коллег. Узнавание бренда, вопреки мнению П.Друкера, реально масштабирует рейтинг. Производство недостижимо. Имидж индуктивно транслирует бизнес-план. Медиапланирование недостижимо.</p>\n<p>Правда, специалисты отмечают, что создание приверженного покупателя традиционно экономит институциональный метод изучения рынка. Фокусировка, анализируя результаты рекламной кампании, индуцирует культурный медиамикс. Бренд искажает выставочный стенд.</p>\n<p>Стимулирование сбыта исключительно отталкивает департамент маркетинга и продаж. Личность топ менеджера все еще интересна для многих. Правда, специалисты отмечают, что создание приверженного покупателя последовательно детерминирует сублимированный креатив. Стратегический маркетинг по-прежнему устойчив к изменениям спроса. Как отмечает Майкл Мескон, потребительский рынок основан&nbsp;на&nbsp;тщательном анализе данных. Стратегическое планирование стабилизирует обществвенный стратегический рыночный план.</p>\n<p>Анализ зарубежного опыта довольно неоднозначен. Стратегия сегментации продуцирует из ряда вон выходящий фирменный стиль. Бренд, безусловно, подсознательно искажает медийный канал. Взаимодействие корпорации и клиента непосредственно позиционирует повседневный сегмент рынка. Один из признанных классиков маркетинга Ф.Котлер определяет это так: диктат потребителя стремительно определяет конструктивный продукт.</p>\n<p>Традиционный канал сфокусирован. Личность топ менеджера, не меняя концепции, изложенной выше, многопланово упорядочивает показ баннера. Стратегическое планирование,&nbsp;как&nbsp;принято&nbsp;считать, притягивает продвигаемый продукт.</p>
581	
\.


--
-- Name: folder_page_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wc-sample.pos
--

SELECT pg_catalog.setval('folder_page_id_seq', 1, false);


--
-- Data for Name: links; Type: TABLE DATA; Schema: public; Owner: wc-sample.pos
--

COPY links (item_id, dataset_name, name, parent_id, index, alias, settings, site_id, enabled, dev) FROM stdin;
579	document_file	XLS File	574	4	\N	a:0:{}	2	1	\N
580	document_file	XLSX File	574	5	\N	a:0:{}	2	1	\N
574	folder_page	Документы	572	1	docs	a:0:{}	2	1	\N
572	folder_homepage	Главная страница	0	0	\N	a:0:{}	2	1	\N
591	document_news	С космодрома Куру произведен запуск ракеты "Ариан-5"	582	1	\N	a:0:{}	2	1	\N
592	document_news	Профсоюзы создали партию «Союз труда»	0	\N	\N	a:0:{}	2	1	\N
600	document_image	Капитан затонувшего Costa Concordia назвал себя спасителем лайнера	596	1	\N	a:0:{}	2	1	\N
583	document_news	Президент Франции призвал к более жестким санкциям против Сирии	582	1	\N	a:0:{}	2	1	\N
584	document_news	Губернатор Радаев укрепил позиции в рейтинге глав регионов	582	1	\N	a:0:{}	2	1	\N
585	document_news	Алексей Грибанов стал заместителем главы администрации Перми	582	1	\N	a:0:{}	2	1	\N
586	document_news	Профсоюзы создали партию «Союз труда»	582	1	\N	a:0:{}	2	1	\N
587	document_news	С космодрома Куру произведен запуск ракеты "Ариан-5"	582	1	\N	a:0:{}	2	1	\N
588	document_news	Петр Толстой 8 июля последний раз проведет эфир на Первом канале	582	1	\N	a:0:{}	2	1	\N
589	document_news	Короткое замыкание могло вызвать взрыв на подстанции Владивостока	582	1	\N	a:0:{}	2	1	\N
590	document_news	Рада отказалась голосовать за отставку Литвина	582	1	\N	a:0:{}	2	1	\N
593	document_news	Рада отказалась рассматривать заявление Литвина об отставке	582	1	\N	a:0:{}	2	1	\N
594	document_news	Алексей Грибанов стал заместителем главы администрации Перми	0	\N	\N	a:0:{}	2	1	\N
582	folder_news	Новости	581	0	news	a:0:{}	2	1	\N
575	document_file	DOC File	574	0	\N	a:0:{}	2	1	\N
576	document_file	PDF File	574	1	\N	a:0:{}	2	1	\N
577	document_file	RTF File	574	2	\N	a:0:{}	2	1	\N
578	document_file	TXT File	574	3	\N	a:0:{}	2	1	\N
595	folder_gallery	Галерея	581	1	gallery	a:0:{}	2	1	\N
601	document_image	Губернатор Радаев укрепил позиции в рейтинге глав регионов	596	1	\N	a:0:{}	2	1	\N
596	folder_album	Фото	595	0	photo	a:0:{}	2	1	\N
597	folder_album	Видео	595	1	video	a:0:{}	2	1	\N
598	document_image	Заявки в новый состав СПЧ будут принимать месяц	596	1	\N	a:0:{}	2	1	\N
599	document_image	Бывший тренер «Барселоны» сегодня прилетит на переговоры с РФС	596	1	\N	a:0:{}	2	1	\N
602	document_image	Жена Бута передала в Минюст документы, нужные для его выдачи на родину	596	1	\N	a:0:{}	2	1	\N
603	document_image	Алексей Грибанов стал заместителем главы администрации Перми	596	1	\N	a:0:{}	2	1	\N
604	document_image	Профсоюзы создали партию «Союз труда»	596	1	\N	a:0:{}	2	1	\N
605	document_image	Алексей Грибанов стал заместителем главы администрации Перми	596	1	\N	a:0:{}	2	1	\N
606	document_image	Профсоюзы создали партию «Союз труда»	596	1	\N	a:0:{}	2	1	\N
607	document_image	Ярошук одержал победу во втором туре праймериз «Единой России»	596	1	\N	a:0:{}	2	1	\N
581	folder_page	Пресс-центр	572	2	press	a:0:{}	2	1	\N
611	document_video	Видео 1	597	0	\N	a:0:{}	2	1	\N
610	document_video	Видео 2	597	1	\N	a:0:{}	2	1	\N
612	folder_link	Подписка на новости	572	3	\N	a:0:{}	2	1	\N
613	folder_link	Обратная связь	572	4	\N	a:0:{}	2	1	\N
573	folder_page	О комитете	572	0	about	a:0:{}	2	1	\N
614	folder_link	Поиск	572	5	\N	a:0:{}	2	1	\N
\.


--
-- Name: links_item_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wc-sample.pos
--

SELECT pg_catalog.setval('links_item_id_seq', 615, true);


--
-- Data for Name: metas; Type: TABLE DATA; Schema: public; Owner: wc-sample.pos
--

COPY metas (item_id, site_id, title, description, keywords) FROM stdin;
\.


--
-- Data for Name: roles; Type: TABLE DATA; Schema: public; Owner: wc-sample.pos
--

COPY roles (id, name, description) FROM stdin;
1	login	Login
2	admin_login	Admin Login
3	root	Root
4	admin	Администратор
5	moderator	Модератор
6	user	Пользователь
\.


--
-- Name: roles_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wc-sample.pos
--

SELECT pg_catalog.setval('roles_id_seq', 1, false);


--
-- Data for Name: roles_users; Type: TABLE DATA; Schema: public; Owner: wc-sample.pos
--

COPY roles_users (user_id, role_id) FROM stdin;
96	1
96	2
96	5
97	1
97	2
97	5
98	1
98	2
98	5
99	1
99	2
99	4
2	1
2	4
2	2
1	1
1	3
1	2
100	1
100	5
100	2
\.


--
-- Data for Name: search_index; Type: TABLE DATA; Schema: public; Owner: wc-sample.pos
--

COPY search_index (id, class, class_id, class_parent_id, factory_key, "group", datetime, image, title, description, text, url, site_id, _created, _updated, _proccess_id, title_tsv, description_tsv, text_tsv, data_tsv, enabled) FROM stdin;
110	Structure_Item	582	581	Model_Document:582:	581	\N	0	Новости			/press/item/582	2	2015-09-07 18:52:43	\N	144164116327	\N	\N	\N	'новость':1A	1
111	Structure_Item	572	0	Model_Folder:572:folder_homepage	0	\N	0	Главная страница			/folder/572	2	2015-09-07 18:52:43	\N	144164116327	\N	\N	\N	'главный':1A 'страница':2A	1
112	Structure_Item	574	572	Model_Folder:574:folder_page	0	\N	0	Документы			/docs	2	2015-09-07 18:52:43	\N	144164116327	\N	\N	\N	'документ':1A	1
113	Structure_Item	581	572	Model_Folder:581:folder_page	0	\N	0	Пресс-центр			/press	2	2015-09-07 18:52:43	\N	144164116327	\N	\N	\N	'пресс':2A 'пресс-центр':1A 'центр':3A	1
114	Structure_Item	573	572	Model_Folder:573:folder_page	0	\N	0	О комитете		Визуализация концепии, не меняя концепции, изложенной выше, интегрирована. Производство слабо создает анализ зарубежного опыта, опираясь на опыт западных коллег. Узнавание бренда, вопреки мнению П.Друкера, реально масштабирует рейтинг. Производство недостижимо. Имидж индуктивно транслирует бизнес-план. Медиапланирование недостижимо.\nПравда, специалисты отмечают, что создание приверженного покупателя традиционно экономит институциональный метод изучения рынка. Фокусировка, анализируя результаты рекламной кампании, индуцирует культурный медиамикс. Бренд искажает выставочный стенд.\nСтимулирование сбыта исключительно отталкивает департамент маркетинга и продаж. Личность топ менеджера все еще интересна для многих. Правда, специалисты отмечают, что создание приверженного покупателя последовательно детерминирует сублимированный креатив. Стратегический маркетинг по-прежнему устойчив к изменениям спроса. Как отмечает Майкл Мескон, потребительский рынок основан&nbsp;на&nbsp;тщательном анализе данных. Стратегическое планирование стабилизирует обществвенный стратегический рыночный план.\nАнализ зарубежного опыта довольно неоднозначен. Стратегия сегментации продуцирует из ряда вон выходящий фирменный стиль. Бренд, безусловно, подсознательно искажает медийный канал. Взаимодействие корпорации и клиента непосредственно позиционирует повседневный сегмент рынка. Один из признанных классиков маркетинга Ф.Котлер определяет это так: диктат потребителя стремительно определяет конструктивный продукт.\nТрадиционный канал сфокусирован. Личность топ менеджера, не меняя концепции, изложенной выше, многопланово упорядочивает показ баннера. Стратегическое планирование,&nbsp;как&nbsp;принято&nbsp;считать, притягивает продвигаемый продукт.	/about	2	2015-09-07 18:52:43	\N	144164116327	\N	\N	\N	'анализ':14C,111C,120C 'анализировать':55C 'баннер':179C 'безусловный':135C 'бизнес':37C 'бизнес-пла':36C 'бренд':23C,62C,134C 'взаимодействие':140C 'визуализация':3C 'вон':130C 'вопреки':24C 'выставочный':64C 'выходящий':131C 'выше':9C,175C 'данный':112C 'департамент':70C 'детерминировать':90C 'диктат':159C 'довольный':123C 'друкер':27C 'западный':20C 'зарубежный':15C,121C 'изложенный':8C,174C 'изменение':100C 'изучение':52C 'имидж':33C 'индуктивн':34C 'индуцировать':59C 'институциональный':50C 'интегрированный':10C 'интересный':79C 'искажать':63C,137C 'исключительный':68C 'кампания':58C 'канал':139C,166C 'классик':152C 'клиент':143C 'коллега':21C 'комитет':2A 'конструктивный':163C 'концеп':4C 'концепция':7C,173C 'корпорация':141C 'котлер':155C 'креат':92C 'культурный':60C 'личность':74C,168C 'майкл':104C 'маркетинг':71C,94C,153C 'масштабировать':29C 'медиамикс':61C 'медиапланирован':39C 'медийный':138C 'менеджер':76C,170C 'менять':6C,172C 'мескон':105C 'метод':51C 'мнение':25C 'многий':81C 'многоплановый':176C 'недостижимый':32C,40C 'неоднозначный':124C 'непосредственный':144C 'обществвен':116C 'опираться':17C 'определять':156C,162C 'опыт':16C,19C,122C 'основанный':108C 'отмечать':43C,84C,103C 'отталкивать':69C 'п':26C 'план':38C,119C 'планирование':114C,181C 'по-прежн':95C 'повседневный':146C 'подсознательный':136C 'позиционировать':145C 'показ':178C 'покупатель':47C,88C 'последовательный':89C 'потребитель':160C 'потребительский':106C 'правда':41C,82C 'прежний':97C 'приверженный':46C,87C 'признанный':151C 'принятый':183C 'притягивать':185C 'продажа':73C 'продвигаемый':186C 'продукт':164C,187C 'продуцирует':127C 'производство':11C,31C 'реальный':28C 'результат':56C 'рейтинг':30C 'рекламный':57C 'рынок':53C,107C,148C 'рыночный':118C 'ряд':129C 'сбыт':67C 'сегмент':147C 'сегментация':126C 'слабый':12C 'создавать':13C 'создание':45C,86C 'специалист':42C,83C 'спрос':101C 'стабилизировать':115C 'стенд':65C 'стиль':133C 'стимулирование':66C 'стратегический':93C,113C,117C,180C 'стратегия':125C 'стремительный':161C 'сублимированный':91C 'сфокусированный':167C 'считать':184C 'топ':75C,169C 'традиционный':48C,165C 'транслировать':35C 'тщательный':110C 'узнавание':22C 'упорядочивать':177C 'устойчивый':98C 'ф':154C 'фирменный':132C 'фокусировка':54C 'экономить':49C 'это':157C	1
115	Structure_Item	596	595	Model_Document:596:	581	\N	0	Фото			/press/gallery/item/596	2	2015-09-07 18:52:43	\N	144164116327	\N	\N	\N	'фото':1A	1
116	Structure_Item	597	595	Model_Document:597:	581	\N	0	Видео			/press/gallery/item/597	2	2015-09-07 18:52:43	\N	144164116327	\N	\N	\N	'видео':1A	1
117	Structure_Item	595	581	Model_Document:595:	581	\N	0	Галерея			/press/item/595	2	2015-09-07 18:52:43	\N	144164116327	\N	\N	\N	'галерея':1A	1
118	Structure_Item	612	572	Model_Document:612:	0	\N	0	Подписка на новости				2	2015-09-07 18:52:43	\N	144164116327	\N	\N	\N	'новость':3A 'подписка':1A	1
119	Structure_Item	613	572	Model_Document:613:	0	\N	0	Обратная связь				2	2015-09-07 18:52:43	\N	144164116327	\N	\N	\N	'обратный':1A 'связь':2A	1
120	Structure_Item	614	572	Model_Document:614:	0	\N	0	Поиск				2	2015-09-07 18:52:43	\N	144164116327	\N	\N	\N	'поиск':1A	1
121	Structure_Item	575	574	Model_Document_file:575:document_file	574	\N	0	DOC File			/docs/item/575	2	2015-09-07 18:52:43	\N	144164116327	\N	\N	\N	'doc':1A 'file':2A	1
122	Structure_Item	576	574	Model_Document_file:576:document_file	574	\N	0	PDF File			/docs/item/576	2	2015-09-07 18:52:43	\N	144164116327	\N	\N	\N	'file':2A 'pdf':1A	1
123	Structure_Item	577	574	Model_Document_file:577:document_file	574	\N	0	RTF File			/docs/item/577	2	2015-09-07 18:52:43	\N	144164116327	\N	\N	\N	'file':2A 'rtf':1A	1
124	Structure_Item	578	574	Model_Document_file:578:document_file	574	\N	0	TXT File			/docs/item/578	2	2015-09-07 18:52:43	\N	144164116327	\N	\N	\N	'file':2A 'txt':1A	1
125	Structure_Item	579	574	Model_Document_file:579:document_file	574	\N	0	XLS File			/docs/item/579	2	2015-09-07 18:52:43	\N	144164116327	\N	\N	\N	'file':2A 'xls':1A	1
126	Structure_Item	580	574	Model_Document_file:580:document_file	574	\N	0	XLSX File			/docs/item/580	2	2015-09-07 18:52:43	\N	144164116327	\N	\N	\N	'file':2A 'xlsx':1A	1
127	Structure_Item	583	582	Model_Document:583:document_news	581	2015-05-23 11:15:00	1378	Президент Франции призвал к более жестким санкциям против Сирии	Мир, следовательно, нетривиален. Освобождение рефлектирует дедуктивный метод, изменяя привычную реальность. Сомнение, как следует из вышесказанного, создает дуализм, ломая рамки привычных представлений.	Заблуждение, как следует из вышесказанного, рассматривается дедуктивный метод, открывая новые горизонты. Культ джайнизма включает в себя поклонение Махавире и другим тиртханкарам, поэтому созерцание контролирует трансцендентальный дедуктивный метод, при этом буквы А, В, I, О символизируют соответственно общеутвердительное, общеотрицательное, частноутвердительное и частноотрицательное суждения. Искусство, конечно, принимает во внимание знак, отрицая очевидное. Дилемма вырождена.  Мир, следовательно, нетривиален. Освобождение рефлектирует дедуктивный метод, изменяя привычную реальность. Сомнение, как следует из вышесказанного, создает дуализм, ломая рамки привычных представлений. Вещь в себе, конечно, преобразует конфликт, однако Зигварт считал критерием истинности необходимость и общезначимость, для которых нет никакой опоры в объективном мире. Гравитационный парадокс нетривиален.  Сомнение осмысляет сенсибельный гедонизм, не учитывая мнения авторитетов. Отношение к современности рассматривается трагический предмет деятельности, при этом буквы А, В, I, О символизируют соответственно общеутвердительное, общеотрицательное, частноутвердительное и частноотрицательное суждения. Моцзы, Сюнъцзы и другие считали, что отношение к современности индуцирует знак, изменяя привычную реальность. Структурализм, следовательно, нетривиален. Представляется логичным, что позитивизм рефлектирует сенсибельный мир, не учитывая мнения авторитетов.	/press/news/item/583	2	2015-09-07 18:52:43	\N	144164116327	\N	\N	\N	'i':63C,149C 'авторитет':136C,186C 'буква':60C,146C 'вещь':104C 'включать':44C 'внимание':77C 'вырожденный':82C 'вышесказанный':24B,35C,97C 'гедонизм':132C 'горизонт':41C 'гравитационный':126C 'дедуктивный':15B,37C,56C,88C 'деятельность':143C 'джайнизм':43C 'дилемма':81C 'дуализм':26B,99C 'жесткий':6A 'заблуждение':31C 'зигварт':111C 'знак':78C,169C 'изменять':17B,90C,170C 'индуцировать':168C 'искусство':73C 'истинность':114C 'конечный':74C,107C 'контролировать':54C 'конфликт':109C 'который':119C 'критерий':113C 'культ':42C 'логичный':177C 'ломать':27B,100C 'махавир':48C 'метод':16B,38C,57C,89C 'мир':10B,83C,125C,182C 'мира':125C 'миро':125C 'мнение':135C,185C 'моцз':159C 'необходимость':115C 'нетривиальный':12B,85C,128C,175C 'никакой':121C 'новый':40C 'общезначимость':117C 'общеотрицательн':68C,154C 'общеутвердительн':67C,153C 'объективный':124C 'однако':110C 'опора':122C 'освобождение':13B,86C 'осмыслять':130C 'открывать':39C 'отношение':137C,165C 'отрицать':79C 'очевидный':80C 'парадокс':127C 'позитивизм':179C 'поклонение':47C 'поэтому':52C 'предмет':142C 'представление':30B,103C 'представляться':176C 'президент':1A 'преобразовать':108C 'привычный':18B,29B,91C,102C,171C 'призвать':3A 'принимать':75C 'против':8A 'рамка':28B,101C 'рассматривается':36C,140C 'реальность':19B,92C,172C 'рефлектир':14B,87C,180C 'санкция':7A 'сенсибельный':131C,181C 'символизировать':65C,151C 'сирия':9A 'следовательно':11B,84C,174C 'следовать':22B,33C,95C 'современность':139C,167C 'создавать':25B,98C 'созерцание':53C 'сомнение':20B,93C,129C 'соответственный':66C,152C 'структурализм':173C 'суждение':72C,158C 'считать':112C,163C 'сюнъцз':160C 'тиртханкар':51C 'трагический':141C 'трансцендентальный':55C 'учитывать':134C,184C 'франций':2A 'франция':2A 'частноотрицательн':71C,157C 'частноутвердительн':69C,155C	1
128	Structure_Item	584	582	Model_Document:584:document_news	581	2013-09-21 08:05:00	1379	Губернатор Радаев укрепил позиции в рейтинге глав регионов	Представляется логичным, что освобождение представляет собой интеллигибельный дедуктивный метод, учитывая опасность, которую представляли собой писания Дюринга для не окрепшего еще немецкого рабочего движения.	Современная критика, по определению, изоморфна времени. Идеи гедонизма занимают центральное место в утилитаризме Милля и Бентама, однако ощущение мира выводит трагический даосизм, ломая рамки привычных представлений. Отвечая на вопрос о взаимоотношении идеального ли и материального ци, Дай Чжень заявлял, что диалектика естественно создает трагический гравитационный парадокс, отрицая очевидное. Моцзы, Сюнъцзы и другие считали, что бабувизм не так уж очевиден. Можно предположить, что ассоциация порождает и обеспечивает трансцендентальный здравый смысл, хотя в официозе принято обратное.  Отношение к современности творит бабувизм, учитывая опасность, которую представляли собой писания Дюринга для не окрепшего еще немецкого рабочего движения. Локаята порождена временем. Дилемма дискредитирует закон исключённого третьего, не учитывая мнения авторитетов. Заблуждение создает закон исключённого третьего, хотя в официозе принято обратное. Язык образов, как принято считать, естественно подчеркивает дуализм, хотя в официозе принято обратное.  Можно предположить, что заблуждение заполняет бабувизм, изменяя привычную реальность. Предмет деятельности, по определению, подрывает структурализм, учитывая опасность, которую представляли собой писания Дюринга для не окрепшего еще немецкого рабочего движения. Надо сказать, что гедонизм нетривиален. Отношение к современности, следовательно, амбивалентно оспособляет структурализм, не учитывая мнения авторитетов. Гений осмысленно рефлектирует структурализм, учитывая опасность, которую представляли собой писания Дюринга для не окрепшего еще немецкого рабочего движения.	/press/news/item/584	2	2015-09-07 18:52:43	\N	144164116327	\N	\N	\N	'авторитет':136C,204C 'амбивалентн':198C 'ассоциация':94C 'бабувизм':86C,110C,165C 'бентам':47C 'взаимоотношение':62C 'вопрос':60C 'временем':127C 'времени':37C 'выводить':51C 'гедонизм':39C,192C 'гений':205C 'глава':7A 'гравитационный':76C 'губернатор':1A 'даосизм':53C 'дать':68C 'движение':31B,124C,188C,222C 'дедуктивный':16B 'деятельность':170C 'диалектик':72C 'диалектика':72C 'дилемма':128C 'дискредитировать':129C 'дуализм':154C 'дюринг':24B,117C,181C,215C 'естественный':73C,152C 'заблуждение':137C,163C 'закон':130C,139C 'занимать':40C 'заполнять':164C 'заявлять':70C 'здравый':99C 'идеальный':63C 'идея':38C 'изменять':166C 'изоморфный':36C 'интеллигибельный':15B 'исключён':131C,140C 'который':20B,113C,177C,211C 'критик':33C 'критика':33C 'логичный':10B 'локаят':125C 'ломать':54C 'материальный':66C 'место':42C 'метод':17B 'милл':45C 'мир':50C 'мира':50C 'миро':50C 'мнение':135C,203C 'моцз':80C 'немецкий':29B,122C,186C,220C 'нетривиальный':193C 'обеспечивать':97C 'образ':148C 'обратный':105C,146C,159C 'однако':48C 'окрепший':27B,120C,184C,218C 'опасность':19B,112C,176C,210C 'определение':35C,172C 'освобождение':12B 'осмысленный':206C 'оспособля':199C 'отвечать':58C 'отношение':106C,194C 'отрицать':78C 'официоз':103C,144C,157C 'очевидный':79C,90C 'ощущение':49C 'парадокс':77C 'писание':23B,116C,180C,214C 'подрывать':173C 'подчеркивать':153C 'позиция':4A 'порождать':95C 'порожденный':126C 'предмет':169C 'предположить':92C,161C 'представление':57C 'представлять':13B,21B,114C,178C,212C 'представляться':9B 'привычный':56C,167C 'принятый':104C,145C,150C,158C 'рабочий':30B,123C,187C,221C 'рада':2A 'рамка':55C 'реальность':168C 'регион':8A 'рейтинг':6A 'рефлектир':207C 'сказать':190C 'следовательно':197C 'смысл':100C 'собой':14B,22B,115C,179C,213C 'современность':108C,196C 'современный':32C 'создавать':74C,138C 'структурализм':174C,200C,208C 'считать':84C,151C 'сюнъцз':81C 'творить':109C 'трагический':52C,75C 'трансцендентальный':98C 'третий':132C,141C 'укрепить':3A 'утилитаризм':44C 'учитывать':18B,111C,134C,175C,202C,209C 'хотя':101C,142C,155C 'центральный':41C 'ци':67C 'чжен':69C 'язык':147C	1
129	Structure_Item	585	582	Model_Document:585:document_news	581	2014-05-13 17:55:00	1380	Алексей Грибанов стал заместителем главы администрации Перми	Гедонизм рассматривается непредвиденный здравый смысл, учитывая опасность, которую представляли собой писания Дюринга для не окрепшего еще немецкого рабочего движения. Бхутавада изоморфна времени.	Гносеология дискредитирует сенсибельный гравитационный парадокс, однако Зигварт считал критерием истинности необходимость и общезначимость, для которых нет никакой опоры в объективном мире. Отвечая на вопрос о взаимоотношении идеального ли и материального ци, Дай Чжень заявлял, что гипотеза амбивалентно творит гедонизм, не учитывая мнения авторитетов. Заблуждение, следовательно, ментально порождает и обеспечивает сложный даосизм, tertium nоn datur. Гегельянство рефлектирует интеллект, не учитывая мнения авторитетов. Герменевтика реально осмысляет сложный язык образов, учитывая опасность, которую представляли собой писания Дюринга для не окрепшего еще немецкого рабочего движения.  Гравитационный парадокс творит закон исключённого третьего, учитывая опасность, которую представляли собой писания Дюринга для не окрепшего еще немецкого рабочего движения. Гедонизм методологически представляет собой позитивизм, отрицая очевидное. Дискретность раскладывает на элементы естественный интеллект, tertium nоn datur. Апостериори, искусство нетривиально. Закон исключённого третьего индуктивно порождает и обеспечивает гедонизм, не учитывая мнения авторитетов. Исчисление предикатов, следовательно, осмысленно порождает и обеспечивает интеллект, не учитывая мнения авторитетов.  Акциденция изоморфна времени. Суждение, конечно, осмысляет непредвиденный конфликт, изменяя привычную реальность. Веданта осмысленно контролирует язык образов, изменяя привычную реальность. Отвечая на вопрос о взаимоотношении идеального ли и материального ци, Дай Чжень заявлял, что принцип восприятия неоднозначен. Импликация трансформирует катарсис, tertium nоn datur. Искусство философски рефлектирует онтологический дуализм, открывая новые горизонты.	/press/news/item/585	2	2015-09-07 18:52:43	\N	144164116327	\N	\N	\N	'datur':83C,146C,215C 'nоn':82C,145C,214C 'tertium':81C,144C,213C 'авторитет':72C,90C,161C,173C 'администрация':6A 'акциденция':174C 'алексей':1A 'амбивалентн':66C 'апостериори':147C 'бхутавад':27B 'ведант':185C 'взаимоотношение':55C,197C 'вопрос':53C,195C 'восприятие':208C 'времени':29B,176C 'гегельянство':84C 'гедонизм':8B,68C,131C,157C 'герменевтика':91C 'гипотеза':65C 'глава':5A 'гносеология':30C 'горизонт':223C 'гравитационный':33C,111C 'грибан':2A 'даосизм':80C 'дать':61C,203C 'движение':26B,110C,130C 'дискредитировать':31C 'дискретность':138C 'дуализм':220C 'дюринг':19B,103C,123C 'естественный':142C 'заблуждение':73C 'закон':114C,150C 'заместитель':4A 'заявлять':63C,205C 'здравый':11B 'зигварт':36C 'идеальный':56C,198C 'изменять':182C,190C 'изоморфный':28B,175C 'импликация':210C 'индуктивн':153C 'интеллект':86C,143C,169C 'исключён':115C,151C 'искусство':148C,216C 'истинность':39C 'исчисление':162C 'катарсис':212C 'конечный':178C 'контролировать':187C 'конфликт':181C 'который':15B,44C,99C,119C 'критерий':38C 'материальный':59C,201C 'ментальн':75C 'методологический':132C 'мир':50C 'мира':50C 'миро':50C 'мнение':71C,89C,160C,172C 'немецкий':24B,108C,128C 'необходимость':40C 'неоднозначный':209C 'непредвиденный':10B,180C 'нетривиальный':149C 'никакой':46C 'новый':222C 'обеспечивать':78C,156C,168C 'образ':96C,189C 'общезначимость':42C 'объективный':49C 'однако':35C 'окрепший':22B,106C,126C 'онтологический':219C 'опасность':14B,98C,118C 'опора':47C 'осмысленный':165C,186C 'осмыслять':93C,179C 'отвечать':51C,193C 'открывать':221C 'отрицать':136C 'очевидный':137C 'парадокс':34C,112C 'пермь':7A 'писание':18B,102C,122C 'позитивизм':135C 'порождать':76C,154C,166C 'предикат':163C 'представлять':16B,100C,120C,133C 'привычный':183C,191C 'принцип':207C 'рабочий':25B,109C,129C 'раскладывать':139C 'рассматривается':9B 'реальность':184C,192C 'реальный':92C 'рефлектир':85C,218C 'сенсибельный':32C 'следовательно':74C,164C 'сложный':79C,94C 'смысл':12B 'собой':17B,101C,121C,134C 'стать':3A 'суждение':177C 'считать':37C 'творить':67C,113C 'трансформировать':211C 'третий':116C,152C 'учитывать':13B,70C,88C,97C,117C,159C,171C 'философский':217C 'ци':60C,202C 'чжен':62C,204C 'элемент':141C 'язык':95C,188C	1
130	Structure_Item	586	582	Model_Document:586:document_news	581	2015-12-04 13:35:00	1381	Профсоюзы создали партию «Союз труда»	Гедонизм рассматривается непредвиденный здравый смысл, учитывая опасность, которую представляли собой писания Дюринга для не окрепшего еще немецкого рабочего движения. Бхутавада изоморфна времени.	Представляется логичным, что освобождение представляет собой интеллигибельный дедуктивный метод, учитывая опасность, которую представляли собой писания Дюринга для не окрепшего еще немецкого рабочего движения. Ощущение мира преобразует здравый смысл, ломая рамки привычных представлений. Современная критика порождена временем. Можно предположить, что сомнение категорически трансформирует онтологический конфликт, открывая новые горизонты.\n\nЗакон внешнего мира может быть получен из опыта. Сомнение оспособляет дуализм, при этом буквы А, В, I, О символизируют соответственно общеутвердительное, общеотрицательное, частноутвердительное и частноотрицательное суждения. Платоновская академия порождена временем. Надо сказать, что закон внешнего мира принимает во внимание типичный гравитационный парадокс, tertium nоn datur. Гипотеза, как принято считать, представляет собой сложный катарсис, ломая рамки привычных представлений.\n\nЯзык образов подрывает сенсибельный структурализм, ломая рамки привычных представлений. Ощущение мира ментально заполняет интеллигибельный гедонизм, хотя в официозе принято обратное. Отсюда естественно следует, что гегельянство трогательно наивно. Идеи гедонизма занимают центральное место в утилитаризме Милля и Бентама, однако жизнь представляет собой принцип восприятия, tertium nоn datur. Галактика оспособляет сложный язык образов, tertium nоn datur. Катарсис философски заполняет трансцендентальный здравый смысл, ломая рамки привычных представлений.	/press/news/item/586	2	2015-09-07 18:52:43	\N	144164116327	\N	\N	\N	'datur':119C,177C,185C 'i':91C 'nоn':118C,176C,184C 'tertium':117C,175C,183C 'академия':102C 'бентам':168C 'буква':88C 'бхутавад':25B 'внешний':76C,109C 'внимание':113C 'восприятие':174C 'временем':63C,104C 'времени':27B 'галактика':178C 'гегельянство':156C 'гедонизм':6B,146C,160C 'гипотеза':120C 'горизонт':74C 'гравитационный':115C 'движение':24B,50C 'дедуктивный':35C 'дуализм':85C 'дюринг':17B,43C 'естественный':153C 'жизнь':170C 'закон':75C,108C 'занимать':161C 'заполнять':144C,188C 'здравый':9B,54C,190C 'идея':159C 'изоморфный':26B 'интеллигибельный':34C,145C 'катарсис':127C,186C 'категорический':68C 'конфликт':71C 'который':13B,39C 'критик':61C 'критика':61C 'логичный':29C 'ломать':56C,128C,137C,192C 'ментальн':143C 'место':163C 'метод':36C 'милл':166C 'мир':52C,77C,110C,142C 'мира':52C,77C,110C,142C 'миро':52C,77C,110C,142C 'мочь':78C 'наивный':158C 'немецкий':22B,48C 'непредвиденный':8B 'новый':73C 'образ':133C,182C 'обратный':151C 'общеотрицательн':96C 'общеутвердительн':95C 'однако':169C 'окрепший':20B,46C 'онтологический':70C 'опасность':12B,38C 'опыт':82C 'освобождение':31C 'оспособля':84C,179C 'открывать':72C 'отсюда':152C 'официоз':149C 'ощущение':51C,141C 'парадокс':116C 'партия':3A 'писание':16B,42C 'платоновский':101C 'подрывать':134C 'полученный':80C 'порожденный':62C,103C 'предположить':65C 'представление':59C,131C,140C,195C 'представлять':14B,32C,40C,124C,171C 'представляться':28C 'преобразовать':53C 'привычный':58C,130C,139C,194C 'принимать':111C 'принцип':173C 'принятый':122C,150C 'профсоюз':1A 'рабочий':23B,49C 'рамка':57C,129C,138C,193C 'рассматривается':7B 'сенсибельный':135C 'символизировать':93C 'сказать':106C 'следовать':154C 'сложный':126C,180C 'смысл':10B,55C,191C 'собой':15B,33C,41C,125C,172C 'современный':60C 'создать':2A 'сомнение':67C,83C 'соответственный':94C 'союз':4A 'структурализм':136C 'суждение':100C 'считать':123C 'типичный':114C 'трансформировать':69C 'трансцендентальный':189C 'трогательный':157C 'труд':5A 'утилитаризм':165C 'учитывать':11B,37C 'философский':187C 'хотя':147C 'центральный':162C 'частноотрицательн':99C 'частноутвердительн':97C 'язык':132C,181C	1
131	Structure_Item	588	582	Model_Document:588:document_news	581	2015-04-01 09:10:00	1383	Петр Толстой 8 июля последний раз проведет эфир на Первом канале	Отношение к современности творит бабувизм, учитывая опасность, которую представляли собой писания Дюринга для не окрепшего еще немецкого рабочего движения. Локаята порождена временем. Дилемма дискредитирует закон исключённого третьего, не учитывая мнения авторитетов.	Современная критика, по определению, изоморфна времени. Идеи гедонизма занимают центральное место в утилитаризме Милля и Бентама, однако ощущение мира выводит трагический даосизм, ломая рамки привычных представлений. Отвечая на вопрос о взаимоотношении идеального ли и материального ци, Дай Чжень заявлял, что диалектика естественно создает трагический гравитационный парадокс, отрицая очевидное. Моцзы, Сюнъцзы и другие считали, что бабувизм не так уж очевиден. Можно предположить, что ассоциация порождает и обеспечивает трансцендентальный здравый смысл, хотя в официозе принято обратное.  Отношение к современности творит бабувизм, учитывая опасность, которую представляли собой писания Дюринга для не окрепшего еще немецкого рабочего движения. Локаята порождена временем. Дилемма дискредитирует закон исключённого третьего, не учитывая мнения авторитетов. Заблуждение создает закон исключённого третьего, хотя в официозе принято обратное. Язык образов, как принято считать, естественно подчеркивает дуализм, хотя в официозе принято обратное.  Можно предположить, что заблуждение заполняет бабувизм, изменяя привычную реальность. Предмет деятельности, по определению, подрывает структурализм, учитывая опасность, которую представляли собой писания Дюринга для не окрепшего еще немецкого рабочего движения. Надо сказать, что гедонизм нетривиален. Отношение к современности, следовательно, амбивалентно оспособляет структурализм, не учитывая мнения авторитетов. Гений осмысленно рефлектирует структурализм, учитывая опасность, которую представляли собой писания Дюринга для не окрепшего еще немецкого рабочего движения.	/press/news/item/588	2	2015-09-07 18:52:43	\N	144164116327	\N	\N	\N	'авторитет':41B,146C,214C 'амбивалентн':208C 'ассоциация':104C 'бабувизм':15B,96C,120C,175C 'бентам':57C 'взаимоотношение':72C 'вопрос':70C 'временем':32B,137C 'времени':47C 'выводить':61C 'гедонизм':49C,202C 'гений':215C 'гравитационный':86C 'даосизм':63C 'дать':78C 'движение':29B,134C,198C,232C 'деятельность':180C 'диалектик':82C 'диалектика':82C 'дилемма':33B,138C 'дискредитировать':34B,139C 'дуализм':164C 'дюринг':22B,127C,191C,225C 'естественный':83C,162C 'заблуждение':147C,173C 'закон':35B,140C,149C 'занимать':50C 'заполнять':174C 'заявлять':80C 'здравый':109C 'идеальный':73C 'идея':48C 'изменять':176C 'изоморфный':46C 'исключён':36B,141C,150C 'июль':3A 'канал':10A 'который':18B,123C,187C,221C 'критик':43C 'критика':43C 'локаят':30B,135C 'ломать':64C 'материальный':76C 'место':52C 'милл':55C 'мир':60C 'мира':60C 'миро':60C 'мнение':40B,145C,213C 'моцз':90C 'немецкий':27B,132C,196C,230C 'нетривиальный':203C 'обеспечивать':107C 'образ':158C 'обратный':115C,156C,169C 'однако':58C 'окрепший':25B,130C,194C,228C 'опасность':17B,122C,186C,220C 'определение':45C,182C 'осмысленный':216C 'оспособля':209C 'отвечать':68C 'отношение':11B,116C,204C 'отрицать':88C 'официоз':113C,154C,167C 'очевидный':89C,100C 'ощущение':59C 'парадокс':87C 'первый':9A 'петр':1A 'писание':21B,126C,190C,224C 'подрывать':183C 'подчеркивать':163C 'порождать':105C 'порожденный':31B,136C 'последний':4A 'предмет':179C 'предположить':102C,171C 'представление':67C 'представлять':19B,124C,188C,222C 'привычный':66C,177C 'принятый':114C,155C,160C,168C 'провести':6A 'рабочий':28B,133C,197C,231C 'рамка':65C 'реальность':178C 'рефлектир':217C 'сказать':200C 'следовательно':207C 'смысл':110C 'собой':20B,125C,189C,223C 'современность':13B,118C,206C 'современный':42C 'создавать':84C,148C 'структурализм':184C,210C,218C 'считать':94C,161C 'сюнъцз':91C 'творить':14B,119C 'толстый':2A 'трагический':62C,85C 'трансцендентальный':108C 'третий':37B,142C,151C 'утилитаризм':54C 'учитывать':16B,39B,121C,144C,185C,212C,219C 'хотя':111C,152C,165C 'центральный':51C 'ци':77C 'чжен':79C 'эфир':7A 'язык':157C	1
132	Structure_Item	587	582	Model_Document:587:document_news	581	2013-09-27 15:10:00	1382	С космодрома Куру произведен запуск ракеты "Ариан-5"	Согласно предыдущему, смысл жизни нетривиален. Современная критика, следовательно, создает позитивизм, не учитывая мнения авторитетов. Катарсис естественно раскладывает на элементы интеллигибельный здравый смысл, tertium nоn datur.	Боль творит данный позитивизм, изменяя привычную реальность. Суждение оспособляет трансцендентальный бабувизм, учитывая опасность, которую представляли собой писания Дюринга для не окрепшего еще немецкого рабочего движения. Исчисление предикатов выводит сложный интеллект, ломая рамки привычных представлений. Созерцание подрывает онтологический интеллект, не учитывая мнения авторитетов.  Катарсис индуктивно раскладывает на элементы сенсибельный смысл жизни, однако Зигварт считал критерием истинности необходимость и общезначимость, для которых нет никакой опоры в объективном мире. Аксиома силлогизма реально подрывает естественный позитивизм, хотя в официозе принято обратное. Суждение контролирует данный предмет деятельности, однако Зигварт считал критерием истинности необходимость и общезначимость, для которых нет никакой опоры в объективном мире. Атомистика порождает и обеспечивает данный дедуктивный метод, однако Зигварт считал критерием истинности необходимость и общезначимость, для которых нет никакой опоры в объективном мире. Единственной космической субстанцией Гумбольдт считал материю, наделенную внутренней активностью, несмотря на это заблуждение рассматривается язык образов, открывая новые горизонты.  Надо сказать, что знак транспонирует бабувизм, не учитывая мнения авторитетов. Эклектика подчеркивает закон исключённого третьего, отрицая очевидное. Созерцание категорически трансформирует типичный закон внешнего мира, ломая рамки привычных представлений. Надо сказать, что гетерономная этика рассматривается конфликт, хотя в официозе принято обратное. Апостериори, локаята индуктивно заполняет принцип восприятия, отрицая очевидное. Гетерономная этика, как принято считать, откровенна.	/press/news/item/587	2	2015-09-07 18:52:43	\N	144164116327	\N	\N	\N	'datur':32B 'nоn':31B 'tertium':30B 'авторитет':21B,74C,182C 'аксиома':99C 'активность':162C 'апостериори':213C 'ариа':7A 'атомистика':131C 'бабувизм':43C,178C 'боль':33C 'внешний':195C 'внутренний':161C 'восприятие':218C 'выводить':60C 'гетерономн':204C,221C 'горизонт':172C 'гумбольдт':157C 'данный':35C,112C,135C 'движение':57C 'дедуктивный':136C 'деятельность':114C 'дюринг':50C 'единственный':154C 'естественный':23B,103C 'жизнь':11B,82C 'заблуждение':166C 'закон':185C,194C 'заполнять':216C 'запуск':5A 'здравый':28B 'зигварт':84C,116C,139C 'знак':176C 'изменять':37C 'индуктивн':76C,215C 'интеллект':62C,70C 'интеллигибельный':27B 'исключён':186C 'истинность':87C,119C,142C 'исчисление':58C 'катарсис':22B,75C 'категорический':191C 'контролировать':111C 'конфликт':207C 'космический':155C 'космодром':2A 'который':46C,92C,124C,147C 'критерий':86C,118C,141C 'критик':14B 'критика':14B 'кура':3A 'локаят':214C 'ломать':63C,197C 'материя':159C 'метод':137C 'мир':98C,130C,153C,196C 'мира':98C,130C,153C,196C 'миро':98C,130C,153C,196C 'мнение':20B,73C,181C 'наделенный':160C 'немецкий':55C 'необходимость':88C,120C,143C 'несмотря':163C 'нетривиальный':12B 'никакой':94C,126C,149C 'новый':171C 'обеспечивать':134C 'образ':169C 'обратный':109C,212C 'общезначимость':90C,122C,145C 'объективный':97C,129C,152C 'однако':83C,115C,138C 'окрепший':53C 'онтологический':69C 'опасность':45C 'опора':95C,127C,150C 'оспособля':41C 'откровенный':226C 'открывать':170C 'отрицать':188C,219C 'официоз':107C,210C 'очевидный':189C,220C 'писание':49C 'подрывать':68C,102C 'подчеркивать':184C 'позитивизм':17B,36C,104C 'порождать':132C 'предикат':59C 'предмет':113C 'представление':66C,200C 'представлять':47C 'предыдущий':9B 'привычный':38C,65C,199C 'принцип':217C 'принятый':108C,211C,224C 'произведенный':4A 'рабочий':56C 'ракета':6A 'рамка':64C,198C 'раскладывать':24B,77C 'рассматривается':167C,206C 'реальность':39C 'реальный':101C 'сенсибельный':80C 'силлогизм':100C 'сказать':174C,202C 'следовательно':15B 'сложный':61C 'смысл':10B,29B,81C 'собой':48C 'современный':13B 'согласный':8B 'создавать':16B 'созерцание':67C,190C 'субстанция':156C 'суждение':40C,110C 'считать':85C,117C,140C,158C,225C 'творить':34C 'типичный':193C 'транспонировать':177C 'трансформировать':192C 'трансцендентальный':42C 'третий':187C 'учитывать':19B,44C,72C,180C 'хотя':105C,208C 'эклектик':183C 'эклектика':183C 'элемент':26B,79C 'этика':205C,222C 'это':165C 'язык':168C	1
133	Structure_Item	589	582	Model_Document:589:document_news	581	2013-10-12 16:15:00	1384	Короткое замыкание могло вызвать взрыв на подстанции Владивостока	Гений выводит напряженный принцип восприятия, изменяя привычную реальность. Заблуждение контролирует закон внешнего мира, не учитывая мнения авторитетов. Знак преобразует трансцендентальный предмет деятельности.	Согласно предыдущему, смысл жизни нетривиален. Современная критика, следовательно, создает позитивизм, не учитывая мнения авторитетов. Катарсис естественно раскладывает на элементы интеллигибельный здравый смысл, tertium nоn datur. Реальная власть, следовательно, порождена временем. Освобождение категорически оспособляет конфликт, не учитывая мнения авторитетов.  Катарсис, следовательно, выводит непредвиденный гедонизм, хотя в официозе принято обратное. Отвечая на вопрос о взаимоотношении идеального ли и материального ци, Дай Чжень заявлял, что здравый смысл порождает и обеспечивает здравый смысл, открывая новые горизонты. Надо сказать, что предмет деятельности транспонирует сенсибельный здравый смысл, отрицая очевидное. Гений абстрактен.  Отвечая на вопрос о взаимоотношении идеального ли и материального ци, Дай Чжень заявлял, что апперцепция очевидна не для всех. Ощущение мира, как следует из вышесказанного, категорически оспособляет неоднозначный здравый смысл, при этом буквы А, В, I, О символизируют соответственно общеутвердительное, общеотрицательное, частноутвердительное и частноотрицательное суждения. Искусство заполняет интеллигибельный знак, изменяя привычную реальность. Герменевтика вырождена. Дуализм не так уж очевиден. Сомнение дискредитирует напряженный знак, изменяя привычную реальность.	/press/news/item/589	2	2015-09-07 18:52:43	\N	144164116327	\N	\N	\N	'datur':55C 'i':151C 'nоn':54C 'tertium':53C 'абстрактный':115C 'авторитет':25B,44C,68C 'апперцепция':130C 'буква':148C 'взаимоотношение':83C,120C 'взрыв':5A 'владивосток':8A 'власть':57C 'внешний':20B 'вопрос':81C,118C 'восприятие':13B 'временем':60C 'выводить':10B,71C 'вызвать':4A 'вырожденный':169C 'вышесказанный':140C 'гедонизм':73C 'гений':9B,114C 'герменевтика':168C 'горизонт':102C 'дать':89C,126C 'деятельность':30B,107C 'дискредитировать':176C 'дуализм':170C 'естественный':46C 'жизнь':34C 'заблуждение':17B 'закон':19B 'замыкание':2A 'заполнять':162C 'заявлять':91C,128C 'здравый':51C,93C,98C,110C,144C 'знак':26B,164C,178C 'идеальный':84C,121C 'изменять':14B,165C,179C 'интеллигибельный':50C,163C 'искусство':161C 'катарсис':45C,69C 'категорический':62C,141C 'контролировать':18B 'конфликт':64C 'короткий':1A 'критик':37C 'критика':37C 'материальный':87C,124C 'мир':21B,136C 'мира':21B,136C 'миро':21B,136C 'мнение':24B,43C,67C 'мог':3A 'напряженный':11B,177C 'неоднозначный':143C 'непредвиденный':72C 'нетривиальный':35C 'новый':101C 'обеспечивать':97C 'обратный':78C 'общеотрицательн':156C 'общеутвердительн':155C 'освобождение':61C 'оспособля':63C,142C 'отвечать':79C,116C 'открывать':100C 'отрицать':112C 'официоз':76C 'очевидный':113C,131C,174C 'ощущение':135C 'подстанция':7A 'позитивизм':40C 'порождать':95C 'порожденный':59C 'предмет':29B,106C 'предыдущий':32C 'преобразовать':27B 'привычный':15B,166C,180C 'принцип':12B 'принятый':77C 'раскладывать':47C 'реальность':16B,167C,181C 'реальный':56C 'сенсибельный':109C 'символизировать':153C 'сказать':104C 'следовательно':38C,58C,70C 'следовать':138C 'смысл':33C,52C,94C,99C,111C,145C 'современный':36C 'согласный':31C 'создавать':39C 'сомнение':175C 'соответственный':154C 'суждение':160C 'транспонировать':108C 'трансцендентальный':28B 'учитывать':23B,42C,66C 'хотя':74C 'ци':88C,125C 'частноотрицательн':159C 'частноутвердительн':157C 'чжен':90C,127C 'элемент':49C	1
134	Structure_Item	590	582	Model_Document:590:document_news	581	2015-07-20 19:15:00	1385	Рада отказалась голосовать за отставку Литвина	Гносеология дискредитирует сенсибельный гравитационный парадокс, однако Зигварт считал критерием истинности необходимость и общезначимость, для которых нет никакой опоры в объективном мире. Отвечая на вопрос о взаимоотношении идеального ли и материального ци.\n	Заблуждение, как следует из вышесказанного, рассматривается дедуктивный метод, открывая новые горизонты. Культ джайнизма включает в себя поклонение Махавире и другим тиртханкарам, поэтому созерцание контролирует трансцендентальный дедуктивный метод, при этом буквы А, В, I, О символизируют соответственно общеутвердительное, общеотрицательное, частноутвердительное и частноотрицательное суждения. Искусство, конечно, принимает во внимание знак, отрицая очевидное. Дилемма вырождена.\n\nМир, следовательно, нетривиален. Освобождение рефлектирует дедуктивный метод, изменяя привычную реальность. Сомнение, как следует из вышесказанного, создает дуализм, ломая рамки привычных представлений. Вещь в себе, конечно, преобразует конфликт, однако Зигварт считал критерием истинности необходимость и общезначимость, для которых нет никакой опоры в объективном мире. Гравитационный парадокс нетривиален.\n\nСомнение осмысляет сенсибельный гедонизм, не учитывая мнения авторитетов. Отношение к современности рассматривается трагический предмет деятельности, при этом буквы А, В, I, О символизируют соответственно общеутвердительное, общеотрицательное, частноутвердительное и частноотрицательное суждения. Моцзы, Сюнъцзы и другие считали, что отношение к современности индуцирует знак, изменяя привычную реальность. Структурализм, следовательно, нетривиален. Представляется логичным, что позитивизм рефлектирует сенсибельный мир, не учитывая мнения авторитетов.	/press/news/item/590	2	2015-09-07 18:52:43	\N	144164116327	\N	\N	\N	'i':70C,156C 'авторитет':143C,193C 'буква':67C,153C 'вещь':111C 'взаимоотношение':32B 'включать':51C 'внимание':84C 'вопрос':30B 'вырожденный':89C 'вышесказанный':42C,104C 'гедонизм':139C 'гносеология':7B 'голосовать':3A 'горизонт':48C 'гравитационный':10B,133C 'дедуктивный':44C,63C,95C 'деятельность':150C 'джайнизм':50C 'дилемма':88C 'дискредитировать':8B 'дуализм':106C 'заблуждение':38C 'зигварт':13B,118C 'знак':85C,176C 'идеальный':33B 'изменять':97C,177C 'индуцировать':175C 'искусство':80C 'истинность':16B,121C 'конечный':81C,114C 'контролировать':61C 'конфликт':116C 'который':21B,126C 'критерий':15B,120C 'культ':49C 'литвин':6A 'логичный':184C 'ломать':107C 'материальный':36B 'махавир':55C 'метод':45C,64C,96C 'мир':27B,90C,132C,189C 'мира':27B,132C 'миро':27B,132C 'мнение':142C,192C 'моцз':166C 'необходимость':17B,122C 'нетривиальный':92C,135C,182C 'никакой':23B,128C 'новый':47C 'общезначимость':19B,124C 'общеотрицательн':75C,161C 'общеутвердительн':74C,160C 'объективный':26B,131C 'однако':12B,117C 'опора':24B,129C 'освобождение':93C 'осмыслять':137C 'отвечать':28B 'отказаться':2A 'открывать':46C 'отношение':144C,172C 'отрицать':86C 'отставка':5A 'очевидный':87C 'парадокс':11B,134C 'позитивизм':186C 'поклонение':54C 'поэтому':59C 'предмет':149C 'представление':110C 'представляться':183C 'преобразовать':115C 'привычный':98C,109C,178C 'принимать':82C 'рада':1A 'рамка':108C 'рассматривается':43C,147C 'реальность':99C,179C 'рефлектир':94C,187C 'сенсибельный':9B,138C,188C 'символизировать':72C,158C 'следовательно':91C,181C 'следовать':40C,102C 'современность':146C,174C 'создавать':105C 'созерцание':60C 'сомнение':100C,136C 'соответственный':73C,159C 'структурализм':180C 'суждение':79C,165C 'считать':14B,119C,170C 'сюнъцз':167C 'тиртханкар':58C 'трагический':148C 'трансцендентальный':62C 'учитывать':141C,191C 'ци':37B 'частноотрицательн':78C,164C 'частноутвердительн':76C,162C	1
135	Structure_Item	591	582	Model_Document:591:document_news	581	2014-01-06 10:25:00	1386	С космодрома Куру произведен запуск ракеты "Ариан-5"	Согласно предыдущему, смысл жизни нетривиален. Современная критика, следовательно, создает позитивизм, не учитывая мнения авторитетов. Катарсис естественно раскладывает на элементы интеллигибельный здравый смысл, tertium nоn datur.	Боль творит данный позитивизм, изменяя привычную реальность. Суждение оспособляет трансцендентальный бабувизм, учитывая опасность, которую представляли собой писания Дюринга для не окрепшего еще немецкого рабочего движения. Исчисление предикатов выводит сложный интеллект, ломая рамки привычных представлений. Созерцание подрывает онтологический интеллект, не учитывая мнения авторитетов.  Катарсис индуктивно раскладывает на элементы сенсибельный смысл жизни, однако Зигварт считал критерием истинности необходимость и общезначимость, для которых нет никакой опоры в объективном мире. Аксиома силлогизма реально подрывает естественный позитивизм, хотя в официозе принято обратное. Суждение контролирует данный предмет деятельности, однако Зигварт считал критерием истинности необходимость и общезначимость, для которых нет никакой опоры в объективном мире. Атомистика порождает и обеспечивает данный дедуктивный метод, однако Зигварт считал критерием истинности необходимость и общезначимость, для которых нет никакой опоры в объективном мире. Единственной космической субстанцией Гумбольдт считал материю, наделенную внутренней активностью, несмотря на это заблуждение рассматривается язык образов, открывая новые горизонты.  Надо сказать, что знак транспонирует бабувизм, не учитывая мнения авторитетов. Эклектика подчеркивает закон исключённого третьего, отрицая очевидное. Созерцание категорически трансформирует типичный закон внешнего мира, ломая рамки привычных представлений. Надо сказать, что гетерономная этика рассматривается конфликт, хотя в официозе принято обратное. Апостериори, локаята индуктивно заполняет принцип восприятия, отрицая очевидное. Гетерономная этика, как принято считать, откровенна.	/press/news/item/591	2	2015-09-07 18:52:43	\N	144164116327	\N	\N	\N	'datur':32B 'nоn':31B 'tertium':30B 'авторитет':21B,74C,182C 'аксиома':99C 'активность':162C 'апостериори':213C 'ариа':7A 'атомистика':131C 'бабувизм':43C,178C 'боль':33C 'внешний':195C 'внутренний':161C 'восприятие':218C 'выводить':60C 'гетерономн':204C,221C 'горизонт':172C 'гумбольдт':157C 'данный':35C,112C,135C 'движение':57C 'дедуктивный':136C 'деятельность':114C 'дюринг':50C 'единственный':154C 'естественный':23B,103C 'жизнь':11B,82C 'заблуждение':166C 'закон':185C,194C 'заполнять':216C 'запуск':5A 'здравый':28B 'зигварт':84C,116C,139C 'знак':176C 'изменять':37C 'индуктивн':76C,215C 'интеллект':62C,70C 'интеллигибельный':27B 'исключён':186C 'истинность':87C,119C,142C 'исчисление':58C 'катарсис':22B,75C 'категорический':191C 'контролировать':111C 'конфликт':207C 'космический':155C 'космодром':2A 'который':46C,92C,124C,147C 'критерий':86C,118C,141C 'критик':14B 'критика':14B 'кура':3A 'локаят':214C 'ломать':63C,197C 'материя':159C 'метод':137C 'мир':98C,130C,153C,196C 'мира':98C,130C,153C,196C 'миро':98C,130C,153C,196C 'мнение':20B,73C,181C 'наделенный':160C 'немецкий':55C 'необходимость':88C,120C,143C 'несмотря':163C 'нетривиальный':12B 'никакой':94C,126C,149C 'новый':171C 'обеспечивать':134C 'образ':169C 'обратный':109C,212C 'общезначимость':90C,122C,145C 'объективный':97C,129C,152C 'однако':83C,115C,138C 'окрепший':53C 'онтологический':69C 'опасность':45C 'опора':95C,127C,150C 'оспособля':41C 'откровенный':226C 'открывать':170C 'отрицать':188C,219C 'официоз':107C,210C 'очевидный':189C,220C 'писание':49C 'подрывать':68C,102C 'подчеркивать':184C 'позитивизм':17B,36C,104C 'порождать':132C 'предикат':59C 'предмет':113C 'представление':66C,200C 'представлять':47C 'предыдущий':9B 'привычный':38C,65C,199C 'принцип':217C 'принятый':108C,211C,224C 'произведенный':4A 'рабочий':56C 'ракета':6A 'рамка':64C,198C 'раскладывать':24B,77C 'рассматривается':167C,206C 'реальность':39C 'реальный':101C 'сенсибельный':80C 'силлогизм':100C 'сказать':174C,202C 'следовательно':15B 'сложный':61C 'смысл':10B,29B,81C 'собой':48C 'современный':13B 'согласный':8B 'создавать':16B 'созерцание':67C,190C 'субстанция':156C 'суждение':40C,110C 'считать':85C,117C,140C,158C,225C 'творить':34C 'типичный':193C 'транспонировать':177C 'трансформировать':192C 'трансцендентальный':42C 'третий':187C 'учитывать':19B,44C,72C,180C 'хотя':105C,208C 'эклектик':183C 'эклектика':183C 'элемент':26B,79C 'этика':205C,222C 'это':165C 'язык':168C	1
136	Structure_Item	593	582	Model_Document:593:document_news	581	2014-11-02 09:45:00	1388	Рада отказалась рассматривать заявление Литвина об отставке	Гений выводит напряженный принцип восприятия, изменяя привычную реальность. Заблуждение контролирует закон внешнего мира, не учитывая мнения авторитетов. Знак преобразует трансцендентальный предмет деятельности.	Представляется логичным, что освобождение представляет собой интеллигибельный дедуктивный метод, учитывая опасность, которую представляли собой писания Дюринга для не окрепшего еще немецкого рабочего движения. Ощущение мира преобразует здравый смысл, ломая рамки привычных представлений. Современная критика порождена временем. Можно предположить, что сомнение категорически трансформирует онтологический конфликт, открывая новые горизонты.  Закон внешнего мира может быть получен из опыта. Сомнение оспособляет дуализм, при этом буквы А, В, I, О символизируют соответственно общеутвердительное, общеотрицательное, частноутвердительное и частноотрицательное суждения. Платоновская академия порождена временем. Надо сказать, что закон внешнего мира принимает во внимание типичный гравитационный парадокс, tertium nоn datur. Гипотеза, как принято считать, представляет собой сложный катарсис, ломая рамки привычных представлений.  Язык образов подрывает сенсибельный структурализм, ломая рамки привычных представлений. Ощущение мира ментально заполняет интеллигибельный гедонизм, хотя в официозе принято обратное. Отсюда естественно следует, что гегельянство трогательно наивно. Идеи гедонизма занимают центральное место в утилитаризме Милля и Бентама, однако жизнь представляет собой принцип восприятия, tertium nоn datur. Галактика оспособляет сложный язык образов, tertium nоn datur. Катарсис философски заполняет трансцендентальный здравый смысл, ломая рамки привычных представлений.	/press/news/item/593	2	2015-09-07 18:52:43	\N	144164116327	\N	\N	\N	'datur':121C,179C,187C 'i':93C 'nоn':120C,178C,186C 'tertium':119C,177C,185C 'авторитет':24B 'академия':104C 'бентам':170C 'буква':90C 'внешний':19B,78C,111C 'внимание':115C 'восприятие':12B,176C 'временем':65C,106C 'выводить':9B 'галактика':180C 'гегельянство':158C 'гедонизм':148C,162C 'гений':8B 'гипотеза':122C 'горизонт':76C 'гравитационный':117C 'движение':52C 'дедуктивный':37C 'деятельность':29B 'дуализм':87C 'дюринг':45C 'естественный':155C 'жизнь':172C 'заблуждение':16B 'закон':18B,77C,110C 'занимать':163C 'заполнять':146C,190C 'заявление':4A 'здравый':56C,192C 'знак':25B 'идея':161C 'изменять':13B 'интеллигибельный':36C,147C 'катарсис':129C,188C 'категорический':70C 'контролировать':17B 'конфликт':73C 'который':41C 'критик':63C 'критика':63C 'литвин':5A 'логичный':31C 'ломать':58C,130C,139C,194C 'ментальн':145C 'место':165C 'метод':38C 'милл':168C 'мир':20B,54C,79C,112C,144C 'мира':20B,54C,79C,112C,144C 'миро':20B,54C,79C,112C,144C 'мнение':23B 'мочь':80C 'наивный':160C 'напряженный':10B 'немецкий':50C 'новый':75C 'образ':135C,184C 'обратный':153C 'общеотрицательн':98C 'общеутвердительн':97C 'однако':171C 'окрепший':48C 'онтологический':72C 'опасность':40C 'опыт':84C 'освобождение':33C 'оспособля':86C,181C 'отказаться':2A 'открывать':74C 'отставка':7A 'отсюда':154C 'официоз':151C 'ощущение':53C,143C 'парадокс':118C 'писание':44C 'платоновский':103C 'подрывать':136C 'полученный':82C 'порожденный':64C,105C 'предмет':28B 'предположить':67C 'представление':61C,133C,142C,197C 'представлять':34C,42C,126C,173C 'представляться':30C 'преобразовать':26B,55C 'привычный':14B,60C,132C,141C,196C 'принимать':113C 'принцип':11B,175C 'принятый':124C,152C 'рабочий':51C 'рада':1A 'рамка':59C,131C,140C,195C 'рассматривать':3A 'реальность':15B 'сенсибельный':137C 'символизировать':95C 'сказать':108C 'следовать':156C 'сложный':128C,182C 'смысл':57C,193C 'собой':35C,43C,127C,174C 'современный':62C 'сомнение':69C,85C 'соответственный':96C 'структурализм':138C 'суждение':102C 'считать':125C 'типичный':116C 'трансформировать':71C 'трансцендентальный':27B,191C 'трогательный':159C 'утилитаризм':167C 'учитывать':22B,39C 'философский':189C 'хотя':149C 'центральный':164C 'частноотрицательн':101C 'частноутвердительн':99C 'язык':134C,183C	1
137	Structure_Item	611	597	Model_Document_video:611:document_video	581	2015-08-26 00:00:00	1430	Видео 1	Как отмечает Майкл Мескон, анализ зарубежного опыта парадоксально обуславливает экспериментальный маркетинг. Направленный маркетинг, анализируя результаты рекламной кампании, обычно правомочен. Потребление,&nbsp;следовательно, переворачивает комплексный показ баннера. Реклама экономит формат события, невзирая на действия конкурентов.		/document/611	2	2015-09-07 18:52:43	\N	144164116327	\N	\N	\N	'анализ':6B 'анализировать':15B 'баннер':26B 'видео':1A 'действие':33B 'зарубежный':7B 'кампания':18B 'комплексный':24B 'конкурент':34B 'майкл':4B 'маркетинг':12B,14B 'мескон':5B 'направленный':13B 'невзирая':31B 'обуславливать':10B 'обычный':19B 'опыт':8B 'отмечать':3B 'парадоксальный':9B 'переворачивать':23B 'показ':25B 'потребление':21B 'правомочный':20B 'результат':16B 'реклама':27B 'рекламный':17B 'следовательно':22B 'событие':30B 'формат':29B 'экономить':28B 'экспериментальный':11B	1
138	Structure_Item	610	597	Model_Document_video:610:document_video	581	2015-08-27 00:00:00	1429	Видео 2	Как отмечает Майкл Мескон, анализ зарубежного опыта парадоксально обуславливает экспериментальный маркетинг. Направленный маркетинг, анализируя результаты рекламной кампании, обычно правомочен. Потребление,&nbsp;следовательно, переворачивает комплексный показ баннера. Реклама экономит формат события, невзирая на действия конкурентов.		/document/610	2	2015-09-07 18:52:43	\N	144164116327	\N	\N	\N	'анализ':6B 'анализировать':15B 'баннер':26B 'видео':1A 'действие':33B 'зарубежный':7B 'кампания':18B 'комплексный':24B 'конкурент':34B 'майкл':4B 'маркетинг':12B,14B 'мескон':5B 'направленный':13B 'невзирая':31B 'обуславливать':10B 'обычный':19B 'опыт':8B 'отмечать':3B 'парадоксальный':9B 'переворачивать':23B 'показ':25B 'потребление':21B 'правомочный':20B 'результат':16B 'реклама':27B 'рекламный':17B 'следовательно':22B 'событие':30B 'формат':29B 'экономить':28B 'экспериментальный':11B	1
\.


--
-- Name: search_index_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wc-sample.pos
--

SELECT pg_catalog.setval('search_index_id_seq', 139, true);


--
-- Data for Name: setting_categories; Type: TABLE DATA; Schema: public; Owner: wc-sample.pos
--

COPY setting_categories (id, name, _created, _updated) FROM stdin;
1	Настройки сайта	2013-08-12 11:57:18	2013-08-12 11:57:39
2	Настройки уведомлений	2013-08-12 11:57:47	\N
\.


--
-- Name: setting_categories_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wc-sample.pos
--

SELECT pg_catalog.setval('setting_categories_id_seq', 3, false);


--
-- Data for Name: setting_values; Type: TABLE DATA; Schema: public; Owner: wc-sample.pos
--

COPY setting_values (id, name, data, site_id, _created, _updated) FROM stdin;
1	title	Сайтсофт	1	2012-10-05 19:03:31	2013-08-12 11:57:26
2	email_from	wc3@sitesoft.ru	1	2012-10-05 19:03:57	2013-08-12 11:57:57
3	sync_inbox_enabled	0	1	2013-08-27 13:53:55	2013-08-27 13:56:56
4	sync_token	l8WFVK2y	1	2013-08-27 13:53:55	2013-08-27 13:56:56
10	title	Комитет РФ	0	2015-08-26 15:11:22	\N
11	email_from	noreply@sitesoft.ru	0	2015-08-26 15:11:35	\N
12	feedback_email	anton.dukhanin@gmail.com	-1	2015-08-26 15:38:33	\N
13	feedback_sent_text	<p><span style="line-height: 1.7em;">Наши специалисты свяжутся с Вами в течение двух рабочих дней</span></p>\n<p><a href="/">На главную</a></p>	-1	2015-08-26 15:38:33	\N
\.


--
-- Name: setting_values_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wc-sample.pos
--

SELECT pg_catalog.setval('setting_values_id_seq', 13, true);


--
-- Data for Name: settings; Type: TABLE DATA; Schema: public; Owner: wc-sample.pos
--

COPY settings (id, name, title, type, site_id, _created, _updated) FROM stdin;
1	title	Название сайта	text	-2	2012-10-05 19:03:31	\N
2	email_from	Обратный адрес в E-mail	text_email	-2	2012-10-05 19:03:57	\N
3	sync_token		text	-2	2013-08-27 13:52:49	\N
4	sync_inbox_enabled		checkbox	-2	2013-08-27 13:52:49	\N
10	feedback_email	E-mail для отправки сообщений	text	-1	2015-08-26 15:38:24	\N
11	feedback_sent_text	Сообщение после отправки сообщения	text	-1	2015-08-26 15:38:25	\N
12	seo_robotstxt_disallow	\N	textarea	-2	2015-08-28 12:23:25	\N
\.


--
-- Data for Name: settings_categories; Type: TABLE DATA; Schema: public; Owner: wc-sample.pos
--

COPY settings_categories (setting_id, category_id) FROM stdin;
1	1
2	2
\.


--
-- Name: settings_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wc-sample.pos
--

SELECT pg_catalog.setval('settings_id_seq', 12, true);


--
-- Data for Name: site_hosts; Type: TABLE DATA; Schema: public; Owner: wc-sample.pos
--

COPY site_hosts (id, host, index, main, site_id) FROM stdin;
\.


--
-- Name: site_hosts_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wc-sample.pos
--

SELECT pg_catalog.setval('site_hosts_id_seq', 1, false);


--
-- Data for Name: sites; Type: TABLE DATA; Schema: public; Owner: wc-sample.pos
--

COPY sites (id, title, index, main, _created, _updated) FROM stdin;
2	Сайт Комитета РФ	\N	1	2015-08-26 15:12:48	2015-08-26 15:12:48
\.


--
-- Name: sites_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wc-sample.pos
--

SELECT pg_catalog.setval('sites_id_seq', 2, true);


--
-- Data for Name: statuses; Type: TABLE DATA; Schema: public; Owner: wc-sample.pos
--

COPY statuses (id, datetime, user_id, item_id) FROM stdin;
124	2015-09-14 11:44:55	1	610
121	2015-09-29 14:01:02	1	612
130	2016-01-22 16:00:44	2	614
129	2016-01-22 16:00:51	2	613
128	2016-01-22 16:00:52	2	612
131	2016-01-22 16:04:17	2	573
125	2016-01-22 16:18:04	1	572
120	2016-02-10 14:28:36	1	573
123	2016-02-10 16:24:23	1	595
126	2016-02-18 10:05:14	1	586
132	2016-02-18 10:30:11	1	582
122	2016-02-18 10:30:14	1	581
127	2016-02-18 14:37:00	1	590
\.


--
-- Name: statuses_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wc-sample.pos
--

SELECT pg_catalog.setval('statuses_id_seq', 132, true);


--
-- Data for Name: subscribe_channels; Type: TABLE DATA; Schema: public; Owner: wc-sample.pos
--

COPY subscribe_channels (id, name, description, handler, last_time, enabled, site_id, index) FROM stdin;
1	Все новости	\N	Subscribe_Channel_Handler_News	\N	1	2	0
2	Главные новости	\N	Subscribe_Channel_Handler_Newsmain	\N	1	2	1
\.


--
-- Name: subscribe_channels_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wc-sample.pos
--

SELECT pg_catalog.setval('subscribe_channels_id_seq', 2, true);


--
-- Data for Name: subscribe_settings; Type: TABLE DATA; Schema: public; Owner: wc-sample.pos
--

COPY subscribe_settings (id, site_id, data) FROM stdin;
\.


--
-- Name: subscribe_settings_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wc-sample.pos
--

SELECT pg_catalog.setval('subscribe_settings_id_seq', 1, false);


--
-- Data for Name: subscribe_users; Type: TABLE DATA; Schema: public; Owner: wc-sample.pos
--

COPY subscribe_users (id, name, email, enabled, registred, site_id, confirmed, token) FROM stdin;
\.


--
-- Data for Name: subscribe_users_channels; Type: TABLE DATA; Schema: public; Owner: wc-sample.pos
--

COPY subscribe_users_channels (user_id, channel_id) FROM stdin;
\.


--
-- Name: subscribe_users_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wc-sample.pos
--

SELECT pg_catalog.setval('subscribe_users_id_seq', 1, false);


--
-- Data for Name: tags; Type: TABLE DATA; Schema: public; Owner: wc-sample.pos
--

COPY tags (id, name, count, site_id) FROM stdin;
43	Тег1	1	2
44	Тег2	1	2
\.


--
-- Name: tags_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wc-sample.pos
--

SELECT pg_catalog.setval('tags_id_seq', 44, true);


--
-- Data for Name: tags_links; Type: TABLE DATA; Schema: public; Owner: wc-sample.pos
--

COPY tags_links (id, tag_id, item_id, item_type, factory_key) FROM stdin;
113	43	586	document_news	Model_Document:586:document_news
114	44	586	document_news	Model_Document:586:document_news
\.


--
-- Name: tags_links_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wc-sample.pos
--

SELECT pg_catalog.setval('tags_links_id_seq', 114, true);


--
-- Data for Name: user_group_structure_item_roles; Type: TABLE DATA; Schema: public; Owner: wc-sample.pos
--

COPY user_group_structure_item_roles (id, item_id, group_id, key, value) FROM stdin;
21	2	1	append_document	1
18	2	1	edit	1
19	2	1	move	0
20	2	1	append_folder	1
6	3	2	append_folder	1
7	3	2	append_document	1
8	27	2	edit	1
9	27	2	move	1
10	27	2	append_folder	1
11	27	2	append_document	1
12	27	2	delete	1
13	28	2	edit	1
14	28	2	move	1
15	28	2	append_folder	1
16	28	2	append_document	1
17	28	2	delete	1
22	2	1	delete	0
23	96	1	edit	1
24	96	2	edit	1
25	124	2	edit	1
26	124	2	move	1
27	124	2	append_folder	1
28	124	2	append_document	1
29	124	2	delete	1
38	112	5	append_document	1
35	112	5	edit	1
36	112	5	move	1
37	112	5	append_folder	1
39	112	5	delete	1
40	582	1	append_document	1
\.


--
-- Name: user_group_structure_item_roles_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wc-sample.pos
--

SELECT pg_catalog.setval('user_group_structure_item_roles_id_seq', 40, true);


--
-- Data for Name: user_groups; Type: TABLE DATA; Schema: public; Owner: wc-sample.pos
--

COPY user_groups (id, name, site_id) FROM stdin;
1	Редакторы	-1
2	Фоторепортеры	-1
5	Пресс-служба	1
\.


--
-- Name: user_groups_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wc-sample.pos
--

SELECT pg_catalog.setval('user_groups_id_seq', 6, false);


--
-- Data for Name: user_tokens; Type: TABLE DATA; Schema: public; Owner: wc-sample.pos
--

COPY user_tokens (id, user_id, user_agent, token, created, expires) FROM stdin;
\.


--
-- Name: user_tokens_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wc-sample.pos
--

SELECT pg_catalog.setval('user_tokens_id_seq', 21, true);


--
-- Data for Name: users; Type: TABLE DATA; Schema: public; Owner: wc-sample.pos
--

COPY users (id, username, name, post, password, email, "join", last_login, logins, active_from, active_to, disabled, site_id) FROM stdin;
2	admin	Администратор сайта		cacae73eca0e86b3a39ccf47c929f27e	admin@sitesoft.ru	0	1455086982	1	\N	\N	0	-1
100	moderator	Модератор		cacae73eca0e86b3a39ccf47c929f27e	moderator@sitesoft.ru	0	1440592850	1	\N	\N	0	2
1	root	Разработчик		cacae73eca0e86b3a39ccf47c929f27e	root@sitesoft.ru	0	1455778443	1	\N	\N	0	-1
\.


--
-- Data for Name: users_groups; Type: TABLE DATA; Schema: public; Owner: wc-sample.pos
--

COPY users_groups (user_id, group_id) FROM stdin;
96	2
97	1
98	5
100	1
\.


--
-- Name: users_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wc-sample.pos
--

SELECT pg_catalog.setval('users_id_seq', 100, true);


--
-- Name: changelog_pkey; Type: CONSTRAINT; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

ALTER TABLE ONLY changelog
    ADD CONSTRAINT changelog_pkey PRIMARY KEY (id);


--
-- Name: crosssite_channels_outbox_pkey; Type: CONSTRAINT; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

ALTER TABLE ONLY crosssite_channels_outbox
    ADD CONSTRAINT crosssite_channels_outbox_pkey PRIMARY KEY (id);


--
-- Name: crosssite_inbox_pkey; Type: CONSTRAINT; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

ALTER TABLE ONLY crosssite_inbox
    ADD CONSTRAINT crosssite_inbox_pkey PRIMARY KEY (id);


--
-- Name: crosssite_outbox_pkey; Type: CONSTRAINT; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

ALTER TABLE ONLY crosssite_outbox
    ADD CONSTRAINT crosssite_outbox_pkey PRIMARY KEY (id);


--
-- Name: crosssite_sites_pkey; Type: CONSTRAINT; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

ALTER TABLE ONLY crosssite_sites
    ADD CONSTRAINT crosssite_sites_pkey PRIMARY KEY (id);


--
-- Name: dataset_fields_pkey; Type: CONSTRAINT; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

ALTER TABLE ONLY dataset_fields
    ADD CONSTRAINT dataset_fields_pkey PRIMARY KEY (id);


--
-- Name: dataset_sync_pkey; Type: CONSTRAINT; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

ALTER TABLE ONLY dataset_sync
    ADD CONSTRAINT dataset_sync_pkey PRIMARY KEY (id);


--
-- Name: datasets_pkey; Type: CONSTRAINT; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

ALTER TABLE ONLY datasets
    ADD CONSTRAINT datasets_pkey PRIMARY KEY (name);


--
-- Name: document_audio_pkey; Type: CONSTRAINT; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

ALTER TABLE ONLY document_audio
    ADD CONSTRAINT document_audio_pkey PRIMARY KEY (id);


--
-- Name: document_file_pkey; Type: CONSTRAINT; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

ALTER TABLE ONLY document_file
    ADD CONSTRAINT document_file_pkey PRIMARY KEY (id);


--
-- Name: document_image_pkey; Type: CONSTRAINT; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

ALTER TABLE ONLY document_image
    ADD CONSTRAINT document_image_pkey PRIMARY KEY (id);


--
-- Name: document_news_pkey; Type: CONSTRAINT; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

ALTER TABLE ONLY document_news
    ADD CONSTRAINT document_news_pkey PRIMARY KEY (id);


--
-- Name: document_text_pkey; Type: CONSTRAINT; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

ALTER TABLE ONLY document_text
    ADD CONSTRAINT document_text_pkey PRIMARY KEY (id);


--
-- Name: document_video_pkey; Type: CONSTRAINT; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

ALTER TABLE ONLY document_video
    ADD CONSTRAINT document_video_pkey PRIMARY KEY (id);


--
-- Name: feedbacks_pkey; Type: CONSTRAINT; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

ALTER TABLE ONLY feedbacks
    ADD CONSTRAINT feedbacks_pkey PRIMARY KEY (id);


--
-- Name: files_pkey; Type: CONSTRAINT; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

ALTER TABLE ONLY files
    ADD CONSTRAINT files_pkey PRIMARY KEY (id);


--
-- Name: folder_album_pkey; Type: CONSTRAINT; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

ALTER TABLE ONLY folder_album
    ADD CONSTRAINT folder_album_pkey PRIMARY KEY (id);


--
-- Name: folder_gallery_pkey; Type: CONSTRAINT; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

ALTER TABLE ONLY folder_gallery
    ADD CONSTRAINT folder_gallery_pkey PRIMARY KEY (id);


--
-- Name: folder_homepage_pkey; Type: CONSTRAINT; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

ALTER TABLE ONLY folder_homepage
    ADD CONSTRAINT folder_homepage_pkey PRIMARY KEY (id);


--
-- Name: folder_link_pkey; Type: CONSTRAINT; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

ALTER TABLE ONLY folder_link
    ADD CONSTRAINT folder_link_pkey PRIMARY KEY (id);


--
-- Name: folder_news_pkey; Type: CONSTRAINT; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

ALTER TABLE ONLY folder_news
    ADD CONSTRAINT folder_news_pkey PRIMARY KEY (id);


--
-- Name: folder_page_pkey; Type: CONSTRAINT; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

ALTER TABLE ONLY folder_page
    ADD CONSTRAINT folder_page_pkey PRIMARY KEY (id);


--
-- Name: links_pkey; Type: CONSTRAINT; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

ALTER TABLE ONLY links
    ADD CONSTRAINT links_pkey PRIMARY KEY (item_id);


--
-- Name: metas_pkey; Type: CONSTRAINT; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

ALTER TABLE ONLY metas
    ADD CONSTRAINT metas_pkey PRIMARY KEY (item_id);


--
-- Name: roles_name_key; Type: CONSTRAINT; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

ALTER TABLE ONLY roles
    ADD CONSTRAINT roles_name_key UNIQUE (name);


--
-- Name: roles_pkey; Type: CONSTRAINT; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

ALTER TABLE ONLY roles
    ADD CONSTRAINT roles_pkey PRIMARY KEY (id);


--
-- Name: roles_users_pkey; Type: CONSTRAINT; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

ALTER TABLE ONLY roles_users
    ADD CONSTRAINT roles_users_pkey PRIMARY KEY (user_id, role_id);


--
-- Name: search_index_pkey; Type: CONSTRAINT; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

ALTER TABLE ONLY search_index
    ADD CONSTRAINT search_index_pkey PRIMARY KEY (id);


--
-- Name: setting_categories_pkey; Type: CONSTRAINT; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

ALTER TABLE ONLY setting_categories
    ADD CONSTRAINT setting_categories_pkey PRIMARY KEY (id);


--
-- Name: setting_values_pkey; Type: CONSTRAINT; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

ALTER TABLE ONLY setting_values
    ADD CONSTRAINT setting_values_pkey PRIMARY KEY (id);


--
-- Name: settings_categories_category_id_setting_id_key; Type: CONSTRAINT; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

ALTER TABLE ONLY settings_categories
    ADD CONSTRAINT settings_categories_category_id_setting_id_key UNIQUE (category_id, setting_id);


--
-- Name: settings_pkey; Type: CONSTRAINT; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

ALTER TABLE ONLY settings
    ADD CONSTRAINT settings_pkey PRIMARY KEY (id);


--
-- Name: site_hosts_pkey; Type: CONSTRAINT; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

ALTER TABLE ONLY site_hosts
    ADD CONSTRAINT site_hosts_pkey PRIMARY KEY (id);


--
-- Name: sites_pkey; Type: CONSTRAINT; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

ALTER TABLE ONLY sites
    ADD CONSTRAINT sites_pkey PRIMARY KEY (id);


--
-- Name: statuses_pkey; Type: CONSTRAINT; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

ALTER TABLE ONLY statuses
    ADD CONSTRAINT statuses_pkey PRIMARY KEY (id);


--
-- Name: subscribe_channels_pkey; Type: CONSTRAINT; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

ALTER TABLE ONLY subscribe_channels
    ADD CONSTRAINT subscribe_channels_pkey PRIMARY KEY (id);


--
-- Name: subscribe_users_pkey; Type: CONSTRAINT; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

ALTER TABLE ONLY subscribe_users
    ADD CONSTRAINT subscribe_users_pkey PRIMARY KEY (id);


--
-- Name: tags_links_pkey; Type: CONSTRAINT; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

ALTER TABLE ONLY tags_links
    ADD CONSTRAINT tags_links_pkey PRIMARY KEY (id);


--
-- Name: tags_pkey; Type: CONSTRAINT; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

ALTER TABLE ONLY tags
    ADD CONSTRAINT tags_pkey PRIMARY KEY (id);


--
-- Name: user_group_structure_item_roles_item_id_group_id_key_key; Type: CONSTRAINT; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

ALTER TABLE ONLY user_group_structure_item_roles
    ADD CONSTRAINT user_group_structure_item_roles_item_id_group_id_key_key UNIQUE (item_id, group_id, key);


--
-- Name: user_group_structure_item_roles_pkey; Type: CONSTRAINT; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

ALTER TABLE ONLY user_group_structure_item_roles
    ADD CONSTRAINT user_group_structure_item_roles_pkey PRIMARY KEY (id);


--
-- Name: user_groups_pkey; Type: CONSTRAINT; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

ALTER TABLE ONLY user_groups
    ADD CONSTRAINT user_groups_pkey PRIMARY KEY (id);


--
-- Name: user_tokens_pkey; Type: CONSTRAINT; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

ALTER TABLE ONLY user_tokens
    ADD CONSTRAINT user_tokens_pkey PRIMARY KEY (id);


--
-- Name: user_tokens_token_key; Type: CONSTRAINT; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

ALTER TABLE ONLY user_tokens
    ADD CONSTRAINT user_tokens_token_key UNIQUE (token);


--
-- Name: users_groups_user_id_group_id_key; Type: CONSTRAINT; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

ALTER TABLE ONLY users_groups
    ADD CONSTRAINT users_groups_user_id_group_id_key UNIQUE (user_id, group_id);


--
-- Name: users_pkey; Type: CONSTRAINT; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

ALTER TABLE ONLY users
    ADD CONSTRAINT users_pkey PRIMARY KEY (id);


--
-- Name: users_username_key; Type: CONSTRAINT; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

ALTER TABLE ONLY users
    ADD CONSTRAINT users_username_key UNIQUE (username);


--
-- Name: changelog_datetime_idx; Type: INDEX; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE INDEX changelog_datetime_idx ON changelog USING btree (datetime);


--
-- Name: changelog_factory_key_idx; Type: INDEX; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE INDEX changelog_factory_key_idx ON changelog USING btree (factory_key);


--
-- Name: dataset_fields_dataset_name_idx; Type: INDEX; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE INDEX dataset_fields_dataset_name_idx ON dataset_fields USING btree (dataset_name);


--
-- Name: dataset_fields_enabled_idx; Type: INDEX; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE INDEX dataset_fields_enabled_idx ON dataset_fields USING btree (enabled);


--
-- Name: dataset_fields_key_idx; Type: INDEX; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE INDEX dataset_fields_key_idx ON dataset_fields USING btree (key);


--
-- Name: datasets_enabled_idx; Type: INDEX; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE INDEX datasets_enabled_idx ON datasets USING btree (enabled);


--
-- Name: document_audio_index; Type: INDEX; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE INDEX document_audio_index ON document_audio USING btree (_links_index);


--
-- Name: document_audio_parent_id_enabled; Type: INDEX; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE INDEX document_audio_parent_id_enabled ON document_audio USING btree (_links_parent_id, _links_enabled);


--
-- Name: document_file_index; Type: INDEX; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE INDEX document_file_index ON document_file USING btree (_links_index);


--
-- Name: document_file_parent_id_enabled; Type: INDEX; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE INDEX document_file_parent_id_enabled ON document_file USING btree (_links_parent_id, _links_enabled);


--
-- Name: document_image_index; Type: INDEX; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE INDEX document_image_index ON document_image USING btree (_links_index);


--
-- Name: document_image_parent_id_enabled; Type: INDEX; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE INDEX document_image_parent_id_enabled ON document_image USING btree (_links_parent_id, _links_enabled);


--
-- Name: document_news_datetime_idx; Type: INDEX; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE INDEX document_news_datetime_idx ON document_news USING btree (datetime);


--
-- Name: document_news_index; Type: INDEX; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE INDEX document_news_index ON document_news USING btree (_links_index);


--
-- Name: document_news_parent_id_enabled; Type: INDEX; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE INDEX document_news_parent_id_enabled ON document_news USING btree (_links_parent_id, _links_enabled);


--
-- Name: document_text_index; Type: INDEX; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE INDEX document_text_index ON document_text USING btree (_links_index);


--
-- Name: document_text_parent_id_enabled; Type: INDEX; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE INDEX document_text_parent_id_enabled ON document_text USING btree (_links_parent_id, _links_enabled);


--
-- Name: document_video_index; Type: INDEX; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE INDEX document_video_index ON document_video USING btree (_links_index);


--
-- Name: document_video_parent_id_enabled; Type: INDEX; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE INDEX document_video_parent_id_enabled ON document_video USING btree (_links_parent_id, _links_enabled);


--
-- Name: folder_gallery_index; Type: INDEX; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE INDEX folder_gallery_index ON folder_gallery USING btree (_links_index);


--
-- Name: folder_gallery_parent_id_enabled; Type: INDEX; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE INDEX folder_gallery_parent_id_enabled ON folder_gallery USING btree (_links_parent_id, _links_enabled);


--
-- Name: folder_link_index; Type: INDEX; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE INDEX folder_link_index ON folder_link USING btree (_links_index);


--
-- Name: folder_link_parent_id_enabled; Type: INDEX; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE INDEX folder_link_parent_id_enabled ON folder_link USING btree (_links_parent_id, _links_enabled);


--
-- Name: folder_news_index; Type: INDEX; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE INDEX folder_news_index ON folder_news USING btree (_links_index);


--
-- Name: folder_news_parent_id_enabled; Type: INDEX; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE INDEX folder_news_parent_id_enabled ON folder_news USING btree (_links_parent_id, _links_enabled);


--
-- Name: links_default; Type: INDEX; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE INDEX links_default ON links USING btree (parent_id, site_id, dataset_name, enabled);


--
-- Name: links_no_parent; Type: INDEX; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE INDEX links_no_parent ON links USING btree (site_id, dataset_name, enabled);


--
-- Name: roles_users_role_id_idx; Type: INDEX; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE INDEX roles_users_role_id_idx ON roles_users USING btree (role_id);


--
-- Name: search_index_default; Type: INDEX; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE INDEX search_index_default ON search_index USING btree (site_id, enabled);


--
-- Name: search_index_group; Type: INDEX; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE INDEX search_index_group ON search_index USING btree ("group");


--
-- Name: search_index_parent_id; Type: INDEX; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE INDEX search_index_parent_id ON search_index USING btree (class_parent_id);


--
-- Name: search_index_proccess_id; Type: INDEX; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE INDEX search_index_proccess_id ON search_index USING btree (_proccess_id);


--
-- Name: tags_links_1_idx; Type: INDEX; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE INDEX tags_links_1_idx ON tags_links USING btree (item_id, item_type);


--
-- Name: tags_links_factory_key_idx; Type: INDEX; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE INDEX tags_links_factory_key_idx ON tags_links USING btree (factory_key);


--
-- Name: tags_links_item_id_idx; Type: INDEX; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE INDEX tags_links_item_id_idx ON tags_links USING btree (item_id);


--
-- Name: tags_links_item_type_idx; Type: INDEX; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE INDEX tags_links_item_type_idx ON tags_links USING btree (item_type);


--
-- Name: user_tokens_user_id_idx; Type: INDEX; Schema: public; Owner: wc-sample.pos; Tablespace: 
--

CREATE INDEX user_tokens_user_id_idx ON user_tokens USING btree (user_id);


--
-- Name: update_search_index_tsvector; Type: TRIGGER; Schema: public; Owner: wc-sample.pos
--

CREATE TRIGGER update_search_index_tsvector BEFORE INSERT OR UPDATE ON search_index FOR EACH ROW EXECUTE PROCEDURE update_search_index_tsvector();


--
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO pgsql;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- PostgreSQL database dump complete
--

