(function($) {
    $.adminTree = {
        _internalInit: function() {
            this.contextMenuNode = $;

            this.initCreateItemMenu();
            this.initTree();
            this.initDocumentsDD();
            this.initContextMenu();
        },

        init: function() {

        },

        initDocumentsDD: function() {
            $('#structure-tree li a').live('mouseup', function(){
                if($.ui.ddmanager.current == null)
                    return;

                var node = $(this).parent();
                var draggable = $.ui.ddmanager.current.element.get(0);

                if(draggable.tagName == 'TR') {
                    var row = $(draggable);
                    var editlist = row.closest('.editlist');

                    if(editlist.size() == 0)
                        return;

                    var eo = editlist.editlist();
                    if(!eo.dragging)
                        return;

                    var target = node.attr('id');
                    var documentIds = [];


                    eo.draggingRows.each(function(){
                        var row = $(this);
                        documentIds.push(row.attr('rel'));
                    });

                    documentIds = document.admin.getTree().arrayUnique(documentIds);

                    if(!documentIds)
                        return;

                    $.ajax({
                        async : false,
                        type: 'POST',
                        url: document.admin.baseUrl + 'structure_tree/move_documents/',
                        data : {
                            ids : documentIds,
                            target : target
                        },
                        error: function(r) {
                            document.admin.error(r.responseText);
                        },
                        success : function (r) {
                            var r = $.parseJSON(r);

                            if(r.messages)
                                document.admin.handleMessages(r.messages);

                            document.admin.refresh();
                        }
                    });
                }
            });
        },

        initTree: function() {
            $("#structure-tree").jstree({
                "themes": {
                    "url": document.admin.mediaUrl + '/css/jquery.jstree.css',
                    "theme" : "default"
                },
                "plugins" : [
                    "themes",
                    "json_data",
                    "ui",
                    "dnd"
                ],

                "json_data" : {
                    "ajax" : {
                        "url" : document.admin.baseUrl + 'structure_tree/folders/',
                        "data" : function (n) {
                            return {
                                node: n.attr ? n.attr("id") : 0
                            };
                        },
                        "cache" : false
                    }
                }
            })
            .bind("select_node.jstree", function (e, data) {
                var _options = typeof data.args[1] == 'object' ? data.args[1] : {};
                var options = $.extend({
                    open_node: true,
                    handle_url: true
                }, _options);

                if(options.open_node)
                    $("#structure-tree").jstree("open_node", data.rslt.obj);

                if(options.handle_url) {
                    var item_id = data.rslt.obj.attr('id');
                    $.address.value( document.admin.baseUrl + 'structure_item/item/' + item_id );
                }
            })
            .bind("move_node.jstree", function (e, data) {
                var ids = [];
                for(var i=0; i < data.rslt.o.size(); i++) {
                    var node = data.rslt.o.eq(i);
                    ids.push(node.attr('id'));
                }

                ids = document.admin.getTree().arrayUnique(ids);

                var target = data.rslt.cr === -1 ? 0 : data.rslt.np.attr("id");
                var index = data.rslt.cp;

                if(!confirm('Подтвердите перемещение' + (ids.length == 1 ? ' папки' : 'папок')))
                {
                    $.jstree.rollback(data.rlbk);
                    return false;
                }

                $.ajax({
                    async : false,
                    type: 'POST',
                    url: document.admin.baseUrl + 'structure_tree/move_folders/',
                    data : {
                        ids : ids,
                        target : target,
                        index : index
                    },
                    error: function(r) {
                        $.jstree.rollback(data.rlbk);
                        document.admin.error(r.responseText);
                    },
                    success : function (r) {
                        var r = $.parseJSON(r);

                        if(r.messages)
                            document.admin.handleMessages(r.messages);

                        if(!r.success) {
                            $.jstree.rollback(data.rlbk);
                            document.admin.error(r.message)
                        }
                        else {
                            var newParent = data.rslt.np;
                            data.inst.refresh(newParent);
                        }
                    }
                });
            })
            .bind("loaded.jstree", function (event, data) {
                $("#structure-tree ul > li").each(function(){
                    $("#structure-tree").jstree("open_node", this);
                });
            });
        },

        initCreateItemMenu: function() {
            var list = $('#wc-left .create-item-list');
            var button = $('#wc-left .create-item');

            function _showCreateItemMenu() {
                button.addClass('create-item-active');
                list.show();

                $(window).bind('click', _hideCreateItemMenu);
            }

            function _hideCreateItemMenu() {
                button.removeClass('create-item-active');
                list.hide();

                $(document).unbind('click', _hideCreateItemMenu);
            }

            button.click(function(){
                if(list.is(':visible'))
                    _hideCreateItemMenu();
                else
                    _showCreateItemMenu();

                return false;
            });
            list.find('.item').click(function(){
                _hideCreateItemMenu();
            });
        },

        _cmCreateItemGroupDisabled: function(groupName) {
            if( document.admin.getTree().getSelected().size() != 1 )
                return true; //disabled

            var controller = document.admin.getTree();
            var selected = controller.getSelected('over');
            var admin = document.admin;
            var parentDataset = admin.getDataset( selected.attr('datasetName') );

            if(!parentDataset)
                return true; //disabled

            var childDatasetNames = parentDataset.childDatasets;
            for(var i = 0; i < childDatasetNames.length; i++) {
                var childDataset = admin.getDataset(childDatasetNames[i]);

                if(!childDataset || childDataset.enabled == 0)
                    continue;

                if(groupName == 'createFolder' && childDataset.type == 'folder')
                    return false; //enabled

                if(groupName == 'createDocument' && childDataset.type == 'document')
                    return false; //enabled
            }

            return true; //disabled
        },

        _cmCreateItemDisabled: function(childDatasetName) {
            var controller = document.admin.getTree();
            var selected = controller.getSelected('over');
            var admin = document.admin;
            var parentDataset = admin.getDataset( selected.attr('datasetName') );

            if(!parentDataset)
                return true; //disabled

            if($.inArray(childDatasetName, parentDataset.childDatasets) > -1)
                return false; //enabled

            return true; //disabled
        },

        initContextMenu: function() {
            var folders = {};
            var documents = {};
            var datasets = document.admin.getDatasets();

            for(var i=0; i < datasets.length; i++) {
                var dataset = datasets[i];

                if(dataset.enabled == 0)
                    continue

                if(dataset.type == 'folder') {
                    folders[ dataset.name ] = {
                        name: dataset.title,
                        callback: this._cmCreateItem,
                        disabled: this._cmCreateItemDisabled
                    };
                } else {
                    documents[ dataset.name ] = {
                        name: dataset.title,
                        callback: this._cmCreateItem,
                        disabled: this._cmCreateItemDisabled
                    };
                }
            }

            $('#structure-tree li a').live("contextmenu", function (e, data) {
                var controller = document.admin.getTree();
                controller.contextMenuNode = $(this).parent();

                var selected = controller.getSelected();
                if(selected.size() == 1) {
                    $("#structure-tree").jstree("deselect_node", selected);

                    var node = $(this).closest('li');
                    $("#structure-tree").jstree("select_node", node, {
                        open_node: false,
                        handle_url: false
                    });
                }
            });

            $.contextMenu({
                selector: '#structure-tree li a',
                items: {
                    createFolder: {
                        name: 'Создать папку',
                        disabled: this._cmCreateItemGroupDisabled,
                        items: folders
                    },
                    createDocument: {
                        name: 'Создать документ',
                        disabled: this._cmCreateItemGroupDisabled,
                        items: documents
                    },

                    separator1: "-----",

                    openAtSite:{
                        name:'Открыть на сайте',
                        disabled:function () {
                            var controller = document.admin.getTree();
                            var selected = controller.getSelected();
                            var isAnyEnabled = false;

                            for (var i = 0; i < selected.size(); i++) {
                                var node = selected.eq(i);

                                if (!controller.canEdit(node)) {
                                    return true; // true = disable
                                }

                                if (node.hasClass('enabled')) {
                                    isAnyEnabled = true;
                                }
                            }

                            return !isAnyEnabled;
                        },
                        callback:this._cmOpenAtSite
                    },

                    openInANewTab:{
                        name:'Открыть на новой вкладке',
                        callback:this._cmOpenInANewTab
                    },

                    separator4:"-----",

                    enable: {
                        name: 'Показать',
                        disabled: function() {
                            var controller = document.admin.getTree();
                            var selected = controller.getSelected();
                            var isAnyDisabled = false;

                            for(var i=0; i < selected.size(); i++) {
                                var node = selected.eq(i);

                                if(!controller.canEdit(node)) {
                                    return true; // true = disable
                                }

                                if(node.hasClass('disabled')) {
                                    isAnyDisabled = true;
                                }
                            }

                            return !isAnyDisabled;
                        },
                        callback: this._cmEnable
                    },

                    disable:{
                        name:'Скрыть',
                        disabled:function () {
                            var controller = document.admin.getTree();
                            var selected = controller.getSelected();
                            var isAnyEnabled = false;

                            for (var i = 0; i < selected.size(); i++) {
                                var node = selected.eq(i);

                                if (!controller.canEdit(node)) {
                                    return true; // true = disable
                                }

                                if (node.hasClass('enabled')) {
                                    isAnyEnabled = true;
                                }
                            }

                            return !isAnyEnabled;
                        },
                        callback:this._cmDisable
                    },

                    separator2: "-----",

                    copy: {
                        name: 'Копировать',
                        disabled: function() {
                            return document.admin.getTree().getSelected().size() < 1;
                        },
                        callback: this._cmCopy
                    },

                    copyRecursive: {
                        name: 'Копировать рекурсивно',
                        disabled: function() {
                            if(!document.admin.user.isRoot())
                                return true;

                            return document.admin.getTree().getSelected().size() < 1;
                        },
                        callback: this._cmCopyRecursive
                    },

                    paste: {
                        name: 'Вставить',
                        disabled: function() {
                            var admin = document.admin;
                            var controller = admin.getTree();

                            if(admin.itemsClipboard.isEmpty())
                                return true;

                            if(controller.getSelected('over').size() != 1)
                                return true;

                            return false;
                        },
                        callback: this._cmPaste
                    },


                    separator3: "-----",

                    remove: {
                        name: 'Удалить',
                        disabled: function() {
                            var controller = document.admin.getTree();
                            var selected = controller.getSelected();

                            if(selected.size() < 1)
                                return true;

                            for(var i=0; i < selected.size(); i++) {
                                var node = selected.eq(i);

                                if(!controller.canDelete(node)) {
                                    return true; // true = disable
                                }
                            }

                            return false;
                        },
                        callback: $.proxy(this._cmDelete, this)
                    }
                }
            });
        },

        _cmCreateItem: function(datasetName, opts) {
            var controller = document.admin.getTree();
            var node = controller.getSelected('over');
            var nodeId = node.attr('id');
            var dataset = document.admin.getDataset(datasetName);

            if(dataset.type === 'folder') {
                var url = document.admin.baseUrl + 'structure_item/create/';

                if(datasetName)
                    url += datasetName + '/';

                if(nodeId > 0)
                    url += 'to/' + nodeId + '/';

            } else {
                var url = document.admin.baseUrl + 'structure_item/documents/' + nodeId + '/create/?type=' + dataset.name;
            }

            $.address.value(url);
        },

        _cmEnable: function() {
            document.admin.getTree()._enableSelected('1');
        },

        _cmDisable: function() {
            document.admin.getTree()._enableSelected('');
        },

        _cmCopy: function() {
            var list = document.admin.getTree().getSelected();
            var ids = [];
            var admin = document.admin;

            for(var i=0; i < list.size(); i++) {
                var node = list.eq(i);
                ids.push(node.attr('id'));
            }
            ids = document.admin.getTree().arrayUnique(ids);
            admin.itemsClipboard.put('folder', ids, 'copy_folders');

            if(ids.length > 0) {
                admin.alert(admin.plural(ids.length, ['Скопирована', 'Скопировано', 'Скопированы'], false) + ' ' + admin.plural(ids.length, ['папка', 'папки', 'папок']))
            }
        },

        _cmCopyRecursive: function() {
            var list = document.admin.getTree().getSelected();
            var ids = [];
            var admin = document.admin;

            for(var i=0; i < list.size(); i++) {
                var node = list.eq(i);
                ids.push(node.attr('id'));
            }

            ids = document.admin.getTree().arrayUnique(ids);
            admin.itemsClipboard.put('folder', ids, 'copy_folders/recursive');

            if(ids.length > 0) {
                admin.alert(admin.plural(ids.length, ['Скопирована', 'Скопировано', 'Скопированы'], false) + ' ' + admin.plural(ids.length, ['папка', 'папки', 'папок']))
            }
        },

        _cmOpenAtSite: function() {
            var controller = document.admin.getTree();
            var selected = controller.getSelected();
            var isAnyEnabled = false;

            for(var i=0; i < selected.size(); i++) {
                var node = selected.eq(i);

                if(!node.hasClass('enabled')) {
                    continue;
                }

                var url = node.attr('url');
                window.open(url, '_blank');
                window.focus();
            }

            return !isAnyEnabled;
        },

        _cmOpenInANewTab: function() {
            var controller = document.admin.getTree();
            var selected = controller.getSelected();
            var isAnyEnabled = false;

            for(var i=0; i < selected.size(); i++) {
                var node = selected.eq(i);
                var url = node.attr('href');
                window.open(url, '_blank');
                window.focus();
            }

            return !isAnyEnabled;
        },

        _cmPaste: function() {
            var admin = document.admin;
            var controller = admin.getTree();

            if(admin.itemsClipboard.isEmpty())
                return;

            var ids = admin.itemsClipboard.getIds();
            var parent = controller.getSelected('over');
            $.ajax({
                url:  admin.baseUrl + 'structure_tree/' + admin.itemsClipboard.action + '/',
                async : false,
                type: 'POST',
                data: {
                    target: parent.attr('id'),
                    ids: ids
                },
                success : function (r) {
                    var r = $.parseJSON(r);

                    if(r.messages)
                        document.admin.handleMessages(r.messages);

                    if(r.success) {
                        $('#structure-tree').jstree('refresh', parent);

                        if(document.admin.itemsClipboard.getType() == 'document')
                            document.admin.refresh();

                        // admin.itemsClipboard.reset();
                    }
                },
                error: function(r) {
                    document.admin.error(r.responseText);
                }
            });
        },

        _cmDelete: function() {
            var node;
            var ids = [];
            var selected = this.getSelected();
            for(var i=0; i < selected.size(); i++) {
                node = selected.eq(i);
                ids.push(node.attr('id'));
            }
            var c = this.arrayUnique(ids).length;

            if(!confirm('Удалить ' + document.admin.plural(c, ['папку','папаки','папок'], c > 1) + '?'))
                return true;

            this._deleteSelected();
        },

        arrayUnique: function(array)
        {
            return array.filter(function(el, index, arr) {
                return index == arr.indexOf(el);
            });
        },

        _enableSelected: function(value) {
            var admin = document.admin;
            var controller = admin.getTree();
            var selected = controller.getSelected();
            var me = this;
            var ids = [];

            for(var i=0; i < selected.size(); i++) {
                var node = selected.eq(i);
                ids.push(node.attr('id'));
            }

            ids = controller.arrayUnique(ids);

            $.ajax({
                url:  admin.baseUrl + 'structure_tree/enable_folders/',
                async : false,
                type: 'POST',
                data: {
                    ids: ids,
                    enabled: value
                },
                success : function (r) {
                    var r = $.parseJSON(r);

                    if(r.messages)
                        document.admin.handleMessages(r.messages);

                    if(r.success) {
                        for(var i=0; i < selected.size(); i++) {
                            var node = selected.eq(i);
                            node.addClass(value ? 'enabled' : 'disabled');
                            node.removeClass(value ? 'disabled' : 'enabled');
                        }
                    }
                },
                error: function(r) {
                    document.admin.error(r.responseText);
                }
            });
        },

        _deleteSelected: function() {
            var admin = document.admin;
            var selected = admin.getTree().getSelected();
            var me = this;
            var ids = [];
            var redirect = false;
            var folder_id = document.admin.folderId;

            for(var i=0; i < selected.size(); i++) {
                node = selected.eq(i);
                var selected_id = node.attr('id');

                if (folder_id && folder_id == selected_id)
                {
                    redirect = true;
                }

                ids.push(selected_id);
            }

            ids = admin.getTree().arrayUnique(ids);

            $.ajax({
                url:  admin.baseUrl + 'structure_tree/delete_folders/',
                async : false,
                type: 'POST',
                data: {
                    ids: ids
                },
                success : function (r) {
                    var r = $.parseJSON(r);

                    if(r.messages)
                        document.admin.handleMessages(r.messages);

                    if(r.success) {
                        var parent = selected.parent();
                        selected.remove();
                        $('#structure-tree').jstree('refresh', parent);

                        if (redirect)
                        {
                            $.address.value(admin.baseUrl);
                        }
                    }
                },
                error: function(r) {
                    document.admin.error(r.responseText);
                }
            });
        },

        getSelected: function(mode) {
            if(mode !== 'over') {
                var selected = $("#structure-tree").jstree("get_selected");

                if(selected.size() != 0)
                    return selected;
            }

            return this.contextMenuNode;
        },

        reload: function()
        {
            $("#structure-tree").jstree('destroy').html('');
            this._internalInit();
            this.init();
        },

        canEdit: function(node) {
            return true; // @todo
        },

        canDelete: function(node) {
            return true; // @todo
        },

        canContain: function(parent, node) {
            return true;
        },

        canAppendFolder: function(parent) {
            return true;
        },

        canAppendDocument: function(parent) {
            return true;
        }
    };

    $.fn.admintree = function(options) {
        var domNode = this;

        if(options === undefined) {
            options = {};
        }

        if(!domNode.data('adminTree')) {
            var tree = $.extend(true, {}, $.adminTree); // clone
            var tree = $.extend(tree, options);

            tree._internalInit();
            tree.init();

            domNode.data('adminTree', tree);
        }

        return domNode.data('adminTree');
    }
})(jQuery);