$(function () {
    document.site = {
        baseUrl:null
    };

    document.admin = {
        baseUrl:null,
        mediaUrl: '/wc/wc_admin/media',
        datasets:null,
        user: {
            data: {},

            isRoot: function()
            {
                return this.data.isRoot;
            },

            isAdmin: function()
            {
                return this.data.isAdmin;
            },

            isModerator: function()
            {
                return this.data.isModerator;
            },

            setData: function(data)
            {
                this.data = data;
            }
        },
        center:null,
        tree:null,
        _fadeNode:null,
        _overlayNode:null,
        _menuInited: null,

        itemsClipboard:{
            type:null,
            action:null,
            ids:[],

            isEmpty:function () {
                return this.ids.length == 0;
            },

            reset:function () {
                this.type = null;
                this.action = null;
                this.ids = [];
            },

            put:function (type, ids, action) {
                if(!action)
                    action = 'copy_items';

                this.type = type;
                this.ids = ids;
                this.action = action;
            },

            getIds:function () {
                if (this.ids === null)
                    return [];

                return this.ids;
            },

            getType:function () {
                return this.type;
            }
        },

        alert:function (data) {
            if (typeof(data) == 'string') {
                data = {
                    title:'',
                    text:data
                };
            }

            if (!data.title && data.text && data.text.length <= 30) {
                data.title = data.text;
                data.text = '';
            }

            if (!data.text)
                data.text = ' ';

            if (!data.title)
                data.title = ' ';

            $.gritter.add(data);
        },

        error:function (data) {
            if (typeof(data) == 'string') {
                data = {
                    title:'',
                    text:data
                };
            }

            if (!data.title && data.text && data.text.length <= 30) {
                data.title = data.text;
                data.text = '';
            }

            if (!data.title)
                data.title = 'Ошибка!';

            this.alert(data);
        },

        refresh:function () {
            var url = document.admin.getActualUrl();

            if (url.indexOf('?') !== -1)
                url += '&';
            else
                url += '?';

            url += 'rnd=' + Math.random();
            $.address.value(url);
        },

        loader: function(value) {
            var loader = $('#admin-loader');

            if(value)
                loader.show();
            else
                loader.hide();
        },

        updateMenu:function () {
            var mainmenu = $('#wc-top .main-menu');
            var items = mainmenu.find(' > .menu-item');
            var url = this.getActualUrl();
            url = url.replace(this.baseUrl, '');

            items.each(function () {
                var node = $(this);
                var re = node.attr('rel');

                if (!re)
                    return;

                if (url.match(re)) {
                    node.addClass('menu-item-active');
                    node.data('active', true);
                } else {
                    node.removeClass('menu-item-active');
                    node.data('active', false);
                }
            });

            if(this._menuInited === null) {
                var mouseenter = function() {
                    var node = $(this);
                    node.addClass('menu-item-active menu-item-hover');
                };

                var mouseleave = function() {
                    var node = $(this);

                    if(!node.hasClass('menu-item'))
                        node = node.closest('.menu-item');

                    node.removeClass('menu-item-hover');

                    if(!node.data('active'))
                        node.removeClass('menu-item-active');
                };

                items.filter(':has(.submenu)')
                    .mouseenter(mouseenter)
                    .mouseleave(mouseleave);

                mainmenu.find('.submenu a').click(mouseleave);
                this._menuInited = 1;
            }
        },

        unload: function(callback) {
            $(document).one('unload', callback);
        },

        ajaxHandler:function (data) {
            this.loader(false);

            if (data.messages)
                this.handleMessages(data.messages)

            if (data.redirect) {
                var url = data.redirect;

                if (url.indexOf('?') !== -1)
                    url += '&';
                else
                    url += '?';

                url += 'rnd=' + Math.random();

                if(data.redirect_hard) {
                    window.location = url;
                    // window.location.refresh();
                } else {
                    $.address.value(url);
                }

                return;
            }

            $(document).trigger('unload');

            this.getCenter().setContent(data.content);
            this.updateMenu();
        },

        ajaxContentHandler:function (e) {
            document.admin.ajaxContentHandlerRequest(document.admin.getActualUrl());
        },

        ajaxContentHandlerRequest:function (url, data) {
            this.loader(true);

            if (url.indexOf('?') !== -1)
                url += '&';
            else
                url += '?';
            url +='_ajax=1';
            var opt = {
                url:url,
                cache: false,
                success:function (data) {
                    var jsonData = $.parseJSON(data);
                    var admin = document.admin;
                    admin.ajaxHandler(jsonData);
                },
                error:function (data) {
                    document.admin.loader(false);
                    document.admin.error(data.responseText);
                }
            }

            if (data === undefined)
                data = {};

            opt = $.extend(opt, data);

            $.ajax(opt);
        },

        ajaxFormHandler:function (e) {
            var form = $(this);
            form.trigger('beforeSubmit');

            document.admin.loader(true);

            if (tinyMCE)
                tinyMCE.triggerSave();

            var url = form.attr('action');

            if (!url)
                url = $.address.value();

            if (url.indexOf('?') !== -1)
                url += '&';
            else
                url += '?';

            url += 'rnd=' + Math.random();
            url +='&_ajax=1';

            var options = {
                url:url,
                cache: false,
                type:'POST',
                success:function (data) {
                    var jsonData = $.parseJSON(data);
                    var admin = document.admin;
                    admin.ajaxHandler(jsonData);
                },
                error:function (data) {
                    document.admin.loader(false);
                    document.admin.error(data.responseText);
                }
            };

            if($.browser.msie && $.browser.version <= 9)
            {
                options.data = form.serialize();
                $.ajax(options);
            }
            else
            {
                form.ajaxSubmit(options);
            }

            form.trigger('afterSubmit');
            e.preventDefault();
            return false;
        },

        aLocalHandler:function () {
            var a = $(this);
            var url = a.attr('href');

            if(a.hasClass('prevent')) {
                a.removeClass('prevent');
                return false;
            }

            $.address.value(url);
            return false;
        },

        initAjaxInterface:function () {
            $.address.change(this.ajaxContentHandler);
            $('a:not([href^="javascript:"]):not([href^="http:"]):not([href^="https:"]):not(.external):not(.noaddress):not(.jstree a)').live('click', this.aLocalHandler);
            $('form:not(.external)').live('submit', this.ajaxFormHandler);
        },

        getActualUrl:function () {
            if ($.address.value() && $.address.value() !== '/') {
                return $.address.value();
            } else {
                var l = document.location;
                var initalValue = l.pathname + l.search;

                if (initalValue.indexOf('?') === -1 && l.search)
                    initalValue += l.search;

                return initalValue;
            }
        },

        launch:function () {
            this.initAjaxInterface();
            this.initTree();
            this.initUiIcons();
            this.loader(false);
            this.updateMenu();
        },

        getCenter:function () {
            if (this.center === null) {
                this.center = {
                    body:$('#wc-center-inner'),
                    setContent:function (content) {
                        this.body.html(content);
                    }
                };
            }

            return this.center;
        },

        initTree:function (force) {
            if (this.tree === null || force) {
                this.tree = $('#structure-tree').admintree();
            }
        },

        getTree:function () {
            this.initTree();
            return this.tree;
        },

        getDatasets:function () {
            return this.datasets;
        },

        getDataset:function (datasetName) {
            for (var i = 0; i <= this.datasets.length; i++) {
                var dataset = this.datasets[i];

                if (dataset.name == datasetName)
                    return dataset;
            }

            return false;
        },

        plural:function (number, titles, showInt) {
            if (showInt === undefined)
                showInt = true;

            var cases = [2, 0, 1, 1, 1, 2]
            var title = titles[(number % 100 > 4 && number % 100 < 20) ? 2 : cases[Math.min(number % 10, 5)]];

            if (!showInt)
                return title;

            return number + " " + title;
        },

        handleMessages:function (messages) {
            for (var i = 0; i < messages.length; i++) {
                var message = messages[i];
                this.alert(message);
            }
        },

        initUiIcons: function() {
            $('.ui-state-default').live('mouseenter', function(){ $(this).addClass('ui-state-hover'); } );
            $('.ui-state-default').live('mouseleave', function(){ $(this).removeClass('ui-state-hover'); } );
        }
    };
});