(function($) {
    $.editform = {
        node: null,
        buttonSubmit: null,
        buttonCancel: null,
        buttonApply: null,

        _generateCode: function()
        {
            return Math.round( Math.random() * 100000 );
        },

        _noteMouseEnter: function()
        {
            var note = $(this);
            note.find('.note-text').show();
            note.data('enterCode', $.editform._generateCode());
        },

        _noteMouseLeave: function()
        {
            var note = $(this)
            note.data('leaveCode', $(this).data('enterCode'));

            setTimeout(function(){
                if(note.data('enterCode') == note.data('leaveCode'))
                    note.find('.note-text').hide();
            }, 500);
        },

        _buttonCancelClick: function()
        {
            var url = this.buttonCancel.data('url');
            $.address.value(url);
        },

        _buttonApplyClick: function()
        {
            this.buttonApply.addClass('clicked');

            var url = this.buttonApply.data('url');
            this.node.attr('action', url);
            this.node.trigger('submit');
        },

        _onSubmitBefore: function(e) {
            this.node.addClass('loading');

            if(this.node.find('input.clicked').size() == 0)
                this.buttonSubmit.addClass('clicked')
        },

        _onSubmitAfter: function()
        {
            this.node.find(':input').attr('disabled', 'disabled');

            setTimeout($.proxy(function(){
                this.node.find(':input').removeAttr('disabled');
                this.node.removeClass('loading');
                this.node.find('input.clicked').removeClass('clicked');
            }, this), 10000)
        },

        init: function(node) {
            this.node = $(node);
            this.node.on('beforeSubmit', $.proxy(this._onSubmitBefore, this));
            this.node.on('afterSubmit', $.proxy(this._onSubmitAfter, this));

            this.buttonSubmit = this.node.find('input[type="submit"]');
            this.buttonCancel = this.node.find('.button-cancel');
            this.buttonApply = this.node.find('.button-apply');

            this.buttonCancel.click($.proxy(this._buttonCancelClick, this));
            this.buttonApply.click($.proxy(this._buttonApplyClick, this) )

            var notes = this.node.find('.note');
            notes.mouseenter(this._noteMouseEnter);
            notes.mouseleave(this._noteMouseLeave);
        }
    };

    $.fn.editform = function(options) {
        this.each(function(){
            $.editform.init( this );
        });
    }
})(jQuery);