(function($) {
    $.editlistObject = {
        node: null,
        table: null,
        rows: null,
        form: null,
        url: '',

        _lastClickedIndex: null,

        hoverRow: function(row) {
            row.addClass('hover');
        },

        unhoverRow: function(row) {
            row.removeClass('hover');
        },

        isRowSelected: function(row) {
            return !!row.find('.checkbox input').attr('checked');
        },

        selectRow: function(row) {
            row.addClass('selected');
            row.find('.checkbox input').attr('checked', 'checked');
        },

        selectRows: function(list, switcher) {
            list.toggleClass('selected', switcher);
            list.find('.checkbox input').attr('checked', switcher ? 'checked' : false);
        },

        deselectRow: function(row) {
            row.removeClass('selected');
            row.find('.checkbox input').attr('checked', false);
        },

        getSelectedRows: function() {
            return this.rows.filter(':has(.checkbox input:checked)');
        },

        getSelectedRowsOnMouse: function(hoverRow, mode) {
            var selected = this.getSelectedRows();

            if(mode === undefined)
                mode = 'dragging';

            if(hoverRow !== undefined) {
                if(selected.size() == 0)
                    return hoverRow;

                if(!this.isRowSelected(hoverRow) && mode === 'dragging')
                    return $;
            }

            return selected;
        },

        getUrl: function(arg) {
            var url = this.url;

            if(!url)
                url = document.admin.getActualUrl();

            url = url.split('?');
            var path = url[0];
            var query = url[1];

            if(!path)
                path = '';

            if(!query)
                query = '';

            var re = new RegExp('');
            path = path.replace(/\/+$/, '');
            path += '/';

            if(arg !== undefined) {
                var addPath = arg;
                addPath = addPath.replace(/\/+$/, '').replace(/^\/+/, '');

                if(addPath)
                    path += addPath + '/';
            }

            var res = path;

            if(query)
                res += '?' + query;

            return res;
        },

        _rowMouseEnter: function() {
            var row = $(this);
            row.closest('.editlist').editlist().hoverRow(row);
        },

        _rowMouseLeave: function() {
            var row = $(this);
            row.closest('.editlist').editlist().unhoverRow( $(this) );
        },

        _cellClick: function(e) {
            var row = $(this).parent();
            var eo = row.closest('.editlist').editlist();

            if(e.shiftKey) {
                if(eo._lastClickedIndex !== undefined) {
                    var checkRows = !!eo.rows.eq(eo._lastClickedIndex).find('.checkbox input').attr('checked');
                    var currentIndex = eo.rows.index(row);

                    var from = eo._lastClickedIndex;
                    var to = currentIndex;

                    if(from > to) {
                        var tmp = from;
                        from = to;
                        to = tmp;
                    }

                    var list = eo.rows.slice(from, to+1);
                    eo.selectRows( list, checkRows );
                    eo._togglersCheck();
                    return;
                }
            }

            if( eo.isRowSelected(row) )
                eo.deselectRow(row);
            else
                eo.selectRow(row);

            eo._lastClickedIndex = eo.rows.index(row);
            eo._togglersCheck();
        },

        _rowDblClick: function(e) {
            var row = $(this);
            var editAction = row.find('.action-edit a');

            if(!editAction.size())
                return;

            editAction.trigger('click');
        },

        _togglerClick: function() {
            var eo = $(this).closest('.editlist').editlist();
            var checkboxes = eo.checkboxes;
            var togglers = eo.node.find('.check-all');
            var hasUnchecked = checkboxes.not(':checked').size() > 0;
            var checkAll = hasUnchecked;

            eo.selectRows( eo.rows, checkAll );
            togglers.attr('checked', checkAll ? 'checked' : false);

            if(checkAll)
                togglers.closest('label').addClass('selected');
            else
                togglers.closest('label').removeClass('selected');
        },

        _checkboxClick: function() {
            return false;
        },

        _groupActionChange: function() {
            var select = $(this);
            var eo = select.closest('.editlist').editlist();
            var action = select.attr('rel');
            var actionUrl = select.val();
            var option = select.find(':selected');
            var message = option.data('confirm') ? option.data('confirm') : 'Выполнить действие над выбранными документами?';

            if(!actionUrl || !confirm(message)) {
                select.val('');
                return false;
            }

            eo.form.attr('action', actionUrl);
            eo.form.submit();
        },

        _togglersCheck: function() {
            var eo = this;
            var checkboxTogglers = eo.node.find('.check-all');
            var hasUnchecked = eo.checkboxes.not(':checked').size() > 0;
            var hasChecked = eo.checkboxes.filter(':checked').size() > 0;

            var check = hasChecked && !hasUnchecked;
            checkboxTogglers.attr('checked', check ? 'checked' : false);

            if(check)
                checkboxTogglers.closest('label').addClass('selected');
            else
                checkboxTogglers.closest('label').removeClass('selected');
        },

        _filterButtonClick: function() {
            var eo = $(this).closest('.editlist').editlist();
            var filter = eo.node.find('.filter');
            var filterButton = $(this);
            var show = !filter.is(':visible');

            if(show)
                filter.slideDown('fast');
            else
                filter.slideUp('fast');

            filterButton.toggleClass('filter-button-active', show);

            return false;
        },

        _typeChange: function() {
            var selector = $(this);
            var url = selector.attr('rel');
            url = url.replace('=__type__', '=' + selector.val());
            $.address.value(url);
        },

        _perPageChange: function() {
            var perPage = $(this).val();
            var url = $(this).attr('rel');
            url = url.replace('__per_page__', perPage);
            $.address.value(url);
        },

        _internalInit: function(node) {
            this.node = node;
            this.table = this.node.find('.editlist-table');
            this.rows = this.table.find('tbody > tr:not(.empty)');
            this.form = this.node.find('.editlist-form');
            this.checkboxes = this.table.find('tbody tr td.checkbox input');

            var eo = this;
            var checkboxTogglers = eo.node.find('.check-all');
            var groupAction = eo.node.find('.group-action');
            var filterButton = eo.node.find('.filter-button');
            var typeSelector = eo.node.find('.type-select');
            var perPage = eo.node.find('.per-page-select');

            eo.rows.mouseenter(eo._rowMouseEnter);
            eo.rows.mouseleave(eo._rowMouseLeave);

            if(groupAction.size() > 0)
                eo.rows.find('td:not(.select-disable)').click(eo._cellClick);

            eo.rows.dblclick(eo._rowDblClick);
            checkboxTogglers.click(eo._togglerClick);
            eo.checkboxes.click(eo._checkboxClick)
            groupAction.change(eo._groupActionChange);
            eo.table.find('td, th').attr('unselectable', 'on');
            filterButton.click(eo._filterButtonClick);
            typeSelector.change(eo._typeChange);
            perPage.change(eo._perPageChange)
          },

        init: function() {

        }
    };

    $.fn.editlist = function(options) {
        var editlist = this;

        if(options === undefined) {
            options = {};
        }

        if(!editlist.data('editlist')) {
            var eo = $.extend(true, {}, $.editlistObject); // clone
            var eo = $.extend(eo, options);

            eo._internalInit(editlist);
            eo.init();

            editlist.data('editlist', eo);
        }

        return editlist.data('editlist');
    }
})(jQuery);