$(function(){
    document.overlay = {
        node: null,
        backgroundNode: null,
        scrollNode: null,
        cssNode: null,

        ie6: null,

        _init: function()
        {
            if(this.node)
                return;

            var version = $.browser.version.split('.');

            this.ie6 = $.browser.msie && version[0] < 7;
            this.node = $('<div id="overlay"></div>');
            this.scrollNode = $('<div id="overlay-scroll"></div>');
            this.backgroundNode = $('<div id="overlay-background"></div>');

            this.backgroundNode.hide().appendTo(document.body);
            this.scrollNode.hide().appendTo(document.body);
            this.node.hide().appendTo(this.scrollNode);

            this.node.mousedown($.proxy(function(e){
                if(e.target.id && e.target.id === 'overlay')
                    this.hide();
            }, this));

            $(document).keyup($.proxy(this._keypress, this));
        },

        _keypress: function(e)
        {
            if(e.keyCode == 27)
            {
                this.hide();
            }
        },

        show: function(selector)
        {
            this._init();

            if(this.node.is(':visible'))
                return;

            this.node.show();
            this.node.animate({scrollTop: 0}, 0);

            this.backgroundNode.show();
            this.scrollNode.show();
            this.node.trigger('shown');

            if(selector)
            {
                var window = $(selector);
                window.appendTo(this.node).show();

                window.find('.overlay-window-close').each(function(){
                    var node = $(this);

                    if(node.data('inited') === true)
                        return;

                    node.click(function(){
                        document.overlay.close();
                        return false;
                    });
                    node.data('inited', true)
                });

                if(this.ie6)
                {
                    window.css({
                        left: '50%',
                        marginLeft: Math.round( window.width() / 2 ) * -1
                    });
                }
            }

            this.cssNode = $('<style type="text/css" id="overlay-css">html{ overflow: hidden; }</style>').appendTo("head");
        },

        hide: function()
        {
            if(!this.node.is(':visible'))
                return;

            this.cssNode.remove();
            this.node.hide();
            this.backgroundNode.hide();
            this.scrollNode.hide();
            this.node.trigger('hidden');
        }
    };
});