(function() {
    tinymce.PluginManager.requireLangPack('preformat');

    tinymce.create('tinymce.plugins.preformatPlugin', {
        init : function(ed, url) {

            ed.addCommand('mcepreformat', function() {
                var node = tinyMCE.activeEditor.selection.getNode();
                var content = tinyMCE.activeEditor.selection.getContent();

                if (node.innerHTML == content)
                {
                    if (tinymce.activeEditor.dom.hasClass(node, 'preformat')) {
                        tinyMCE.activeEditor.dom.removeClass(node, 'preformat');
                        tinyMCE.activeEditor.dom.setAttrib(node, 'style', '');
                    } else {
                        tinyMCE.activeEditor.dom.addClass(node, 'preformat');
                        tinyMCE.activeEditor.dom.setAttrib(node, 'style', 'padding: 15px 15px;background: #e9e9df;font-size: 14px;font-style: italic;color: #64645f;');
                    }

                }
                else
                if (content != '') {
                    tinyMCE.activeEditor.selection.setContent('<span class="preformat" style="padding: 15px 15px;background: #e9e9df;font-size: 14px;font-style: italic;color: #64645f;">'+content+'</span>');
                }

            });

            ed.addButton('preformat', {
                title : 'preformat.desc',
                cmd : 'mcepreformat',
                image : url + '/img/preformat.gif'
            });

            ed.onNodeChange.add(function(ed, cm, n) {
                cm.setActive('preformat', tinyMCE.activeEditor.dom.hasClass(n, 'preformat'));
            });
        },

        createControl : function(n, cm) {
            return null;
        },

        getInfo : function() {
            return {
                longname : 'preformat plugin',
                author : 'Romanov Sergey',
                version : "1.0",
                onPostRender: function() {
                    var ctrl = this;

                    ed.on('NodeChange', function(e) {
                        ctrl.active(e.element.nodeName == 'P');
                    });
                }
            };
        }
    });

    tinymce.PluginManager.add('preformat', tinymce.plugins.preformatPlugin);
})();