(function($) {
    $.bookOptions = {
        node: null,
        list: null,
        head: null,
        addButton: null,
        name: '',
        index: 0,
        forms: null,

        createRow: function() {
            var row = $(
                '<div class="bo-row">' +

                    '<div class="bo-col ui-icons ui-widget icon-collection">' +
                        '<a href="#" class="bo-delete ui-state-error ui-corner-all" title="Удалить"><span class="ui-icon ui-icon-closethick"></span></a>' +
                    '</div>' +


                    '<div class="bo-inputs context">' +
                    '</div>' +

                    '<input type="hidden" class="bo-id" name="' + this.name + '[' + this.index + '][id]" />' +
                '</div>'
            );

            var inputBlock = row.find('.bo-inputs');
            for(var i=0; i < this.forms.length; i++) {
                var form = this.forms[i];
                var input = $('<input type="text" class="input-text bo-input bo-key-' + form.key + '" name="' + this.name + '[' + this.index + '][' + form.key + ']" value="" />')
                var div = $('<div class="bo-col ' + this._getColSizeClass() + '"></div>');

                input.keypress(this._inputKeyPress);
                div.append(input);
                inputBlock.append(div);
            }

            row.data('bo', this);
            row.find('.bo-delete').click(this._rowDeleteClick);

            this.index++;
            return row;
        },

        addRow: function(data) {
            if(data === undefined) {
                data = {
                    id: '',
                    forms: {}
                };
            }

            var row = this.createRow();
            row.find('.bo-id').val(data.id);

            for(var i=0; i < this.forms.length; i++) {
                var form = this.forms[i];

                if(!data.forms[form.key])
                    continue;

                var input = row.find('.bo-key-' + form.key);
                input.val(data.forms[form.key])
            }

            this.list.append(row);
        },

        setHead: function() {
            var context = $('<div class="context"></div>');
            for(var i=0; i < this.forms.length; i++) {
                var form = this.forms[i];
                var div = $('<div class="bo-col ' + this._getColSizeClass() + '">' + form.title + '&nbsp;</div>');

                context.append(div);
            }

            this.head.append(context);
        },

        setDummy: function() {
            this.list.append('<input type="hidden"  name="' + this.name + '[dummy]" value="" />');
        },

        _getColSizeClass: function() {
            if(this.forms.length <= 3)
                return 'bo-col-big';

            if(this.forms.length <= 7)
                return '';

            return 'bo-col-small';
        },

        _addButtonClick: function() {
            this.addRow();
            return false;
        },

        _rowDeleteClick: function() {
            var row = $(this).closest('.bo-row');
            row.remove();
            return false;
        },

        _inputKeyPress: function(e) {
            if(e.which == 13) {
                var row = $(this).closest('.bo-row');
                var inputs = row.find('.bo-input');
                var index = inputs.index(this);

                if(index + 1 == inputs.size()) {
                    var rows = row.parent().find('.bo-row');
                    var rowIndex = rows.index(row);

                    if(rowIndex + 1 == rows.size()) {
                        var bo = row.data('bo');
                        bo.addRow();
                        bo.node.find('.bo-row:last .bo-input:first').focus();
                    } else {
                        rows.eq(rowIndex + 1).find('.bo-input:first').focus();
                    }
                } else {
                    inputs.eq(index + 1).focus();
                }

                return false;
            }
        },

        init: function() {
            this.list = this.node.find('.bo-list');
            this.addButton = this.node.find('.bo-add');
            this.head = this.node.find('.bo-head');
            this.addButton.click($.proxy(this._addButtonClick, this));
            this.setHead();
            this.setDummy();
            this.list.sortable();
            // this.list.disableSelection();
        }
    };

    $.fn.bookOptions = function(options) {
        var node = this;

        if(options === undefined) {
            options = {};
        }

        if(!node.data('bookOptions')) {
            var bo = $.extend(true, {}, $.bookOptions); // clone
            var bo = $.extend(bo, options);
            bo.node = node;

            bo.init();
            
            node.data('bookOptions', bo);
        }

        return node.data('bookOptions');
    }
})(jQuery);