(function($) {
    $.bookOptionsField = {
        node: null,
        list: null,
        addButton: null,
        name: '',
        index: 0,

        createRow: function() {
            var row = $(
                '<div class="bo-row"><div class="context">' +
                    '<div class="bo-col bo-col-big"><input type="text" class="input-text bo-input bo-title" name="' + this.name + '[' + this.index + '][title]" /></div>' +
                    '<div class="bo-col bo-col-small"><input type="text" class="input-text bo-input bo-key" name="' + this.name + '[' + this.index + '][key]" /></div>' +
                    '<div class="bo-col ui-icons ui-widget icon-collection">' +
                        '<a href="#" class="bo-up ui-state-default ui-corner-all" title="Вверх"><span class="ui-icon ui-icon-triangle-1-n"></span></a>' +
                        '<a href="#" class="bo-down ui-state-default ui-corner-all" title="Вниз"><span class="ui-icon ui-icon-triangle-1-s"></span></a>' +
                        '<a href="#" class="bo-delete ui-state-error ui-corner-all" title="Удалить"><span class="ui-icon ui-icon-closethick"></span></a>' +
                    '</div>' +

                    '<input type="hidden" class="bo-id" name="' + this.name + '[' + this.index + '][id]" />' +
                '</div></div>'
            );

            row.find('.bo-up').click(this._rowUpClick);
            row.find('.bo-down').click(this._rowDownClick);
            row.find('.bo-delete').click(this._rowDeleteClick);

            this.index++;
            return row;
        },

        addRow: function(data) {
            if(data === undefined) {
                data = {
                    id: '',
                    title: ''
                };
            }

            var row = this.createRow();
            row.find('.bo-key').val(data.key);
            row.find('.bo-title').val(data.title);
            row.find('.bo-id').val(data.name);

            this.list.append(row);
        },

        setHead: function() {
            var head = $(
            '<div class="context bo-head">' +
                '<div class="bo-col bo-col-big">Название</div>' +
                '<div class="bo-col bo-col-small">Ключ</div>' +
            '</div>');

            this.head.append(head);
        },

        _addButtonClick: function() {
            this.addRow();
            return false;
        },

        _rowDeleteClick: function() {
            var row = $(this).closest('.bo-row');
            row.remove();
            return false;
        },

        _rowUpClick: function() {
            var row = $(this).closest('.bo-row');
            var prev = row.prev('.bo-row');

            if(prev.size() == 0)
                return false;

            prev.before(row);

            return false;
        },

        _rowDownClick: function() {
            var row = $(this).closest('.bo-row');
            var next = row.next('.bo-row');

            if(next.size() == 0)
                return false;

            next.after(row);

            return false;
        },

        init: function() {
            this.list = this.node.find('.bo-list');
            this.head = this.node.find('.bo-head');
            this.addButton = this.node.find('.bo-add');

            this.addButton.click($.proxy(this._addButtonClick, this));
            this.setHead();
        }
    };

    $.fn.bookOptionsField = function(options) {
        var node = this;

        if(options === undefined) {
            options = {};
        }

        if(!node.data('bookOptionsField')) {
            var bo = $.extend(true, {}, $.bookOptionsField); // clone
            var bo = $.extend(bo, options);
            bo.node = node;

            bo.init();
            
            node.data('bookOptionsField', bo);
        }

        return node.data('bookOptionsField');
    }
})(jQuery);