#!/bin/bash

CRON_RUN="wc/wc_cron/run.php" 
TAGS="default" 
SITE_ID="each"

# process priority level(0=normal, 19=slowest)
PRIORITY=10

# full directory path of document_root ../www
DOCUMENT_ROOT=$(cd "$(dirname $0)";cd ../www;pwd)

# current date and time
DAY=$(date "+%d")
MONTH=$(date "+%m")
YEAR=$(date "+%Y")
HOUR=$(date "+%H")
MINUTE=$(date "+%M")

# log directory relative to document_root
LOG_DIR="application/logs/cron/default/${YEAR}/${MONTH}/${DAY}"

# create log dir tree if one doesn't exist
[ -d  "${DOCUMENT_ROOT}/${LOG_DIR}" ] || mkdir -p "${DOCUMENT_ROOT}/${LOG_DIR}"

# change current dir to document_root
cd "${DOCUMENT_ROOT}"
# launch PHP cron jobs with stdout and stderr redirected to log file
/usr/bin/nice -n $PRIORITY /usr/bin/php "${DOCUMENT_ROOT}/${CRON_RUN}" -t "${TAGS}" -s "${SITE_ID}" >> "${DOCUMENT_ROOT}/${LOG_DIR}/${HOUR}_${MINUTE}.log" 2>&1

exit 0

