CREATE TABLE `crosssite_channels_outbox` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` bigint(20) unsigned NOT NULL,
  `dataset_name` varchar(255) NOT NULL,
  `remotes` text NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `site_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

CREATE TABLE `crosssite_inbox` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `datetime` datetime NOT NULL,
  `site_id` bigint(20) NOT NULL,
  `crosssite_id` varchar(255) NOT NULL,
  `factory_key` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

CREATE TABLE `crosssite_outbox` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `datetime` datetime NOT NULL,
  `crosssite_id` varchar(255) NOT NULL,
  `factory_key` varchar(255) NOT NULL,
  `site_id` bigint(20) NOT NULL,
  `crosssite_channel_id` bigint(20) NOT NULL,
  `remote_id` bigint(20) NOT NULL,
  `remote_parent_id` bigint(20) NOT NULL,
  `remote_site_id` bigint(20) NOT NULL,
  `remote_site` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

CREATE TABLE `crosssite_sites` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `host` varchar(255) NOT NULL,
  `token` varbinary(255) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `index` bigint(20) unsigned NOT NULL,
  `site_id` bigint(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;
