(function ($) {
    $.fileuploadObject = {

        /* Default functionality */
        uploadUrl:null,
        browseFromServerUrl:null,
        deleteUrl:null,
        uploadDir: null,
        uploadDirConfirm: null,
        inputContainer:null,
        valueContainer:null,
        params:{},
        input:null,
        loader: null,
        file: {},
        resizes: {},
        forceLinkView: false, /* всегда отображать как загруженный файл */

        init:function () {},

        internalInit:function (input) {
            this.input = $(input);

            if (this.inputContainer === null)
                this.inputContainer = this.input.parent();
            else
                this.inputContainer = $(this.inputContainer);

            if (this.valueContainer === null)
                this.valueContainer = this.input.parent();
            else
                this.valueContainer = $(this.valueContainer);

            this.initInputUpload();

            if(this.dnd)
                this.initDndUpload();

            if(this.crop)
                this.initCrop();

            if(this.file && this.file.id)
                this.setValue(this.file);

            if(this.browseFromServerUrl)
                this.initBrowseFromServer();

            return true;
        },

        initInputUpload:function () {
            this.input.change($.proxy(this.inputOnChange, this));
            this.loader = $('<span class="loading-inline inactive fileupload-loading">Загрузка файла...</span>');
            this.input.after(this.loader);

            var form = this.input.parent('form');
            form.submit($.proxy(function () {
                this.input.attr('name', '');
            }, this));
        },

        initDelete:function () {
            var deleteNode = this.valueContainer.find('.delete');
            var onClick = $.proxy(function (e) {
                if (confirm('Действительно удалить файл?')) {
                    this.deleteFile();
                }

                e.stopPropagation();
                return false;
            }, this);

            deleteNode.click(onClick);
        },

        initBrowseFromServer:function ()
        {
            if (typeof(mcFileManager) == 'undefined')
            {
                return;
            }

            mcFileManager.init();

            var buttons = $('<div class="browse-from-server-wrapper ui-icons ui-widget icon-collection"></div>');
            var browseFromServerNode = $('<a href="#" class="browse-from-server ui-widget-content ui-corner-all noaddress"><span class="ui-icon ui-icon-folder-collapsed"></span><span class="ui-icon-text">Выбрать на сервере...</span></a>');
            buttons.append(browseFromServerNode);
            this.input.after(buttons);

            var onClick = $.proxy(function(){
                mcFileManager.open(null, null, null, callback);
                return false;
            }, this);

            var callback = $.proxy(function(file_url) {
                this.loaderShow();
                var data = this.ajaxData();
                data.file_url = file_url;

                $.ajax({
                    url:this.browseFromServerUrl,
                    type:'post',
                    data: data,
                    error:$.proxy(this.ajaxOnFailture, this),
                    success:$.proxy(this.ajaxOnSuccess, this)
                });

                return false;
            }, this);

            browseFromServerNode.click(onClick);
        },

        initRegenerate:function () {
            if(!this.regenerateUrl)
                return;

            var container = this.valueContainer;
            var node = container.find('.regenerate');
            var url = this.regenerateUrl;
            var onClick = $.proxy(function (e) {
                if (confirm('Пересоздать дополнительные размеры снова?')) {
                    $.ajax({
                        type:'post',
                        url:url,
                        method:'post',
                        data: this.ajaxData(),
                        error:$.proxy(this.ajaxOnFailture, this),
                        success:$.proxy(this.ajaxOnSuccess, this)
                    });
                }

                e.stopPropagation();
                return false;
            }, this);

            node.click(onClick);
        },

        urlNocache:function (url) {
            if (url.indexOf('?') !== -1)
                url += '&';
            else
                url += '?';

            url += '_rnd=' + Math.random();
            return url;
        },

        setValue:function (file) {
            this.file = file;

            if (file.isImage && !this.forceLinkView)
                var container = this.getImageValueNode();
            else
                var container = this.getFileValueNode();

            var fileId = $('<input type="hidden" class="id" name="' + this.input.attr('name') + '" value="' + file.id + '" />');

            this.valueContainer.html('');
            this.valueContainer.append(fileId).append(container);
            this.initDelete();
            this.initRegenerate();
        },

        getImageValueNode:function () {
            var container = $('<div class="uploaded-file" id="uploaded-file-' + this.file.id + '"></div>');
            var clearfix = $('<div class="context"></div>');
            var resize = this.getImageValueResizeNode('admin_default', 'Оригинал', this.file);
            clearfix.append(resize);

            for (var key in this.resizes) {
                var _resize = this.resizes[key];
                if(resize = this.getImageValueResizeNode(_resize.key, _resize.title)) {
                    clearfix.append(resize);
                }
            }

            var buttons = $('<div class="ui-icons ui-widget icon-collection"></div>');

            if(this.regenerateUrl && this.file.isImage && this.resizes)
            {
                buttons.append('<a href="#" class="regenerate ui-state-default ui-corner-all noaddress"><span class="ui-icon ui-icon-refresh"></span><span class="ui-icon-text">Перегенерировать размеры</span></a>');
            }

            if ( this.deleteUrl )
            {
                buttons.append('<a href="#" class="delete ui-state-error ui-corner-all noaddress"><span class="ui-icon ui-icon-closethick"></span><span class="ui-icon-text">Удалить</span></a>');
            }

            clearfix.append(buttons);
            return container.append(clearfix);
        },

        getImageValueResizeNode:function(key, title, assignWith) {
            if(key) {
                if (!this.file.children)
                    return;

                var found = false;
                for (var i = 0; i < this.file.children.length; i++) {
                    var resize = this.file.children[i];

                    if (resize.key == key) {
                        found = true;
                        break;
                    }
                }

                if(!found)
                    return false;
            } else {
                resize = this.file; // original
            }

            var container = $('<div class="image-resize"></div>');
            var image = $('<img src="' + this.urlNocache(resize.url) + '" />');
            image.data('fileupload', this);
            image.data('file', assignWith ? assignWith : resize);

            if(this.crop) {
                image.css('cursor', 'pointer');
                image.click(function(){
                    var image = $(this);
                    var file = image.data('file');
                    var fileupload = image.data('fileupload');

                    fileupload.cropOpen(file);
                });
            }

            if(!title)
                title = resize.width + 'x' + resize.height;

            return container.append(image).append('<span class="title">' + title + '</span>');
        },

        getFileValueNode:function () {
            var file = this.file;
            var container = $('<div class="uploaded-file" id="uploaded-file-' + file.id + '"></div>');
            var clearfix = $('<div class="context"></div>');
            var buttons = $('<div class="ui-icons ui-widget icon-collection"></div>');

            if ( this.deleteUrl )
            {
                buttons.append('<a href="#" class="delete ui-state-error ui-corner-all noaddress"><span class="ui-icon ui-icon-closethick"></span><span class="ui-icon-text">Удалить</span></a>');
            }

            clearfix.append('<a href="' + file.url + '" class="external" target="_blank">' + file.url + '</a>').append(buttons);
            return container.append(clearfix);
        },

        inputOnChange:function () {
            var oldIE = $.browser.msie && $.browser.version < 10;

            if(oldIE)
            {
                var form = this.input.closest('form');
                this._submitInputForm(form);
            }
            else
            {
                var form = $('<form enctype="multipart/form-data"></form>');
                form.append(this.input);
                form.appendTo(document.body);
                this._submitInputForm(form);
                this.loader.before(this.input);
                form.remove();
            }
        },

        _submitInputForm: function(form)
        {
            this.loaderShow();

            form.ajaxSubmit({
                url:this.uploadUrl,
                type:'post',
                data:this.ajaxData(),
                error:$.proxy(this.ajaxOnFailture, this),
                success:$.proxy(this.ajaxOnSuccess, this)
            });
        },

        ajaxData: function() {
            var data = {input_name: this.input.attr('name')};

            if(this.file)
            {
                data.file_id = this.file.id;
            }

            if(this.uploadDir)
            {
                data.upload_dir = this.uploadDir;
                data.upload_dir_confirm = this.uploadDirConfirm;
            }

            data.resizes = JSON.stringify(this.resizes);

            data = $.extend(data, this.params);
            return data;
        },

        ajaxOnFailture:function (response) {
            this.loaderHide();
            this.input.val('');
            document.admin.error('Ошибка', response);
        },

        ajaxOnSuccess:function (response) {
            this.loaderHide();
            this.input.val('');

            var jsonData = $.parseJSON(response);
            document.admin.handleMessages(jsonData.messages);

            if(jsonData.success)
                this.setValue(jsonData.file);
        },

        loaderShow: function(){
            this.valueContainer.css({ opacity: 0.5 });
            this.loader.show();
        },

        loaderHide: function(){
            this.valueContainer.css({ opacity: 1 });
            this.loader.hide();
        },

        deleteFile: function() {
            $.ajax({
                type:'post',
                url:this.deleteUrl,
                method:'post',
                data: this.ajaxData(),
                failure:function () {
                    document.admin.error('Ошибка при удалении файла!')
                }
            });

            this.valueContainer.html('');
        },




        /* Drag and drop functionality */

        dnd: true,
        dropZone:null,
        dndDragKey: null,

        initDndUpload:function () {
            if (typeof(window.FileReader) == 'undefined')
                return false;

            this.dropZone = $('<div class="fileupload-dropzone">'
                            + '<span class="drop-text">Поместите файл сюда</span>'
                            + '</div>');

            this.inputContainer.append(this.dropZone);

            if (this.dropZone === null)
                this.dropZone = this.input.parent().find('.fileupload-dropzone');

            $(document).bind('dragover', $.proxy(this.onDragStart, this));
            $(document).bind('dragleave', $.proxy(this.onDragEnd, this));
            $(document).bind('drop', $.proxy(this.onDropBody, this));
            this.dropZone.bind('dragover', $.proxy(this.onDragOver, this));
            this.dropZone.bind('dragleave', $.proxy(this.onDragLeave, this));
            this.dropZone[0].ondrop = $.proxy(this.onDrop, this);

            document.admin.unload($.proxy(function(){
                $(document).unbind('dragover');
                $(document).unbind('dragleave');
                $(document).unbind('drop');
                this.dropZone.unbind('dragover');
                this.dropZone.unbind('dragleave');
            }, this));
        },

        updateDragKey:function () {
            var dragKey = Math.round(Math.random() * 100000);
            this.dndDragKey = dragKey;
            return dragKey;
        },

        showDragLoading:function () {
            this.valueContainer.css({ opacity: 0.5 });
        },

        onDropBody:function (e) {
            e.preventDefault();
            this.dropZone.removeClass('fileupload-hover');
            this.dropZone.hide();
        },

        hideDragLoading:function () {
            this.valueContainer.css({ opacity: 1 });
            this.dropZone.find('.drop-text').show();
            this.dropZone.removeClass('fileupload-loading');
        },

        onDragStart:function (e) {
            this.updateDragKey();
            this.hideDragLoading();
            this.dropZone.show();

            return false;
        },

        onDragEnd:function (e) {
            var dragKey = this.updateDragKey();

            setTimeout($.proxy(function () {
                if (dragKey === this.dndDragKey) {
                    this.dropZone.hide();
                }
            }, this), 300);

            return false;
        },

        onDragOver:function () {
            this.updateDragKey();
            this.dropZone.addClass('fileupload-hover');
            return false;
        },

        onDragLeave:function (e) {
            this.updateDragKey();
            this.dropZone.removeClass('fileupload-hover');
            return false;

        },

        onDrop:function (event) {
            event.preventDefault();

            this.loaderShow();
            this.dropZone.removeClass('fileupload-hover');
            this.dropZone.hide();

            var file = event.dataTransfer.files[0];
            var ajaxData = this.ajaxData();
            var formData = new FormData;
            formData.append(this.input.attr('name'), file);

            for (var paramName in ajaxData) {
                formData.append(paramName, ajaxData[paramName]);
            }

            var xhr = new XMLHttpRequest();
            var fileupload = this;
            xhr.upload.addEventListener('progress', $.proxy(this.dropUploadProgress, this), false);
            xhr.onreadystatechange = function stateChange(e) {
                if (e.target.readyState == 4) {
                    fileupload.onDragEnd();

                    if (e.target.status == 200)
                        fileupload.ajaxOnSuccess(this.responseText);
                    else
                        fileupload.ajaxOnFailture(this.responseText);
                }
            };

            xhr.open('POST', this.uploadUrl);
            xhr.send(formData)
        },

        dropUploadProgress:function (e) {},



        /* Crop functionality */

        crop: true,
        cropUrl: null,
        regenerateUrl: null,

        initCrop:function () {},

        cropOpen: function(file){
            var original = this.file;
            var w = parseInt(original.width);
            var h = parseInt(original.height);
            var cropRatio = 1;
            var maxW = $('body').width() - 100;

            if(w > maxW)
            {
                cropRatio = maxW / w;
                w = maxW;
                h = h * cropRatio;
            }

            var image = $('<img src="' + original.url + '" id="crop-image" />').width(w);
            var imageContainer = $('<div id="crop-image-container"></div>');

            image
                .data('fileupload', this)
                .data('file', file)
                .data('cropArea', {})
                .data('cropRatio', cropRatio);

            imageContainer.width(w).height(h).append(image);

            // buttons
            var submit = $('<input type="button" value="Сохранить" class="button-1 submit" />');
            var cancel = $('<input type="button" value="Отмена" class="button-1 cancel" />');
            var reset = $('<input type="button" value="Сброс" class="button-1 cancel" style="float: left; margin-left: 0;" />');
            var buttons = $('<div class="buttons"></div>');
            reset.click($.proxy(this.cropReset, this));
            submit.click($.proxy(this.cropSubmit, this));
            cancel.click($.proxy(this.cropCancel, this));
            buttons.append(reset).append(submit);

            if(0 && !$.browser.msie) {
                var leftRotate = $('<input type="button" value="+90&ordm;" class="button-1" />');
                var rightRotate = $('<input type="button" value="-90&ordm;" class="button-1" />');

                leftRotate.click($.proxy(this.cropRotateLeft, this));
                rightRotate.click($.proxy(this.cropRotateRight, this));

                buttons.append(leftRotate).append(rightRotate);
            }

            buttons.append(cancel);

            // show crop window
            var overlayNode = $('<div class="overlay-window"></div>');
            overlayNode.append(imageContainer).append(buttons);

            document.overlay.show(overlayNode);

            image.load($.proxy(function () {
                this.cropAreaInit();
            }, this));

            document.overlay.node.one('hidden', $.proxy(function () {
                this.cropAreaRemove();
                overlayNode.remove();
            }, this));

            var cropArea = null;

            if(file.isParent)
            {
                for (var i = 0; i < file.children.length; i++) {
                    var resize = file.children[i];

                    if (resize.key == 'crop') {
                        cropArea = resize.settings.crop.area;
                        break;
                    }
                }
            }
            else if( file.settings.crop && file.settings.crop.area )
            {
                var cropArea = file.settings.crop.area;
            }

            if(cropArea) {
                var x = cropArea.x * cropRatio;
                var y = cropArea.y * cropRatio;
                var w = cropArea.w * cropRatio;
                var h = cropArea.h * cropRatio;

                var api = imageContainer.imgAreaSelect({instance: true, parent: '#crop-image-container'});
                api.setSelection(x, y, x+w, y+h);
                api.setOptions({ show: true });
                api.update();

                image.data('cropArea', {
                    x: x,
                    y: y,
                    w: w,
                    h: h
                });
            }

            return false;
        },

        cropSubmit:function () {
            var data = this.ajaxData();
            var image = $('#crop-image');
            var cropArea = image.data('cropArea');
            var cropRatio = image.data('cropRatio');
            var file = image.data('file');

            data.file_id = file.id;

            if(cropArea.x == undefined)
                data.area = {};
            else
                data.area = cropArea;

            data.area.x /= cropRatio;
            data.area.y /= cropRatio;
            data.area.w /= cropRatio;
            data.area.h /= cropRatio;

            $.ajax({
                type:'post',
                url:this.cropUrl,
                data: data,
                success:$.proxy(this.cropAjaxSuccess, this),
                failure:$.proxy(this.cropAjaxFailure, this)
            });
        },

        cropReset:function () {
            var container = $('#crop-image-container');
            var image = $('#crop-image');

            var api = container.imgAreaSelect({instance: true});
            api.cancelSelection();

            image.data('cropArea', {
                x:0,
                y:0,
                w:0,
                h:0
            });
        },

        cropCancel:function () {
            document.overlay.hide();
        },

        cropAreaInit: function() {
            var image = $('#crop-image');
            var file = image.data('file');
            var fileupload = image.data('fileupload');
            var aspectRatio;

            if(fileupload.resizes[ file.key ]) {
                var resize = fileupload.resizes[ file.key ];

                if(resize.size.indexOf('xx') !== -1) {
                    var sizes = resize.size.split('xx');
                    var w = parseInt(sizes[0]);
                    var h = parseInt(sizes[1]);
                    aspectRatio = w + ':' + h;
                }
            }

            $('#crop-image-container').imgAreaSelect({
                handles: true,
                aspectRatio: aspectRatio,
                parent: '#crop-image-container',
                onSelectEnd: $.proxy(function (containter, selection) {
                    $('#crop-image').data('cropArea', {
                        x: selection.x1,
                        y: selection.y1,
                        w: selection.width,
                        h: selection.height
                    });
                }, this)
            });
        },

        cropAreaRemove: function() {
            $('#crop-image-container').imgAreaSelect({remove: true});
        },

        cropAjaxSuccess:function (response) {
            var jsonData = $.parseJSON(response);
            document.admin.handleMessages(jsonData.messages);
            this.setValue(jsonData.file);
            document.overlay.hide();
        },

        cropAjaxFailure:function (response) {
            document.admin.error('Ошибка', response);
        }
    };

    $.fn.fileupload = function (options) {
        var input = this;

        if (!input.data('fileupload')) {
            var fileupload = $.extend(true, {}, $.fileuploadObject); // clone
            var fileupload = $.extend(fileupload, options);

            fileupload.internalInit(input);
            fileupload.init();
            input.data('fileupload', fileupload);
        }

        return input.data('fileupload');
    }
})(jQuery);
