SET statement_timeout = 0;
SET lock_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET default_tablespace = '';
SET default_with_oids = false;

CREATE TABLE search_index (
    id bigint NOT NULL,
    class character varying(255),
    class_id bigint,
    class_parent_id bigint,
    factory_key character varying(255),
    "group" character varying(255),
    datetime timestamp without time zone,
    image bigint,
    title text,
    description text,
    text text,
    url text,
    site_id bigint,
    _created timestamp without time zone,
    _updated timestamp without time zone,
    _proccess_id bigint,
    title_tsv tsvector,
    description_tsv tsvector,
    text_tsv tsvector,
    CONSTRAINT search_index__proccess_id_check CHECK ((_proccess_id >= 0)),
    CONSTRAINT search_index_image_check CHECK ((image >= 0))
);

CREATE SEQUENCE search_index_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;

ALTER SEQUENCE search_index_id_seq OWNED BY search_index.id;
ALTER TABLE ONLY search_index ALTER COLUMN id SET DEFAULT nextval('search_index_id_seq'::regclass);
ALTER TABLE ONLY search_index ADD CONSTRAINT search_index_pkey PRIMARY KEY (id);
CREATE INDEX search_index__proccess_id_idx ON search_index USING btree (_proccess_id);
CREATE INDEX search_index_group_idx ON search_index USING btree ("group");

CREATE FUNCTION update_search_index_tsvector() RETURNS trigger
    LANGUAGE plpgsql
    AS $$BEGIN
  NEW.title_tsv= to_tsvector( NEW.title ) ;
  NEW.description_tsv= to_tsvector( NEW.description ) ;
  NEW.text_tsv= to_tsvector( NEW.text ) ;
  RETURN NEW;
END;$$;

CREATE TRIGGER update_search_index_tsvector BEFORE INSERT OR UPDATE ON search_index FOR EACH ROW EXECUTE PROCEDURE update_search_index_tsvector();