CREATE TABLE IF NOT EXISTS `datasets` (
  `name` varchar(32) NOT NULL DEFAULT '',
  `type` enum('document','folder') NOT NULL DEFAULT 'document',
  `title` varchar(128) DEFAULT NULL,
  `contain_documents` enum('all','none','custom') NOT NULL DEFAULT 'all',
  `contain_folders` enum('all','none','custom') NOT NULL DEFAULT 'all',
  `child_datasets` text NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`name`),
  UNIQUE KEY `sysname` (`name`),
  KEY `enabled` (`enabled`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Datasets (objetcs) declaration';

CREATE TABLE IF NOT EXISTS `dataset_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(32) DEFAULT NULL,
  `label` varchar(128) DEFAULT NULL,
  `index` bigint(20) NOT NULL,
  `dataset_name` varchar(128) NOT NULL,
  `type` varchar(255) NOT NULL,
  `settings` text NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `enabled` (`enabled`),
  KEY `sysname` (`key`),
  KEY `dataset_name` (`dataset_name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;


CREATE TABLE IF NOT EXISTS `dataset_sync` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `host` varchar(255) NOT NULL,
  `token` varbinary(255) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `index` bigint(20) unsigned NOT NULL,
  `site_id` bigint(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;


CREATE TABLE IF NOT EXISTS `links` (
  `item_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `dataset_name` varchar(128) NOT NULL,
  `name` varchar(255) NOT NULL,
  `parent_id` bigint(10) unsigned NOT NULL,
  `index` bigint(20) NOT NULL,
  `alias` varchar(255) NOT NULL,
  `site_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `dev` tinyint(1) NOT NULL,
  PRIMARY KEY (`item_id`),
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Main data structure' AUTO_INCREMENT=1 ;

ALTER TABLE  `links` ADD INDEX (  `parent_id` ,  `dataset_name` ,  `enabled` ,  `site_id` ) ;


CREATE TABLE IF NOT EXISTS `metas` (
  `item_id` bigint(20) NOT NULL,
  `site_id` bigint(20) NOT NULL,
  `title` text NOT NULL,
  `description` text NOT NULL,
  `keywords` text NOT NULL,
  PRIMARY KEY (`item_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `user_group_structure_item_roles` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `item_id` bigint(20) NOT NULL,
  `group_id` bigint(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `structure_item_id` (`item_id`,`group_id`,`key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `statuses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `datetime` datetime NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `item_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

ALTER TABLE  `statuses` ADD INDEX (  `item_id` );
ALTER TABLE  `statuses` ADD INDEX (  `datetime` );