CREATE TABLE IF NOT EXISTS `folder_page` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `text` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `document_file` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `file` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `document_image` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `file` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `document_news` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `datetime` datetime NOT NULL,
  `description` text NOT NULL,
  `text` text NOT NULL,
  `image` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `document_text` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `text` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `document_video` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `file` bigint(20) unsigned NOT NULL,
  `image` bigint(20) unsigned NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `folder_link` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `url` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `datasets` (`name`, `type`, `title`, `contain_documents`, `contain_folders`, `child_datasets`, `enabled`) VALUES
('folder_page', 'folder', 'Страница', 'custom', 'all', 'a:3:{i:0;s:14:"document_image";i:1;s:13:"document_file";i:2;s:14:"document_video";}', 1),
('document_text', 'document', 'Текстовый документ', 'custom', 'all', 'a:3:{i:0;s:14:"document_image";i:1;s:13:"document_file";i:2;s:14:"document_video";}', 1),
('document_file', 'document', 'Файл', 'none', 'all', 'a:0:{}', 1),
('document_image', 'document', 'Изображение', 'none', 'all', 'a:0:{}', 1),
('document_video', 'document', 'Видео', 'none', 'all', 'a:0:{}', 1),
('folder_link', 'folder', 'Ссылка', 'none', 'all', 'a:0:{}', 1);


INSERT INTO `dataset_fields` (`key`, `label`, `index`, `dataset_name`, `type`, `settings`, `enabled`) VALUES
('text', 'Текст', 1, 'folder_page', 'wysiwyg', 'a:4:{s:4:"form";a:4:{s:4:"note";s:0:"";s:8:"required";N;s:5:"basic";N;s:6:"format";N;}s:4:"list";a:2:{s:4:"show";N;s:5:"order";N;}s:6:"filter";a:1:{s:4:"show";N;}s:6:"search";a:1:{s:3:"key";s:4:"text";}}', 1),
('alias', 'Alias', 0, 'folder_page', 'alias', 'a:4:{s:4:"form";a:2:{s:4:"note";s:0:"";s:8:"required";s:0:"";}s:4:"list";a:2:{s:4:"show";N;s:5:"order";N;}s:6:"filter";a:1:{s:4:"show";N;}s:6:"search";a:1:{s:3:"key";s:21:"(не выбрано)";}}', 2),

('text', 'Текст', 1, 'document_text', 'wysiwyg', 'a:4:{s:4:"form";a:2:{s:4:"note";s:0:"";s:8:"required";N;}s:4:"list";a:2:{s:4:"show";N;s:5:"order";N;}s:6:"filter";a:1:{s:4:"show";N;}s:6:"search";a:1:{s:3:"key";s:4:"text";}}', 1),

('name', 'Название', 0, 'document_file', 'text', 'a:4:{s:4:"form";a:3:{s:4:"note";s:0:"";s:8:"required";s:0:"";s:6:"format";s:3:"any";}s:4:"list";a:2:{s:4:"show";s:0:"";s:5:"order";s:0:"";}s:6:"filter";a:1:{s:4:"show";s:0:"";}s:6:"search";a:1:{s:3:"key";s:5:"title";}}', 1),
('file', 'Файл', 1, 'document_file', 'file', 'a:5:{s:4:"form";a:2:{s:4:"note";s:0:"";s:8:"required";s:1:"1";}s:4:"list";a:2:{s:4:"show";s:0:"";s:5:"order";s:0:"";}s:6:"filter";a:1:{s:4:"show";s:0:"";}s:6:"search";a:1:{s:3:"key";s:21:"(не выбрано)";}s:6:"upload";a:4:{s:6:"subdir";s:13:"document_file";s:12:"filesize_max";s:0:"";s:11:"ext_allowed";a:12:{i:0;s:3:"doc";i:1;s:4:"docx";i:2;s:3:"ods";i:3;s:3:"odt";i:4;s:3:"pdf";i:5;s:3:"rar";i:6;s:3:"rtf";i:7;s:3:"txt";i:8;s:2:"un";i:9;s:3:"xls";i:10;s:4:"xlsx";i:11;s:3:"zip";}s:12:"mime_allowed";a:0:{}}}', 1),

('name', 'Название', 0, 'document_image', 'text', 'a:4:{s:4:"form";a:3:{s:4:"note";s:0:"";s:8:"required";s:0:"";s:6:"format";N;}s:4:"list";a:2:{s:4:"show";N;s:5:"order";N;}s:6:"filter";a:1:{s:4:"show";N;}s:6:"search";a:1:{s:3:"key";s:5:"title";}}', 1),
('file', 'Файл', 3, 'document_image', 'image', 'a:5:{s:4:"form";a:2:{s:4:"note";s:0:"";s:8:"required";s:1:"1";}s:4:"list";a:2:{s:4:"show";s:1:"1";s:5:"order";s:0:"";}s:6:"filter";a:1:{s:4:"show";s:0:"";}s:6:"search";a:1:{s:3:"key";s:5:"image";}s:6:"upload";a:5:{s:6:"subdir";s:15:"document_images";s:12:"filesize_max";s:0:"";s:11:"ext_allowed";a:0:{}s:12:"mime_allowed";a:0:{}s:15:"formats_allowed";a:0:{}}}', 1),

('name', 'Название', 0, 'document_video', 'text', 'a:4:{s:4:"form";a:3:{s:4:"note";s:0:"";s:8:"required";s:0:"";s:6:"format";s:3:"any";}s:4:"list";a:2:{s:4:"show";s:1:"1";s:5:"order";s:1:"1";}s:6:"filter";a:1:{s:4:"show";s:1:"1";}s:6:"search";a:1:{s:3:"key";s:5:"title";}}', 1),
('file', 'Файл', 1, 'document_video', 'file', 'a:5:{s:4:"form";a:2:{s:4:"note";s:0:"";s:8:"required";s:1:"1";}s:4:"list";a:2:{s:4:"show";s:0:"";s:5:"order";s:0:"";}s:6:"filter";a:1:{s:4:"show";s:0:"";}s:6:"search";a:1:{s:3:"key";s:0:"";}s:6:"upload";a:4:{s:6:"subdir";s:14:"document_video";s:12:"filesize_max";s:0:"";s:11:"ext_allowed";a:0:{}s:12:"mime_allowed";a:7:{i:0;s:3:"swf";i:1;s:3:"flw";i:2;s:3:"avi";i:3;s:3:"wmv";i:4;s:3:"3gp";i:5;s:3:"mp4";i:6;s:5:"mpeg4";}}}', 1),
('image', 'Изображение', 2, 'document_video', 'image', 'a:5:{s:4:"form";a:2:{s:4:"note";s:0:"";s:8:"required";s:0:"";}s:4:"list";a:2:{s:4:"show";s:1:"1";s:5:"order";s:0:"";}s:6:"filter";a:1:{s:4:"show";s:0:"";}s:6:"search";a:1:{s:3:"key";s:5:"image";}s:6:"upload";a:5:{s:6:"subdir";s:20:"document_video/image";s:12:"filesize_max";s:0:"";s:11:"ext_allowed";a:0:{}s:12:"mime_allowed";a:0:{}s:15:"formats_allowed";a:0:{}}}', 1),
('description', 'Описание', 5, 'document_video', 'wysiwyg', 'a:4:{s:4:"form";a:3:{s:4:"note";s:0:"";s:8:"required";s:0:"";s:5:"basic";s:5:"basic";}s:4:"list";a:2:{s:4:"show";s:0:"";s:5:"order";s:0:"";}s:6:"filter";a:1:{s:4:"show";s:1:"1";}s:6:"search";a:1:{s:3:"key";s:11:"description";}}', 1),

('url', 'URL', 1, 'folder_link', 'text', 'a:4:{s:4:"form";a:3:{s:4:"note";s:0:"";s:8:"required";s:1:"1";s:6:"format";N;}s:4:"list";a:2:{s:4:"show";N;s:5:"order";N;}s:6:"filter";a:1:{s:4:"show";N;}s:6:"search";a:1:{s:3:"key";s:0:"";}}', 1),
('name', 'Название', 0, 'folder_link', 'text', 'a:4:{s:4:"form";a:3:{s:4:"note";s:0:"";s:8:"required";s:1:"1";s:6:"format";N;}s:4:"list";a:2:{s:4:"show";N;s:5:"order";N;}s:6:"filter";a:1:{s:4:"show";N;}s:6:"search";a:1:{s:3:"key";s:5:"title";}}', 1);
