(function($) {
    $.alias = {
        maxLen: 40,
        ignoreKeyCodes: [
            35, 36, // home, end
            37, 38, 39, 40, // arrows
            9, // tab, shift
            16, 17, 18, // crtl, shift, alt
            20, // caps lock
            8 //backspace
        ],



        _ru2en: {
            ru_str : "АБВГДЕЁЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдеёжзийклмнопрстуфхцчшщъыьэюя",
            en_str : ['A','B','V','G','D','E','JO','ZH','Z','I','J','K','L','M','N','O','P','R','S','T',
                'U','F','H','C','CH','SH','SHH','','I','','JE','JU',
                'JA','a','b','v','g','d','e','jo','zh','z','i','j','k','l','m','n','o','p','r','s','t','u','f',
                'h','c','ch','sh','shh','','i','','je','ju','ja'],
            translit : function(org_str) {
                var tmp_str = "";
                for (var i = 0, l = org_str.length; i < l; i++) {
                    var s = org_str.charAt(i), n = this.ru_str.indexOf(s);
                    if (n >= 0) {
                        tmp_str += this.en_str[n];
                    }
                    else {
                        tmp_str += s;
                    }
                }
                return tmp_str;
            }
        },

        string: function(value, aliasInputMode) {
            value = $.alias._ru2en.translit(value);
            value = value.replace(/[^a-z0-9_\./]/ig, '_');
            value = value.replace(/_+/g, '_');

            if (aliasInputMode !== true) {
                value = value.replace(/_+$/g, '');
            }

            value = value.replace(/^_+/g, '');

            if(value.length > $.alias.maxLen) {
                value = value.substring(0, $.alias.maxLen).replace(/_+$/g, '');
            }


            return value;
        },
    
        init: function() {
            var aliasInput = $(this);
            var textSelector = aliasInput.attr('rel');

            aliasInput.keyup(function(e) {
                if($.inArray(e.keyCode, $.alias.ignoreKeyCodes) > -1)
                    return true;

                var value = $.alias.string($(this).attr('value'), true);
                $(this).attr('value', value);
            });

            aliasInput.blur(function() {
                var value = $.alias.string($(this).attr('value'));
                $(this).attr('value', value);
            });

            if(textSelector) {
                var nameInput = $(aliasInput.attr('rel'));

                nameInput.keyup(function() {
                    var value = $.alias.string($(this).attr('value'));
                    aliasInput.attr('value', value);
                });
            }
        }
    };

    $.fn.alias = function(inputTextSelector) {
        this.each($.alias.init);
    }
})(jQuery);