jQuery(function($) {

    function initList(list) {
        var left = list.find('.left select');
        var right = list.find('.right select');
        var add = list.find('.center input:eq(0)');
        var remove = list.find('.center input:eq(1)');
        var up = list.find('.right-right input:eq(0)');
        var down = list.find('.right-right input:eq(1)');

        add.click(function(){
            left.find(':selected').appendTo(right);
        });

        remove.click(function(){
            right.find(':selected').appendTo(left);
        });

        left.dblclick(function(){
            left.find(':selected').appendTo(right);
        });

        right.dblclick(function(){
            right.find(':selected').appendTo(left);
        });

        list.closest('form').submit(function(){
            right.find('option').attr('selected', 'selected');
        })

        up.click(function(){
            var selected = right.find(':selected');
            var first = selected.filter(':first');

            if(first.prev().size() == 0)
                return;

            selected.each(function(){
                var option = $(this);

                option.after(option.prev());
            });
        });

        down.click(function(){
            var selected = right.find(':selected');
            var last = selected.filter(':last');

            if(last.next().size() == 0)
                return;

            $( selected.get().reverse() ).each(function(){
                var option = $(this);
                option.before(option.next());
            });
        });
    }

    initList( $('#folders') );
    initList( $('#documents') );

    $('.dataset-relations [name="item[contain_folders]"]').click(function(){
        if($(this).val() == 'custom') {
            $('#folders .inner').slideDown('fast');
        } else {
            $('#folders .inner').slideUp('fast');
        }
    });

    $('.dataset-relations [name="item[contain_documents]"]').click(function(){
        if($(this).val() == 'custom') {
            $('#documents .inner').slideDown('fast');
        } else {
            $('#documents .inner').slideUp('fast');
        }
    });

});