(function($) {
    $.documentsListExtends = {
        dragging: false,
        draggingRows: $,
        createItemSelector: $,
        createItemList: $,
        parent: {},

        init: function() {
            this.initDocumentsDD();
            this.initDocumentsContextMenu();
            this.initMultiUpload();

            var createListItems = this.node.find('.create-item-list .create-item-list-inner a');
            
            if(createListItems.size() > 1)
                this.initCreateItemSelector();
        },

        initDocumentsContextMenu: function() {
            $.contextMenu({
                selector: '.editlist-documents .editlist-table tbody tr',
                items: {
                    enable: {
                        name: 'Показать',
                        disabled: function(key, opt) {
                            var row = opt.$trigger;
                            var eo = row.closest('.editlist').editlist();
                            var selected = eo.getSelectedRowsOnMouse(row, 'click');
                            return selected.filter('.document-disabled').size() == 0;
                        },
                        callback: $.proxy(this._cmEnable, this)
                    },

                    disable: {
                        name: 'Скрыть',
                        disabled: function(key, opt) {
                            var row = opt.$trigger;
                            var eo = row.closest('.editlist').editlist();
                            var selected = eo.getSelectedRowsOnMouse(row, 'click');
                            return selected.filter('.document-enabled').size() == 0;
                        },
                        callback: $.proxy(this._cmDisable, this)
                    },

                    separator1: "-----",

                    cut: {
                        name: 'Вырезать',
                        disabled: function(key, opt) {
                            var row = opt.$trigger;

                            if(row.hasClass('empty'))
                                return true;

                            var eo = row.closest('.editlist').editlist();
                            var selected = eo.getSelectedRowsOnMouse(row, 'click');
                            return selected.size() == 0;
                        },
                        callback: $.proxy(this._cmCut, this)
                    },

                    copy: {
                        name: 'Копировать',
                        disabled: function(key, opt) {
                            var row = opt.$trigger;
                            
                            if(row.hasClass('empty'))
                                return true;

                            var eo = row.closest('.editlist').editlist();
                            var selected = eo.getSelectedRowsOnMouse(row, 'click');
                            return selected.size() == 0;
                        },
                        callback: $.proxy(this._cmCopy, this)
                    },

                    paste: {
                        name: 'Вставить',
                        disabled: function(key, opt) {
                            var admin = document.admin;

                            if(admin.itemsClipboard.isEmpty() || admin.itemsClipboard.getType() != 'document')
                                return true;

                            var row = opt.$trigger;
                            var eo = row.closest('.editlist').editlist();

                            if(!eo.canAppendDocument())
                                return true;

                        },
                        callback: $.proxy(this._cmPaste, this)
                    },

                    separator2: "-----",

                    remove: {
                        name: 'Удалить',
                        disabled: function(key, opt) {
                            var row = opt.$trigger;

                            if(row.hasClass('empty'))
                                return true;

                            return false;
                        },
                        callback: $.proxy(this._cmDelete, this)
                    }

                },

                events: {
                    show: function(opt){
                        var row = $(this);
                        var eo = row.closest('.editlist').editlist();
                        if (row.hasClass('empty') && document.admin.itemsClipboard.isEmpty())
                        {
                            return false;
                        }
                        if(eo.getSelectedRows().size() === 0) {
                            row.addClass('selected');
                        }
                    },

                    hide: function(opt){
                        var row = opt.$trigger;
                        var eo = row.closest('.editlist').editlist();

                        if(eo.getSelectedRows().size() == 0) {
                            row.removeClass('selected');
                        }
                    }
                }
            });
        },

        initDocumentsDD: function() {
            this.rows.draggable({
                cursorAt: {
                    left: -20,
                    top: 0
                },
                zIndex: 3,

                start: function(e) {
                    var row = $(this);
                    var eo = row.closest('.editlist').editlist();

                    eo.dragging = eo.draggingRows.size() > 0; //dragRows inited in helper method

                    if(!eo.dragging)
                        return false;

                    eo.draggingRows.filter(':has(.checkbox input:not(:checked))').addClass('selected');
                },

                stop: function(e) {
                    var row = $(this);
                    var eo = row.closest('.editlist').editlist();

                    eo.draggingRows.filter(':has(.checkbox input:not(:checked))').removeClass('selected');
                    eo.draggingRows = $;
                    eo.dragging = false;
                },

                helper: function(e) {
                    var row = $(this);
                    var eo = row.closest('.editlist').editlist();

                    eo.draggingRows = eo.getSelectedRowsOnMouse(row);

                    if(eo.draggingRows.size() == 0)
                        return false;

                    var c = eo.draggingRows.size();
                    var string = document.admin.plural(c, ['документ', 'документа', 'документов']);
                    // <ins class="jstree-invalid"></ins> @todo document icon
                    var helper = $('<div id="vakata-dragged" class="jstree-dnd-helper jstree-default">' + string + '</div>');

                    return helper;
                }
            });
        },

        initCreateItemSelector: function() {
            this.createItemSelector = this.node.find('.create-item .arrow');
            this.createItemList = this.node.find('.create-item-list');

            this.createItemSelector.click($.proxy(this._createItemSelectorClick, this));
            this.createItemList.find('.item').click($.proxy(this._hideCreateItemMenu, this));
        },

        canAppendDocument: function() {
            return true; // @todo
        },

        _createItemSelectorClick: function() {
            if(this.createItemList.is(':visible'))
                this._hideCreateItemMenu();
            else
                this._showCreateItemMenu();

            return false;
        },

        _rowIds: function(list) {
            var res = [];
            for(var i=0; i < list.size(); i++) {
                var row = list.eq(i);
                res.push(row.attr('rel'));
            }

            return res;
        },

        _showCreateItemMenu: function(){
            this.createItemSelector.addClass('arrow-active');
            this.createItemList.show();

            $(window).bind('click', $.proxy(this._hideCreateItemMenu, this));
        },

        _hideCreateItemMenu: function(){
            this.createItemSelector.removeClass('arrow-active');
            this.createItemList.hide();

            $(document).unbind('click', $.proxy(this._hideCreateItemMenu, this));
        },

        _cmEnable: function(key, opt) {
            this._enableSelected('1', opt.$trigger);
        },

        _cmDisable: function(key, opt) {
            this._enableSelected('', opt.$trigger);
        },

        _enableSelected: function(value, row) {
            var eo = row.closest('.editlist').editlist();
            var selected = eo.getSelectedRowsOnMouse(row, 'click');
            var documentIds = this._rowIds(selected);

            if(documentIds.length == 0)
                return false;

            document.admin.ajaxContentHandlerRequest(
                eo.getUrl(value ? 'group_enable' : 'group_disable'),
                {
                    async : false,
                    type: 'POST',
                    data: {
                        group: documentIds
                    }
                }
            );
        },

        _cmDelete: function(key, opt) {
            var row = opt.$trigger;
            var eo = row.closest('.editlist').editlist();
            var selected = eo.getSelectedRowsOnMouse(row, 'click');
            var documentIds = this._rowIds(selected);
            var admin = document.admin;

            if(documentIds.length == 0)
                return false;

            if(!confirm('Удалить ' + admin.plural(documentIds.length, ['документ', 'документа', 'документов']) + '?'))
                return false;

            document.admin.ajaxContentHandlerRequest(
                eo.getUrl('group_delete'),
                {
                    async : false,
                    type: 'POST',
                    data: {
                        group: documentIds
                    }
                }
            );
        },

        _cmCopy: function(key, opt) {
            var row = opt.$trigger;
            var eo = row.closest('.editlist').editlist();
            var selected = eo.getSelectedRowsOnMouse(row, 'click');
            var documentIds = this._rowIds(selected);
            var admin = document.admin;

            admin.itemsClipboard.put('document', documentIds, 'copy_documents');

            if(documentIds.length > 0) {
                admin.alert(admin.plural(documentIds.length, ['Скопирован', 'Скопировано', 'Скопированы'], false)
                    + ' ' + admin.plural(documentIds.length, ['документ', 'документа', 'документов']))
            }

        },

        _cmCut: function(key, opt) {
            var row = opt.$trigger;
            var eo = row.closest('.editlist').editlist();
            var selected = eo.getSelectedRowsOnMouse(row, 'click');
            var documentIds = this._rowIds(selected);
            var admin = document.admin;

            admin.itemsClipboard.put('document', documentIds, 'move_documents');

            if(documentIds.length > 0) {
                admin.alert(admin.plural(documentIds.length, ['Вырезан', 'Вырезано', 'Вырезаны'], false)
                    + ' ' + admin.plural(documentIds.length, ['документ', 'документа', 'документов']))
            }

        },

        _cmPaste: function(key, opt) {
            var admin = document.admin;

            if(admin.itemsClipboard.isEmpty() || admin.itemsClipboard.getType() != 'document')
                return;

            var row = opt.$trigger;
            var eo = row.closest('.editlist').editlist();
            var ids = admin.itemsClipboard.getIds();
            var target = eo.parent.id;

            $.ajax({
                url: admin.baseUrl + 'structure_tree/' + admin.itemsClipboard.action + '/',
                async : false,
                type: 'POST',
                data: {
                    target: target,
                    ids: ids
                },

                success : function (r) {
                    var r = $.parseJSON(r);

                    if(r.messages){
                        document.admin.handleMessages(r.messages);
                    }

                    if(r.success)
                        document.admin.refresh();
                },
                error: function(r) {
                    document.admin.error(r);
                }
            });
        },



        /* multi upload */

        multiDropZone: null,
        multiUpload: null,
        multiUploadUrl: null,
        multiUploading: false,
        multiDeleteUrl: null,
        multiFileIndex: 0,

        initMultiUpload: function() {
            var oldIE = $.browser.msie && $.browser.version < 10;

            if(oldIE)
                return;

            this.multiDropZone = $('#docuemnts-multi-dropzone');
            this.multiUpload = $('#docuemnts-multi-upload');

            if(!this.multiDropZone.size())
                return;

            $(document).bind('dragover', $.proxy(this.onDragStart, this));
            // $(document).bind('dragleave', $.proxy(this.onDragEnd, this));
            this.multiDropZone.bind('dragover', $.proxy(this.onDragOver, this));
            this.multiDropZone.bind('dragleave', $.proxy(this.onDragLeave, this));
            this.multiDropZone[0].ondrop = $.proxy(this.onDrop, this);
            this.multiUpload[0].ondrop = $.proxy(this.onDrop, this);

            document.admin.unload($.proxy(function(){
                $(document).unbind('dragover');
                $(document).unbind('dragleave');
                this.multiDropZone.unbind('dragover');
                this.multiDropZone.unbind('dragleave');
            }, this));

            this.multiUpload.find('.close').click(function(){
                document.overlay.hide();
            });

            this.multiDropZone.find('.close').click(function(){
                document.overlay.hide();
            });

            this.multiUpload.find('.buttons .reset').click($.proxy(function(){
                if(confirm('Очистить список?'))
                    this.multiUploadClear();
            }, this));

            this.multiUpload.submit($.proxy(function(){
                this.multiUpload.find('.list .item').addClass('item-saved');
                setTimeout(function(){
                    document.overlay.hide();
                }, 500);
            }, this));

            this.multiUpload.find('.list').sortable({ tolerance: "pointer" });
            this.multiUpload.find('.list').disableSelection();
        },

        multiUploadClose: function()
        {
            this.multiUploadClear();

            this.multiDropZone.hide();
            this.multiDropZone.removeClass('hover');
            this.multiUpload.hide();
            document.overlay.hide();
        },

        multiUploadClear: function()
        {
            this.multiUpload.find('.list .item').each($.proxy(function(i, dom){
                this.multiUploadDelete(dom);
            }, this));
        },

        updateDragKey:function () {
            var dragKey = Math.round(Math.random() * 100000);
            this.multiDropZone.data('dragKey', dragKey);
            return dragKey;
        },

        onDragStart:function (e) {
            this.updateDragKey();

            document.overlay.show();
            this.multiDropZone.show();

            this.multiDropZone.appendTo(document.overlay.node);
            this.multiUpload.appendTo(document.overlay.node);

            document.overlay.node.one('hidden', $.proxy(function () {
                this.multiUploadClose();
            }, this));

            return false;
        },

        onDragEnd:function () {
            var dragKey = this.updateDragKey();

            setTimeout($.proxy(function () {
                if (dragKey === this.multiDropZone.data('dragKey')) {
                    if(this.multiUpload.find('.list .item').size() == 0) {
                        document.overlay.hide();
                    } else {
                        this.multiDropZone.hide();
                        this.multiDropZone.removeClass('hover');
                    }
                }
            }, this), 500);

            return false;
        },

        onDragOver:function () {
            this.updateDragKey();
            this.multiDropZone.addClass('hover');
            return false;
        },

        onDragLeave:function (e) {
            this.updateDragKey();
            this.multiDropZone.removeClass('hover');
            return false;

        },



        multiUploadAddFile: function(file) {
            this.multiFileIndex++;

            var node = $('<div class="item item-unloaded"></div>');
            node.append('<div class="ui-icons ui-widget ui-state-error icon-collection delete"><span class="ui-icon ui-icon-close"></span></div>');
            node.append('<div class="image"></div>');
            node.append('<div class="title"><span>' + file.name + '</span></div>');
            node.append('<div class="status"><span class="ui-state-default"><span class="default ui-icon ui-icon-clock"></span></span>В очереди</div>');
            node.append('<input class="id" type="hidden" name="file[' + this.multiFileIndex + '][id]" />');
            node.append('<input class="name" type="hidden" name="file[' + this.multiFileIndex + '][name]" value="' + file.name + '" />');
            node.find('.delete').click($.proxy(function(e){
                var node = $(e.target).closest('.item');
                this.multiUploadDelete(node);
            }, this));

            var tmp = file.name.match(/\.(.*)$/);
            if(tmp) {
                var ext = tmp[1];
                node.find('.image').append('<div class="ext ext-' + ext +'">' + ext +  '</div>');
            }


            this.multiUpload.find('.list').append(node);
            file.node = node;
            node.data('file', file);
            this.multiUploadStart();
        },

        multiUploadDelete: function(node)
        {
            node = $(node);

            if(!node.hasClass('item-unloaded') && !node.hasClass('item-saved')) {
                $.ajax({
                    type:'post',
                    url: this.multiDeleteUrl,
                    method:'post',
                    data: {
                        file_id: node.find('.id').val()
                    },
                    failure:function () {
                        document.admin.error('Ошибка при удалении файла!')
                    }
                });
            }

            node.remove();
            this.multiUploadUpdateStatus();
        },

        multiUploadStart: function()
        {
            if(this.multiUploading)
                return;


            var node = this.multiUpload.find('.list .item-unloaded:first');

            if(node.size() == 0)
                return;

            var file = node.data('file');
            this.multiUploading = true;
            this.multiUploadUpdateStatus();

            var formData = new FormData;
            formData.append('file', file);
            formData.append('input_name', 'file');

            node.find('.status').html('<span class="ui-state-default"><span class="default ui-icon ui-icon-refresh"></span>Загрузка...<span class="percent"></span></span>');

            var xhr = new XMLHttpRequest();
            xhr.upload.addEventListener('progress', $.proxy(this.multiUploadProgress, file), false);
            xhr.onreadystatechange = $.proxy(function(e) {
                var xhr = e.target

                if (xhr.readyState == 4) {
                    node.removeClass('item-unloaded');

                    if (e.target.status == 200)
                        this.multiUploadSuccess(file, xhr.responseText);
                    else
                        this.multiUploadFailure(file, xhr.responseText);

                    this.multiUploading = false;
                    this.multiUploadStart();
                    this.multiUploadUpdateStatus();
                }
            }, this);

            xhr.open('POST', this.multiUploadUrl);
            xhr.send(formData);
        },

        onDrop:function (e) {
            e.preventDefault();
            var files = e.dataTransfer.files;
            this.onDragEnd();

            if (files.length == 0) {
                this.onDragEnd();
                return;
            }

            document.overlay.show();
            this.multiUpload.show();

            this.multiDropZone.appendTo(document.overlay.node);
            this.multiUpload.appendTo(document.overlay.node);


            for(var i=0; i < files.length; i++) {
                var file = e.dataTransfer.files[i];
                this.multiUploadAddFile(file);
            }
        },

        multiUploadProgress: function (e) {
            this.node.find('.status .percent').html( parseInt(e.loaded / e.total * 100) + "%" );
        },

        multiUploadSuccess: function (file, responseText) {
            var data = $.parseJSON(responseText);
            document.admin.handleMessages(data.messages);

            if(!data.success) {
                file.node.find('.status').html('<span class="ui-state-error"><span class="default ui-icon ui-icon-notice"></span>Ошибка</span>');
                return;
            }


            var uploadedFile = data.file;
            var image = false;

            file.node.find('.status').html('');
            file.node.find('.id').val(uploadedFile.id);


            if(uploadedFile.isImage && uploadedFile.children) {
                var found = false;
                var key = 'admin_default';
                for (var i = 0; i < uploadedFile.children.length; i++) {
                    var resize = uploadedFile.children[i];

                    if (resize.key == key) {
                        found = true;
                        break;
                    }
                }

                var image = found ? resize : uploadedFile;
            }

            if(image) {
                var img = $('<img src="' + image.url + '" />');
                img.load(function(){
                    var img = $(this);
                    img.css('margin-top', parseInt( (90 -  img.height()) / 2) + 'px' );
                });
                file.node.find('.image').html('').append(img);
            }
        },

        multiUploadFailure: function (file, respnseText) {
            document.admin.error(respnseText);
            file.node.find('.status').html('<span class="ui-state-error"><span class="default ui-icon ui-icon-notice"></span>Ошибка</span>');
        },

        multiUploadUpdateStatus: function()
        {
            var items = this.multiUpload.find('.list .item');
            var submit = this.multiUpload.find('.buttons .submit');
            var reset = this.multiUpload.find('.buttons .reset');

            var canSubmit = !this.multiUploading && items.size() > 0;

            if(canSubmit) {
                submit.removeAttr('disabled');
                submit.removeClass('input-disabled');
            } else {
                submit.attr('disabled', 'disabled');
                submit.addClass('input-disabled');
            }

            if(items.size() > 0) {
                reset.removeAttr('disabled');
                reset.removeClass('input-disabled');
            } else {
                reset.attr('disabled', 'disabled');
                reset.addClass('input-disabled');
            }

            if(items.size() == 0 && document.overlay.node.is(':visible'))
                this.multiDropZone.show();
        }
    },
    $.fn.documents = function(options) {
        var options = $.extend($.documentsListExtends, options);
        return this.editlist(options);
    }
})(jQuery);