(function($) {
    $.subscribeSources = {
        node: null,
        list: null,
        sources: [],
        addButton: null,
        name: '',
        index: 0,

        createRow: function(key) {
            var row = $(
                '<div class="ss-row"><div class="clearfix">' +
                    '<div class="ui-icons ui-widget icon-collection" style="float: right;">' +
                        '<a href="#" class="delete ui-state-error ui-corner-all" title="Удалить"><span class="ui-icon ui-icon-closethick"></span></a>' +
                    '</div>' +
                    '<select name="' + this.name + '[' + this.index + ']" style="width: 300px; margin-right: 10px;">' +
                        '<option value="">(Добавить)</option>' +
                    '</select>' +
                '</div></div>'
            );

            var select = row.find('select');
            select.change(this._sourceChange);
            select.focus(this._sourceFocus);
            var deleteNode = row.find('.delete');
            deleteNode.click(this._rowDeleteClick);

            for(var i = 0; i < this.sources.length; i++) {
                var source = this.sources[i];
                select.append('<option value="' + source.key + '">' + source.title + '</option>');
            }

            row.data('ss', this);
            this.index++;

            if(key !== undefined)
                select.val(key);

            return row;
        },

        addRow: function(key) {
            var row = this.createRow(key);
            this.list.append(row);

            this._hideDelete();
        },

        setDummy: function() {
            this.list.append('<input type="hidden"  name="' + this.name + '[dummy]" value="" />');
        },

        _hideDelete: function() {
            if(this.list.find('.ss-row').size() == 1)
                this.list.find('.delete').hide();
            else
                this.list.find('.delete').show();
        },

        _sourceChange: function() {
            var select = $(this);
            var row = select.closest('.ss-row');
            var ss = row.data('ss');

            if(row.next('.ss-row').size() == 0)
                ss.addRow();
        },

        _addButtonClick: function() {
            this.addRow();
            return false;
        },

        _rowDeleteClick: function() {
            var row = $(this).closest('.ss-row');
            var ss = row.data('ss');

            row.remove();
            ss._hideDelete();

            return false;
        },

        init: function() {
            this.list = this.node.find('.ss-list');
            this.addButton = this.node.find('.ss-add');
            this.addButton.click($.proxy(this._addButtonClick, this));
            this.setDummy();
            this.list.sortable();
        }
    };

    $.fn.subscribeSources = function(options) {
        var node = this;

        if(options === undefined) {
            options = {};
        }

        if(!node.data('subscribeSources')) {
            var ss = $.extend(true, {}, $.subscribeSources); // clone
            var ss = $.extend(ss, options);
            ss.node = node;

            ss.init();
            
            node.data('subscribeSources', ss);
        }

        return node.data('subscribeSources');
    }
})(jQuery);